/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hive.service.auth.AuthType;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthType {
    @Test
    public void testSingleAuth() throws Exception {
        for (HiveAuthConstants.AuthTypes type : HiveAuthConstants.AuthTypes.values()) {
            this.testSingleAuth(type);
        }
    }

    private void testSingleAuth(HiveAuthConstants.AuthTypes type) throws Exception {
        AuthType authType = new AuthType(type.getAuthName(), HiveServer2TransportMode.http);
        Assert.assertTrue((boolean)authType.isEnabled(type));
        if (type == HiveAuthConstants.AuthTypes.NOSASL || type == HiveAuthConstants.AuthTypes.NONE || AuthType.PASSWORD_BASED_TYPES.contains(type)) {
            Assert.assertEquals((Object)type.getAuthName(), (Object)authType.getPasswordBasedAuthStr());
        } else {
            Assert.assertEquals((String)"Should return empty string if no password based authentication is set.", (Object)"", (Object)authType.getPasswordBasedAuthStr());
        }
    }

    @Test
    public void testOnePasswordAuthWithSAML() throws Exception {
        this.testOnePasswordAuthWithSAML(HiveAuthConstants.AuthTypes.LDAP);
        this.testOnePasswordAuthWithSAML(HiveAuthConstants.AuthTypes.PAM);
        this.testOnePasswordAuthWithSAML(HiveAuthConstants.AuthTypes.CUSTOM);
    }

    @Test
    public void testOnePasswordAuthWithJWT() throws Exception {
        this.testOnePasswordAuthWithJWT(HiveAuthConstants.AuthTypes.LDAP);
        this.testOnePasswordAuthWithJWT(HiveAuthConstants.AuthTypes.PAM);
        this.testOnePasswordAuthWithJWT(HiveAuthConstants.AuthTypes.CUSTOM);
    }

    private void testOnePasswordAuthWithSAML(HiveAuthConstants.AuthTypes type) throws Exception {
        AuthType authType = new AuthType("SAML," + type.getAuthName(), HiveServer2TransportMode.http);
        Assert.assertTrue((boolean)authType.isEnabled(HiveAuthConstants.AuthTypes.SAML));
        Assert.assertTrue((boolean)authType.isEnabled(type));
        Set disabledAuthTypes = Arrays.stream(HiveAuthConstants.AuthTypes.values()).collect(Collectors.toSet());
        disabledAuthTypes.remove(HiveAuthConstants.AuthTypes.SAML);
        disabledAuthTypes.remove(type);
        for (HiveAuthConstants.AuthTypes disabledType : disabledAuthTypes) {
            Assert.assertFalse((boolean)authType.isEnabled(disabledType));
        }
        Assert.assertEquals((Object)type.getAuthName(), (Object)authType.getPasswordBasedAuthStr());
        this.verify("SAML," + type.getAuthName(), HiveServer2TransportMode.binary, true);
        this.verify("SAML," + type.getAuthName(), HiveServer2TransportMode.all, true);
    }

    private void verify(String authTypes, HiveServer2TransportMode mode, boolean shouldThrowException) {
        try {
            AuthType authType = new AuthType(authTypes, mode);
            if (shouldThrowException) {
                Assert.fail((String)("HiveServer2 " + mode.name() + " mode cann't support " + authTypes + " by design"));
            } else {
                String[] authMethods = authTypes.split(",");
                for (int i = 0; i < authMethods.length; ++i) {
                    HiveAuthConstants.AuthTypes authMech = (HiveAuthConstants.AuthTypes)EnumUtils.getEnumIgnoreCase(HiveAuthConstants.AuthTypes.class, (String)authMethods[i]);
                    Assert.assertTrue((boolean)authType.isEnabled(authMech));
                }
            }
        }
        catch (Exception e) {
            if (!shouldThrowException) {
                Assert.fail((String)("HiveServer2 " + mode.name() + " mode should be able to support " + authTypes));
            }
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
    }

    private void testOnePasswordAuthWithJWT(HiveAuthConstants.AuthTypes type) throws Exception {
        AuthType authType = new AuthType("JWT," + type.getAuthName(), HiveServer2TransportMode.http);
        Assert.assertTrue((boolean)authType.isEnabled(HiveAuthConstants.AuthTypes.JWT));
        Assert.assertTrue((boolean)authType.isEnabled(type));
        Set disabledAuthTypes = Arrays.stream(HiveAuthConstants.AuthTypes.values()).collect(Collectors.toSet());
        disabledAuthTypes.remove(HiveAuthConstants.AuthTypes.JWT);
        disabledAuthTypes.remove(type);
        for (HiveAuthConstants.AuthTypes disabledType : disabledAuthTypes) {
            Assert.assertFalse((boolean)authType.isEnabled(disabledType));
        }
        Assert.assertEquals((Object)type.getAuthName(), (Object)authType.getPasswordBasedAuthStr());
        this.verify("JWT," + type.getAuthName(), HiveServer2TransportMode.binary, true);
        this.verify("JWT," + type.getAuthName(), HiveServer2TransportMode.all, true);
    }

    @Test
    public void testMultipleAuthMethods() {
        ImmutableSet entries = ImmutableSet.of((Object)new EntryForTest("KERBEROS,SAML", HiveServer2TransportMode.binary, true), (Object)new EntryForTest("KERBEROS,SAML", HiveServer2TransportMode.http, false), (Object)new EntryForTest("KERBEROS,SAML,LDAP", HiveServer2TransportMode.all, true), (Object)new EntryForTest("KERBEROS,SAML,LDAP", HiveServer2TransportMode.http, false), (Object)new EntryForTest("KERBEROS,LDAP", HiveServer2TransportMode.all, false), (Object)new EntryForTest("NONE,SAML", HiveServer2TransportMode.all, true), (Object[])new EntryForTest[]{new EntryForTest("NONE,SAML", HiveServer2TransportMode.http, true), new EntryForTest("NOSASL,SAML", HiveServer2TransportMode.all, true), new EntryForTest("SAML,LDAP,PAM,CUSTOM", HiveServer2TransportMode.http, true), new EntryForTest("SAML,OTHER", HiveServer2TransportMode.all, true), new EntryForTest("LDAP,PAM,CUSTOM", HiveServer2TransportMode.binary, true), new EntryForTest("KERBEROS,JWT", HiveServer2TransportMode.binary, true), new EntryForTest("KERBEROS,JWT", HiveServer2TransportMode.http, false), new EntryForTest("KERBEROS,JWT,LDAP", HiveServer2TransportMode.http, false), new EntryForTest("KERBEROS,JWT,LDAP", HiveServer2TransportMode.all, true), new EntryForTest("NONE,JWT", HiveServer2TransportMode.all, true), new EntryForTest("NOSASL,JWT", HiveServer2TransportMode.http, true), new EntryForTest("JWT,LDAP,PAM,CUSTOM", HiveServer2TransportMode.http, true), new EntryForTest("JWT,SAML,LDAP", HiveServer2TransportMode.http, false), new EntryForTest("JWT,SAML,LDAP", HiveServer2TransportMode.all, true), new EntryForTest("JWT,SAML", HiveServer2TransportMode.http, false), new EntryForTest("JWT,SAML", HiveServer2TransportMode.binary, true)});
        for (EntryForTest entry : entries) {
            this.verify(entry.authTypes, entry.mode, entry.shouldThrowException);
        }
    }

    private class EntryForTest {
        String authTypes;
        HiveServer2TransportMode mode;
        boolean shouldThrowException;

        EntryForTest(String authTypes, HiveServer2TransportMode mode, boolean shouldThrowException) {
            this.authTypes = authTypes;
            this.mode = mode;
            this.shouldThrowException = shouldThrowException;
        }
    }
}

