/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import java.util.Random;
import org.apache.hive.service.CookieSigner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCookieSigner {
    private static final Random RAN = new Random();
    private CookieSigner cs;

    @Before
    public void setUp() {
        this.cs = new CookieSigner(Long.toString(RAN.nextLong()).getBytes());
    }

    @Test
    public void testVerifyAndExtract() {
        String originalStr = "cu=scott";
        String signedStr = this.cs.signCookie(originalStr);
        Assert.assertEquals((Object)originalStr, (Object)this.cs.verifyAndExtract(signedStr));
    }

    @Test
    public void testVerifyAndExtractNoSignature() {
        String originalStr = "cu=scott";
        String signedStr = this.cs.signCookie(originalStr);
        String modifedSignedStr = signedStr.replace("&s=", "");
        try {
            this.cs.verifyAndExtract(modifedSignedStr);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Invalid input sign: " + modifedSignedStr), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Expected IllegalArgumentException due to no signature");
    }

    @Test
    public void testVerifyAndExtractInvalidSignature() {
        String originalStr = "cu=scott";
        String signedStr = this.cs.signCookie(originalStr);
        String modifedSignedStr = signedStr.replace("&s=", "&s=abc");
        try {
            this.cs.verifyAndExtract(modifedSignedStr);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid sign= "));
            return;
        }
        Assert.fail((String)"Expected IllegalArgumentException checking signature");
    }
}

