/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadPoolExecutorWithOomHook
extends ThreadPoolExecutor {
    public static final Logger LOG = LoggerFactory.getLogger((String)ThreadPoolExecutorWithOomHook.class.getName());
    private final Runnable oomHook;

    public ThreadPoolExecutorWithOomHook(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Runnable oomHook) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.oomHook = oomHook;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t2) {
                t = t2;
            }
        }
        if (this.isOutOfMemoryError(t)) {
            LOG.error("Stopping HiveServer2 due to OOM", t);
            this.oomHook.run();
        }
    }

    @VisibleForTesting
    boolean isOutOfMemoryError(Throwable t) {
        if (t == null || t instanceof OutOfMemoryError) {
            return t instanceof OutOfMemoryError;
        }
        return this.isOutOfMemoryError(t.getCause());
    }
}

