/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Operation {
    protected final HiveSession parentSession;
    protected boolean embedded;
    private volatile OperationState state = OperationState.INITIALIZED;
    private volatile MetricsScope currentStateScope;
    private final OperationHandle opHandle;
    public static final FetchOrientation DEFAULT_FETCH_ORIENTATION = FetchOrientation.FETCH_NEXT;
    public static final Logger LOG = LoggerFactory.getLogger((String)Operation.class.getName());
    protected Boolean hasResultSet = null;
    protected volatile HiveSQLException operationException;
    protected volatile Future<?> backgroundHandle;
    protected OperationLog operationLog;
    protected boolean isOperationLogEnabled;
    private ScheduledExecutorService scheduledExecutorService;
    private long operationTimeout;
    private volatile long lastAccessTime;
    private final long beginTime;
    private final CountDownLatch opTerminateMonitorLatch;
    protected long operationStart;
    protected long operationComplete;
    protected final QueryState queryState;
    protected static final EnumSet<FetchOrientation> DEFAULT_FETCH_ORIENTATION_SET = EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST);
    protected static Set<OperationState> scopeStates = Sets.immutableEnumSet((Enum)OperationState.INITIALIZED, (Enum[])new OperationState[]{OperationState.PENDING, OperationState.RUNNING});
    protected static Set<OperationState> terminalStates = Sets.immutableEnumSet((Enum)OperationState.CLOSED, (Enum[])new OperationState[]{OperationState.CANCELED, OperationState.FINISHED, OperationState.ERROR, OperationState.UNKNOWN});

    protected Operation(HiveSession parentSession, OperationType opType) {
        this(parentSession, null, opType);
    }

    protected Operation(HiveSession parentSession, Map<String, String> confOverlay, OperationType opType) {
        this(parentSession, confOverlay, opType, false);
    }

    protected Operation(HiveSession parentSession, Map<String, String> confOverlay, OperationType opType, boolean embedded) {
        this.parentSession = parentSession;
        this.embedded = embedded;
        this.opHandle = new OperationHandle(opType, parentSession.getProtocolVersion());
        this.opTerminateMonitorLatch = new CountDownLatch(1);
        this.lastAccessTime = this.beginTime = System.currentTimeMillis();
        this.operationTimeout = HiveConf.getTimeVar((Configuration)parentSession.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.currentStateScope = this.updateOperationStateMetrics(null, "hs2_operation_", "hs2_completed_operation_", this.state);
        this.queryState = new QueryState.Builder().withConfOverlay(confOverlay).withGenerateNewQueryId(!embedded).withHiveConf(parentSession.getHiveConf()).build();
    }

    public Future<?> getBackgroundHandle() {
        return this.backgroundHandle;
    }

    protected void setBackgroundHandle(Future<?> backgroundHandle) {
        this.backgroundHandle = backgroundHandle;
    }

    public boolean shouldRunAsync() {
        return false;
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.opHandle.getProtocolVersion();
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationStatus getStatus() {
        String taskStatus = null;
        try {
            taskStatus = this.getTaskStatus();
        }
        catch (HiveSQLException sqlException) {
            LOG.error("Error getting task status for " + this.opHandle.toString(), (Throwable)sqlException);
        }
        return new OperationStatus(this.state, taskStatus, this.operationStart, this.operationComplete, this.hasResultSet, this.operationException);
    }

    public boolean hasResultSet() {
        return this.hasResultSet == null ? false : this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    public OperationLog getOperationLog() {
        return this.operationLog;
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        OperationState prevState = this.state;
        this.state = newState;
        this.currentStateScope = this.updateOperationStateMetrics(this.currentStateScope, "hs2_operation_", "hs2_completed_operation_", this.state);
        this.onNewState(this.state, prevState);
        this.lastAccessTime = System.currentTimeMillis();
        return this.state;
    }

    public boolean isTimedOut(long current) {
        if (this.operationTimeout == 0L) {
            return false;
        }
        if (this.operationTimeout > 0L) {
            return this.state.isTerminal() && this.lastAccessTime + this.operationTimeout <= current;
        }
        return this.lastAccessTime + -this.operationTimeout <= current;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public long getNumModifiedRows() {
        return this.queryState.getNumModifiedRows();
    }

    protected void setOperationException(HiveSQLException operationException) {
        this.operationException = operationException;
    }

    protected final void assertState(List<OperationState> states) throws HiveSQLException {
        if (!states.contains((Object)this.state)) {
            throw new HiveSQLException("Expected states: " + states.toString() + ", but found " + (Object)((Object)this.state));
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isDone() {
        return this.state.isTerminal();
    }

    public boolean waitToTerminate(long timeOutMs) throws InterruptedException {
        return this.opTerminateMonitorLatch.await(timeOutMs, TimeUnit.MILLISECONDS);
    }

    protected void createOperationLog() {
        if (this.parentSession.isOperationLogEnabled()) {
            File operationLogFile = new File(this.parentSession.getOperationLogSessionDir(), this.queryState.getQueryId());
            this.isOperationLogEnabled = true;
            this.operationLog = new OperationLog(this.opHandle.toString(), operationLogFile, this.parentSession.getHiveConf());
        }
    }

    protected void beforeRun() {
        ShimLoader.getHadoopShims().setHadoopQueryContext(String.format("%s_User:%s", this.queryState.getQueryId(), this.parentSession.getUserName()));
        if (!this.embedded) {
            ShimLoader.getHadoopShims().setHadoopQueryContext(this.queryState.getQueryId());
            this.createOperationLog();
            LogUtils.registerLoggingContext((Configuration)this.queryState.getConf());
        }
        LOG.info("[opType={}, queryId={}, startTime={}, sessionId={}, createTime={}, userName={}, ipAddress={}]", new Object[]{this.opHandle.getOperationType(), this.queryState.getQueryId(), this.beginTime, this.parentSession.getSessionState().getSessionId(), this.parentSession.getCreationTime(), this.parentSession.getUserName(), this.parentSession.getIpAddress()});
    }

    protected void afterRun() {
        if (!this.embedded) {
            LogUtils.unregisterLoggingContext();
        }
        ShimLoader.getHadoopShims().setHadoopSessionContext(String.format("%s_User:%s", this.parentSession.getSessionState().getSessionId(), this.parentSession.getUserName()));
    }

    protected abstract void runInternal() throws HiveSQLException;

    public void run() throws HiveSQLException {
        this.beforeRun();
        try {
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                metrics.incrementCounter("open_operations");
            }
            this.runInternal();
        }
        finally {
            this.afterRun();
        }
    }

    protected synchronized void cleanupOperationLog(long operationLogCleanupDelayMs) {
        if (this.isOperationLogEnabled) {
            if (this.opHandle == null) {
                LOG.warn("Operation seems to be in invalid state, opHandle is null");
                return;
            }
            if (this.operationLog == null) {
                LOG.warn("Operation [ " + this.opHandle.getHandleIdentifier() + " ] logging is enabled, but its OperationLog object cannot be found. Perhaps the operation has already terminated.");
            } else if (operationLogCleanupDelayMs > 0L) {
                this.scheduledExecutorService.schedule(new OperationLogCleaner(this.operationLog), operationLogCleanupDelayMs, TimeUnit.MILLISECONDS);
            } else {
                LOG.info("Closing operation log {} without delay", (Object)this.operationLog);
                this.operationLog.close();
            }
        }
    }

    public abstract void cancel(OperationState var1) throws HiveSQLException;

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public String getTaskStatus() throws HiveSQLException {
        return null;
    }

    protected void validateDefaultFetchOrientation(FetchOrientation orientation) throws HiveSQLException {
        this.validateFetchOrientation(orientation, DEFAULT_FETCH_ORIENTATION_SET);
    }

    protected void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        if (!supportedOrientations.contains((Object)orientation)) {
            throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
        }
    }

    protected HiveSQLException toSQLException(String prefix, CommandProcessorException e) {
        HiveSQLException ex = new HiveSQLException(prefix + ": " + e.getErrorMessage(), e.getSqlState(), e.getResponseCode());
        if (e.getException() != null) {
            ex.initCause(e.getException());
        }
        return ex;
    }

    protected final MetricsScope updateOperationStateMetrics(MetricsScope stateScope, String operationPrefix, String completedOperationPrefix, OperationState state) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            if (stateScope != null) {
                metrics.endScope(stateScope);
                stateScope = null;
            }
            if (scopeStates.contains((Object)state)) {
                stateScope = metrics.createScope("api_" + operationPrefix + (Object)((Object)state));
            }
            if (terminalStates.contains((Object)state)) {
                metrics.incrementCounter(completedOperationPrefix + (Object)((Object)state));
            }
        }
        return stateScope;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected OperationState getState() {
        return this.state;
    }

    protected void onNewState(OperationState state, OperationState prevState) {
        switch (state) {
            case RUNNING: {
                this.markOperationStartTime();
                break;
            }
            case ERROR: 
            case FINISHED: 
            case CANCELED: {
                this.markOperationCompletedTime();
            }
        }
        if (state.isTerminal()) {
            this.opTerminateMonitorLatch.countDown();
        }
    }

    public long getOperationComplete() {
        return this.operationComplete;
    }

    public long getOperationStart() {
        return this.operationStart;
    }

    protected void markOperationStartTime() {
        this.operationStart = System.currentTimeMillis();
    }

    protected void markOperationCompletedTime() {
        this.operationComplete = System.currentTimeMillis();
    }

    public String getQueryTag() {
        return this.queryState.getQueryTag();
    }

    public String getQueryId() {
        return this.queryState.getQueryId();
    }

    private static class OperationLogCleaner
    implements Runnable {
        public static final Logger LOG = LoggerFactory.getLogger((String)OperationLogCleaner.class.getName());
        private OperationLog operationLog;

        public OperationLogCleaner(OperationLog operationLog) {
            this.operationLog = operationLog;
        }

        @Override
        public void run() {
            if (this.operationLog != null) {
                LOG.info("Closing operation log {}", (Object)this.operationLog);
                this.operationLog.close();
            }
        }
    }
}

