/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUgiFactory;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;

public class LlapUgiHelper {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    public static LlapUgiFactory createLlapUgiFactory(Configuration conf) throws IOException {
        boolean hasFsPrincipal;
        String fsKeytab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_FS_KERBEROS_KEYTAB_FILE);
        String fsPrincipal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_FS_KERBEROS_PRINCIPAL);
        boolean hasFsKeytab = fsKeytab != null && !fsKeytab.isEmpty();
        boolean bl = hasFsPrincipal = fsPrincipal != null && !fsPrincipal.isEmpty();
        if (hasFsKeytab != hasFsPrincipal) {
            throw new IOException("Inconsistent FS keytab settings " + fsKeytab + "; " + fsPrincipal);
        }
        return hasFsKeytab ? new KerberosLlapUgiFactory(fsKeytab, fsPrincipal) : new NoopLlapUgiFactory();
    }

    private static class NoopLlapUgiFactory
    implements LlapUgiFactory {
        private NoopLlapUgiFactory() {
        }

        @Override
        public UserGroupInformation createUgi(String user) throws IOException {
            return SHIMS.cloneUgi(UserGroupInformation.createRemoteUser((String)user));
        }
    }

    private static class KerberosLlapUgiFactory
    implements LlapUgiFactory {
        private final UserGroupInformation baseUgi;

        public KerberosLlapUgiFactory(String keytab, String principal) throws IOException {
            this.baseUgi = LlapUtil.loginWithKerberos((String)principal, (String)keytab);
        }

        @Override
        public UserGroupInformation createUgi(String user) throws IOException {
            this.baseUgi.checkTGTAndReloginFromKeytab();
            return SHIMS.cloneUgi(this.baseUgi);
        }
    }
}

