/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.counters.FragmentCountersMap;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.daemon.impl.StatsRecordingThreadPool;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.OrcConf;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class LlapRecordReader
implements RecordReader<NullWritable, VectorizedRowBatch>,
Consumer<ColumnVectorBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapRecordReader.class);
    private static final Object DONE_OBJECT = new Object();
    private final FileSplit split;
    private final IncludesImpl includes;
    private final SearchArgument sarg;
    private final VectorizedRowBatchCtx rbCtx;
    private final boolean isVectorized;
    private final boolean probeDecodeEnabled;
    private VectorizedOrcAcidRowBatchReader acidReader;
    private Object[] partitionValues;
    private VectorizedRowBatch acidInputVrb;
    private final ArrayBlockingQueue<Object> queue;
    private final AtomicReference<Throwable> pendingError = new AtomicReference<Object>(null);
    private ColumnVectorBatch lastCvb = null;
    private boolean isFirst = true;
    private int maxQueueSize = 0;
    private volatile boolean isClosed = false;
    private volatile boolean isInterrupted = false;
    private final ConsumerFeedback<ColumnVectorBatch> feedback;
    private final QueryFragmentCounters counters;
    private long firstReturnTime;
    private final JobConf jobConf;
    private final ReadPipeline rp;
    private final ExecutorService executor;
    private final boolean isAcidScan;
    private final boolean isAcidFormat;
    private final BucketIdentifier bucketIdentifier;
    private static final int COL_WEIGHT_COMPLEX = 16;
    private static final int COL_WEIGHT_HIVEDECIMAL = 10;
    private static final int COL_WEIGHT_STRING = 8;

    public static LlapRecordReader create(JobConf job, FileSplit split, List<Integer> tableIncludedCols, String hostName, ColumnVectorProducer cvp, ExecutorService executor, InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe, Reporter reporter, Configuration daemonConf) throws IOException, HiveException {
        MapWork mapWork = LlapHiveUtils.findMapWork((JobConf)job);
        if (mapWork == null) {
            return null;
        }
        LlapRecordReader rr = new LlapRecordReader(mapWork, job, split, tableIncludedCols, hostName, cvp, executor, sourceInputFormat, sourceSerDe, reporter, daemonConf);
        if (!rr.checkOrcSchemaEvolution()) {
            rr.close();
            LlapHiveUtils.throwIfCacheOnlyRead((boolean)HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_CACHE_ONLY));
            return null;
        }
        return rr;
    }

    private LlapRecordReader(MapWork mapWork, JobConf job, FileSplit split, List<Integer> tableIncludedCols, String hostName, ColumnVectorProducer cvp, ExecutorService executor, InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe, Reporter reporter, Configuration daemonConf) throws IOException, HiveException {
        this.executor = executor;
        this.jobConf = job;
        this.split = split;
        this.sarg = ConvertAstToSearchArg.createFromConf((Configuration)job);
        String fragmentId = LlapTezUtils.getFragmentId((JobConf)job);
        String dagId = LlapTezUtils.getDagId((JobConf)job);
        String queryId = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        MDC.put((String)"dagId", (String)dagId);
        MDC.put((String)"queryId", (String)queryId);
        TezCounters taskCounters = null;
        if (fragmentId != null) {
            MDC.put((String)"fragmentId", (String)fragmentId);
            taskCounters = FragmentCountersMap.getCountersForFragment(fragmentId);
            LOG.info("Received fragment id: {}", (Object)fragmentId);
        } else {
            LOG.warn("Not using tez counters as fragment id string is null");
        }
        this.counters = new QueryFragmentCounters((Configuration)job, taskCounters);
        this.counters.setDesc(QueryFragmentCounters.Desc.MACHINE, hostName);
        VectorizedRowBatchCtx ctx = mapWork.getVectorizedRowBatchCtx();
        this.rbCtx = ctx != null ? ctx : LlapInputFormat.createFakeVrbCtx(mapWork);
        this.isAcidScan = AcidUtils.isFullAcidScan((Configuration)this.jobConf);
        this.bucketIdentifier = BucketIdentifier.from((Configuration)this.jobConf, (Path)split.getPath());
        String orcSchemaOverrideString = job.get("hive.orc.schema.string");
        TypeDescription schema = orcSchemaOverrideString == null ? OrcInputFormat.getDesiredRowTypeDescr((Configuration)job, (boolean)this.isAcidScan, (int)Integer.MAX_VALUE) : TypeDescription.fromString((String)orcSchemaOverrideString);
        int queueLimitBase = LlapRecordReader.getQueueVar(HiveConf.ConfVars.LLAP_IO_VRB_QUEUE_LIMIT_MAX, job, daemonConf);
        int queueLimitMin = LlapRecordReader.getQueueVar(HiveConf.ConfVars.LLAP_IO_VRB_QUEUE_LIMIT_MIN, job, daemonConf);
        long bestEffortSize = LlapRecordReader.getLongQueueVar(HiveConf.ConfVars.LLAP_IO_CVB_BUFFERED_SIZE, job, daemonConf);
        boolean decimal64Support = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        int limit = LlapRecordReader.determineQueueLimit(bestEffortSize, queueLimitBase, queueLimitMin, this.rbCtx.getRowColumnTypeInfos(), this.rbCtx.getDataColumnNums(), decimal64Support);
        LOG.info("Queue limit for LlapRecordReader is " + limit);
        this.queue = new ArrayBlockingQueue(limit);
        int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues((VectorizedRowBatchCtx)this.rbCtx, (MapWork)mapWork, (FileSplit)split, (Object[])this.partitionValues);
        } else {
            this.partitionValues = null;
        }
        this.isVectorized = HiveConf.getBoolVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (this.isAcidScan) {
            OrcSplit orcSplit = (OrcSplit)split;
            this.acidReader = new VectorizedOrcAcidRowBatchReader(orcSplit, this.jobConf, Reporter.NULL, null, this.rbCtx, true, mapWork);
            this.isAcidFormat = !orcSplit.isOriginal();
        } else {
            this.isAcidFormat = false;
        }
        this.includes = new IncludesImpl(tableIncludedCols, this.isAcidFormat, this.rbCtx, schema, job, this.isAcidScan && this.acidReader.includeAcidColumns());
        this.probeDecodeEnabled = HiveConf.getBoolVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_SCAN_PROBEDECODE);
        if (this.probeDecodeEnabled) {
            this.includes.setProbeDecodeContext(mapWork.getProbeDecodeContext());
            LOG.info("LlapRecordReader ProbeDecode is enabled");
        }
        this.feedback = this.rp = cvp.createReadPipeline(this, split, this.includes, this.sarg, this.counters, this.includes, sourceInputFormat, sourceSerDe, reporter, job, mapWork.getPathToPartitionInfo());
    }

    private static int getQueueVar(HiveConf.ConfVars var, JobConf jobConf, Configuration daemonConf) {
        int jobVal = jobConf.getInt(var.varname, -1);
        return jobVal != -1 ? jobVal : HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)var);
    }

    private static long getLongQueueVar(HiveConf.ConfVars var, JobConf jobConf, Configuration daemonConf) {
        long jobVal = jobConf.getLong(var.varname, -1L);
        return jobVal != -1L ? jobVal : HiveConf.getLongVar((Configuration)daemonConf, (HiveConf.ConfVars)var);
    }

    @VisibleForTesting
    static int determineQueueLimit(long maxBufferedSize, int queueLimitMax, int queueLimitMin, TypeInfo[] typeInfos, int[] projectedColumnNums, boolean decimal64Support) {
        assert (queueLimitMax >= queueLimitMin);
        if (queueLimitMax == queueLimitMin) {
            return queueLimitMax;
        }
        if (projectedColumnNums == null || projectedColumnNums.length == 0) {
            return queueLimitMax;
        }
        double totalWeight = 0.0;
        int numberOfProjectedColumns = projectedColumnNums.length;
        double scale = Math.max(Math.log(numberOfProjectedColumns), 1.0);
        long columnVectorBaseSize = (long)((double)(96 * numberOfProjectedColumns) * scale);
        for (int i = 0; i < projectedColumnNums.length; ++i) {
            int colWeight;
            TypeInfo ti = typeInfos[projectedColumnNums[i]];
            if (ti.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                colWeight = 16;
            } else {
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)ti;
                switch (pti.getPrimitiveCategory()) {
                    case BINARY: 
                    case CHAR: 
                    case VARCHAR: 
                    case STRING: {
                        colWeight = 8;
                        break;
                    }
                    case TIMESTAMP: 
                    case INTERVAL_DAY_TIME: {
                        colWeight = 2;
                        break;
                    }
                    case DECIMAL: {
                        DecimalTypeInfo dti;
                        boolean useDecimal64 = false;
                        if (ti instanceof DecimalTypeInfo && (dti = (DecimalTypeInfo)ti).getPrecision() <= 18 && decimal64Support) {
                            useDecimal64 = true;
                        }
                        if (useDecimal64) {
                            colWeight = 1;
                            break;
                        }
                        colWeight = 10;
                        break;
                    }
                    default: {
                        colWeight = 1;
                    }
                }
            }
            totalWeight += (double)(colWeight * 8) * scale;
        }
        totalWeight *= 1024.0;
        int bestEffortSize = Math.min((int)((double)maxBufferedSize / (totalWeight += (double)columnVectorBaseSize)), queueLimitMax);
        return Math.max(bestEffortSize, queueLimitMin);
    }

    public void start() {
        if (this.executor instanceof StatsRecordingThreadPool) {
            ((StatsRecordingThreadPool)this.executor).setUncaughtExceptionHandler(new IOUncaughtExceptionHandler());
        }
        this.executor.submit(this.rp.getReadCallable());
    }

    private boolean checkOrcSchemaEvolution() {
        SchemaEvolution evolution = this.rp.getSchemaEvolution();
        if (evolution.hasConversion() && !evolution.isOnlyImplicitConversion()) {
            return false;
        }
        for (int i = 0; i < this.includes.getReaderLogicalColumnIds().size(); ++i) {
            int projectedColId = this.includes.getReaderLogicalColumnIds().get(i);
            int fileColId = OrcInputFormat.getRootColumn((!this.isAcidScan ? 1 : 0) != 0) + projectedColId + 1;
            if (evolution.isPPDSafeConversion(fileColId)) continue;
            LlapIoImpl.LOG.warn("Unsupported schema evolution! Disabling Llap IO for {}", (Object)this.split);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next(NullWritable key, VectorizedRowBatch vrb) throws IOException {
        ColumnVectorBatch cvb;
        assert (vrb != null);
        if (this.isClosed) {
            throw new AssertionError((Object)"next called after close");
        }
        boolean wasFirst = this.isFirst;
        if (this.isFirst) {
            if (this.partitionValues != null) {
                this.rbCtx.addPartitionColsToBatch(vrb, this.partitionValues);
            }
            this.isFirst = false;
        }
        try {
            cvb = this.nextCvb();
        }
        catch (InterruptedException e) {
            this.feedback.stop();
            this.isInterrupted = true;
            throw new IOException(e);
        }
        if (cvb == null) {
            if (wasFirst) {
                this.firstReturnTime = this.counters.startTimeCounter();
            }
            this.counters.incrWallClockCounter(LlapIOCounters.CONSUMER_TIME_NS, this.firstReturnTime);
            return false;
        }
        if (this.isAcidFormat) {
            vrb.selectedInUse = true;
            if (!this.isVectorized) throw new AssertionError((Object)"Unsupported mode");
            int acidColCount = this.acidReader.includeAcidColumns() ? OrcInputFormat.getRootColumn((boolean)false) - 1 : 0;
            this.ensureAcidInputVrb(acidColCount, vrb.getDataColumnCount());
            System.arraycopy(cvb.cols, 0, this.acidInputVrb.cols, 0, acidColCount);
            for (int ixInReadSet = acidColCount; ixInReadSet < cvb.cols.length; ++ixInReadSet) {
                int ixInVrb = this.includes.getPhysicalColumnIds().get(ixInReadSet) - (this.acidReader.includeAcidColumns() ? 0 : 5);
                cvb.swapColumnVector(ixInReadSet, this.acidInputVrb.cols, ixInVrb);
            }
            this.acidInputVrb.size = cvb.size;
            this.acidReader.setBaseAndInnerReader((RecordReader)new AcidWrapper(this.acidInputVrb));
            this.acidReader.next(NullWritable.get(), vrb);
        } else {
            List<Integer> logicalOrderedColumnIds = this.includes.getLogicalOrderedColumnIds();
            long cvbColsPresent = Arrays.stream(cvb.cols).filter(Objects::nonNull).count();
            if ((long)logicalOrderedColumnIds.size() != cvbColsPresent) {
                throw new RuntimeException("Unexpected number of columns, VRB has " + logicalOrderedColumnIds.size() + " included, but the reader returned " + cvbColsPresent);
            }
            int ixInReadSet = 0;
            while ((long)ixInReadSet < cvbColsPresent) {
                int ixInVrb = logicalOrderedColumnIds.get(ixInReadSet);
                cvb.swapColumnVector(ixInReadSet, vrb.cols, ixInVrb);
                ++ixInReadSet;
            }
            List missingColIndices = this.includes.getReaderLogicalColumnIds().stream().filter(idx -> !this.includes.getLogicalOrderedColumnIds().contains(idx)).collect(Collectors.toList());
            if ((long)missingColIndices.size() != (long)cvb.cols.length - cvbColsPresent) {
                throw new RuntimeException("Unexpected number of missing columns, expected " + missingColIndices.size() + ", but reader returned " + ((long)cvb.cols.length - cvbColsPresent) + " missing column vectors.");
            }
            Iterator iterator = missingColIndices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                vrb.cols[index].noNulls = false;
                vrb.cols[index].isRepeating = true;
                vrb.cols[index].isNull[0] = true;
            }
            vrb.selectedInUse = false;
            vrb.size = cvb.size;
        }
        if (wasFirst) {
            this.firstReturnTime = this.counters.startTimeCounter();
        }
        if (this.bucketIdentifier == null) return true;
        this.rbCtx.setBucketAndWriteIdOf(vrb, this.bucketIdentifier);
        return true;
    }

    private void ensureAcidInputVrb(int acidColCount, int dataColCount) {
        if (this.acidInputVrb == null) {
            this.acidInputVrb = new VectorizedRowBatch(acidColCount + 1 + dataColCount);
        }
    }

    public VectorizedRowBatchCtx getVectorizedRowBatchCtx() {
        return this.rbCtx;
    }

    ColumnVectorBatch nextCvb() throws InterruptedException, IOException {
        Object next;
        boolean doLogBlocking;
        boolean isFirst;
        boolean bl = isFirst = this.lastCvb == null;
        if (!isFirst) {
            this.feedback.returnData(this.lastCvb);
        }
        int queueSize = this.queue.size();
        this.maxQueueSize = Math.max(queueSize, this.maxQueueSize);
        boolean bl2 = doLogBlocking = LlapIoImpl.LOG.isTraceEnabled() && queueSize == 0;
        if (doLogBlocking) {
            LlapIoImpl.LOG.trace("next will block");
        }
        do {
            LlapRecordReader.rethrowErrorIfAny(this.pendingError.get());
        } while ((next = this.queue.poll(100L, TimeUnit.MILLISECONDS)) == null);
        if (doLogBlocking) {
            LlapIoImpl.LOG.trace("next is unblocked");
        }
        if (next == DONE_OBJECT) {
            return null;
        }
        if (next instanceof Throwable) {
            LlapRecordReader.rethrowErrorIfAny((Throwable)next);
            throw new AssertionError((Object)"Unreachable");
        }
        this.lastCvb = (ColumnVectorBatch)next;
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("Processing will receive vector {}", (Object)this.lastCvb);
        }
        return this.lastCvb;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return -1L;
    }

    public void close() throws IOException {
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("close called; closed {}, interrupted {}, err {}, pending {}", new Object[]{this.isClosed, this.isInterrupted, this.pendingError.get(), this.queue.size()});
        }
        LlapIoImpl.LOG.info("Maximum queue length observed " + this.maxQueueSize);
        LlapIoImpl.LOG.info("Llap counters: {}", (Object)this.counters);
        this.feedback.stop();
        this.isClosed = true;
        LlapRecordReader.rethrowErrorIfAny(this.pendingError.get());
        MDC.clear();
    }

    private static void rethrowErrorIfAny(Throwable pendingError) throws IOException {
        if (pendingError == null) {
            return;
        }
        if (pendingError instanceof IOException) {
            throw (IOException)pendingError;
        }
        throw new IOException(pendingError);
    }

    public void setDone() throws InterruptedException {
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            LlapIoImpl.LOG.debug("setDone called; closed {}, interrupted {}, err {}, pending {}", new Object[]{this.isClosed, this.isInterrupted, this.pendingError.get(), this.queue.size()});
        }
        this.enqueueInternal(DONE_OBJECT);
    }

    public void consumeData(ColumnVectorBatch data) throws InterruptedException {
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("consume called; closed {}, interrupted {}, err {}, pending {}", new Object[]{this.isClosed, this.isInterrupted, this.pendingError.get(), this.queue.size()});
        }
        this.enqueueInternal(data);
    }

    public void setError(Throwable t) throws InterruptedException {
        this.counters.incrCounter(LlapIOCounters.NUM_ERRORS);
        LlapIoImpl.LOG.debug("setError called; closed {}, interrupted {},  err {}, pending {}", new Object[]{this.isClosed, this.isInterrupted, this.pendingError.get(), this.queue.size()});
        LlapIoImpl.LOG.warn("setError called with an error", t);
        assert (t != null);
        this.pendingError.compareAndSet(null, t);
        this.enqueueInternal(t);
    }

    private void enqueueInternal(Object o) throws InterruptedException {
        while (!(this.isClosed || this.isInterrupted || this.queue.offer(o, 100L, TimeUnit.MILLISECONDS))) {
        }
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    void setPartitionValues(Object[] partitionValues) {
        this.partitionValues = partitionValues;
    }

    private static class IncludesImpl
    implements ColumnVectorProducer.SchemaEvolutionFactory,
    ColumnVectorProducer.Includes {
        private List<Integer> readerLogicalColumnIds;
        private List<Integer> filePhysicalColumnIds;
        private List<Integer> logicalOrderedColumnIds;
        private Integer acidStructColumnId = null;
        private final boolean includeAcidColumns;
        private TypeDescription readerSchema;
        private JobConf jobConf;
        private SchemaEvolution evolution;
        private TableScanOperator.ProbeDecodeContext probeDecodeContext = null;

        public IncludesImpl(List<Integer> tableIncludedCols, boolean isAcidScan, VectorizedRowBatchCtx rbCtx, TypeDescription readerSchema, JobConf jobConf, boolean includeAcidColumns) {
            this.readerSchema = readerSchema;
            this.jobConf = jobConf;
            this.includeAcidColumns = includeAcidColumns;
            if (tableIncludedCols == null) {
                tableIncludedCols = new ArrayList<Integer>(rbCtx.getDataColumnCount());
                for (int i = 0; i < rbCtx.getDataColumnCount(); ++i) {
                    tableIncludedCols.add(i);
                }
            }
            this.readerLogicalColumnIds = tableIncludedCols;
            LOG.debug("Logical table includes: {}", this.readerLogicalColumnIds);
            if (isAcidScan) {
                int rootCol = OrcInputFormat.getRootColumn((boolean)false);
                this.filePhysicalColumnIds = new ArrayList<Integer>(this.readerLogicalColumnIds.size() + rootCol);
                this.acidStructColumnId = rootCol - 1;
                if (includeAcidColumns) {
                    for (int i = 0; i < this.acidStructColumnId; ++i) {
                        this.filePhysicalColumnIds.add(i);
                    }
                }
                for (int tableColumnId : this.readerLogicalColumnIds) {
                    this.filePhysicalColumnIds.add(rootCol + tableColumnId);
                }
            } else {
                this.filePhysicalColumnIds = this.readerLogicalColumnIds;
            }
        }

        public String toString() {
            return "logical columns " + this.readerLogicalColumnIds + ", physical columns " + this.filePhysicalColumnIds;
        }

        @Override
        public SchemaEvolution createSchemaEvolution(TypeDescription fileSchema) {
            if (this.readerSchema == null) {
                this.readerSchema = fileSchema;
            }
            boolean[] readerIncludes = OrcInputFormat.genIncludedColumns((TypeDescription)this.readerSchema, this.readerLogicalColumnIds);
            Reader.Options options = new Reader.Options((Configuration)this.jobConf).include(readerIncludes).includeAcidColumns(this.includeAcidColumns);
            this.evolution = new SchemaEvolution(fileSchema, this.readerSchema, options);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated ORC schema evolution. Reader schema: {}, Reader included: {}, File schema: {}, File included: {}", new Object[]{this.evolution.getReaderSchema(), this.evolution.getReaderIncluded(), this.evolution.getFileSchema(), this.evolution.getFileIncluded()});
            }
            this.generateLogicalOrderedColumnIds();
            return this.evolution;
        }

        private void generateLogicalOrderedColumnIds() {
            if (this.acidStructColumnId != null) {
                LOG.debug("Not generating logical ordered column IDs for an ACID file read.");
                return;
            }
            this.adjustPhysicalColumnIds(this.evolution);
            if (this.jobConf.getBoolean(OrcConf.FORCE_POSITIONAL_EVOLUTION.getHiveConfName(), true)) {
                this.logicalOrderedColumnIds = this.filePhysicalColumnIds;
                LOG.debug("Not generating logical ordered column IDs by column name matching, as it is not possible with orc.force.positional.evolution turned on.");
                return;
            }
            this.logicalOrderedColumnIds = new LinkedList<Integer>();
            HashMap<Integer, String> fileSchemaMap = new HashMap<Integer, String>();
            HashMap<String, Integer> readSchemaMap = new HashMap<String, Integer>();
            int order = 0;
            for (String fieldName : this.evolution.getFileSchema().getFieldNames()) {
                fileSchemaMap.put(order++, fieldName);
            }
            order = 0;
            for (String fieldName : this.evolution.getReaderSchema().getFieldNames()) {
                readSchemaMap.put(fieldName, order++);
            }
            Iterator<Object> iterator = this.filePhysicalColumnIds.iterator();
            while (iterator.hasNext()) {
                int physicalId = (Integer)iterator.next();
                Integer id = (Integer)readSchemaMap.get(fileSchemaMap.get(physicalId));
                if (id == null) continue;
                this.logicalOrderedColumnIds.add(id);
            }
            LOG.debug("Logical ordered column IDs generated. Result: {}, fileSchemaMap: {}, readSchemaMap: {}", new Object[]{this.logicalOrderedColumnIds, fileSchemaMap, readSchemaMap});
        }

        @Override
        public boolean[] generateFileIncludes(TypeDescription fileSchema) {
            if (this.acidStructColumnId == null && this.evolution != null) {
                return this.evolution.getFileIncluded();
            }
            return OrcInputFormat.genIncludedColumns((TypeDescription)fileSchema, this.filePhysicalColumnIds, (Integer)this.acidStructColumnId);
        }

        public void setProbeDecodeContext(TableScanOperator.ProbeDecodeContext currProbeDecodeContext) {
            this.probeDecodeContext = currProbeDecodeContext;
        }

        @Override
        public List<Integer> getPhysicalColumnIds() {
            return this.filePhysicalColumnIds;
        }

        @Override
        public List<Integer> getReaderLogicalColumnIds() {
            return this.readerLogicalColumnIds;
        }

        @Override
        public List<Integer> getLogicalOrderedColumnIds() {
            return this.logicalOrderedColumnIds != null ? this.logicalOrderedColumnIds : this.readerLogicalColumnIds;
        }

        @Override
        public TypeDescription[] getBatchReaderTypes(TypeDescription fileSchema) {
            return OrcInputFormat.genIncludedTypes((TypeDescription)fileSchema, this.filePhysicalColumnIds, (Integer)this.acidStructColumnId);
        }

        @Override
        public String[] getOriginalColumnNames(TypeDescription fileSchema) {
            return OrcInputFormat.genIncludedColNames((TypeDescription)fileSchema, this.filePhysicalColumnIds, (Integer)this.acidStructColumnId);
        }

        @Override
        public String getQueryId() {
            return HiveConf.getVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        }

        @Override
        public boolean isProbeDecodeEnabled() {
            return this.probeDecodeContext != null;
        }

        @Override
        public byte getProbeMjSmallTablePos() {
            return this.probeDecodeContext.getMjSmallTablePos();
        }

        @Override
        public int getProbeColIdx() {
            Pattern pattern = Pattern.compile("_col([0-9]+)");
            Matcher matcher = pattern.matcher(this.probeDecodeContext.getMjBigTableKeyColName());
            return matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
        }

        private void adjustPhysicalColumnIds(SchemaEvolution evolution) {
            LinkedList<Integer> newFilePhysicalColumnIds = new LinkedList<Integer>();
            boolean[] firstLevelPhysicalIncludes = OrcInputFormat.firstLevelFileIncludes((SchemaEvolution)evolution);
            for (int i = 1; i < firstLevelPhysicalIncludes.length; ++i) {
                if (!firstLevelPhysicalIncludes[i]) continue;
                newFilePhysicalColumnIds.add(i - 1);
            }
            LOG.debug("Adjusting file physical included columnd IDs based on ORC SchemaEvolution. Original: {}, Adjusted: {}", this.filePhysicalColumnIds, newFilePhysicalColumnIds);
            this.filePhysicalColumnIds = newFilePhysicalColumnIds;
        }

        @Override
        public String getProbeColName() {
            return this.probeDecodeContext.getMjBigTableKeyColName();
        }

        @Override
        public String getProbeCacheKey() {
            return this.probeDecodeContext.getMjSmallTableCacheKey();
        }
    }

    private final class IOUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private IOUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LlapIoImpl.LOG.error("Unhandled error from reader thread. threadName: {} threadId: {} Message: {}", new Object[]{t.getName(), t.getId(), e.getMessage()});
            try {
                LlapRecordReader.this.setError(e);
            }
            catch (InterruptedException e1) {
                LOG.info("IOUncaughtExceptionHandler interrupted; ignoring");
            }
        }
    }

    private static final class AcidWrapper
    implements RecordReader<NullWritable, VectorizedRowBatch> {
        private final VectorizedRowBatch acidVrb;

        private AcidWrapper(VectorizedRowBatch acidVrb) {
            this.acidVrb = acidVrb;
        }

        public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
            return true;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public VectorizedRowBatch createValue() {
            return this.acidVrb;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }
}

