/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.llap.daemon.impl.DumpingMetricsCollector;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorInfo;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.junit.Assert;
import org.junit.Test;

public class TestLlapDaemonExecutorMetrics {
    @Test
    public void testTimedAverageMetricsTimeBound() {
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = this.generateTimedAverageMetrics(1, 10L, 1, 100L, 0L, 0L, 1L);
        Assert.assertEquals((String)"Window size 1", (long)100L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(1, 10L, 50, 100L, 0L, 0L, 1L);
        Assert.assertEquals((String)"Window size 1 with multiple data", (long)100L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 1, 100L, 0L, 50L, 1L);
        Assert.assertEquals((String)"Single point in the middle", (long)50L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 1, 100L, 0L, 75L, 1L);
        Assert.assertEquals((String)"Single point at 3/4", (long)25L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 1, 100L, 0L, 25L, 1L);
        Assert.assertEquals((String)"Single point at 1/4", (long)75L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 3, 100L, 0L, 25L, 25L);
        Assert.assertEquals((String)"Multiple points after 1/4", (long)75L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 18, 100L, 0L, 25L, 25L);
        Assert.assertEquals((String)"More points with overflow", (long)100L, (long)metrics.value(450L));
        metrics = this.generateTimedAverageMetrics(10, 100L, 20, 100L, 0L, 25L, 25L);
        Assert.assertEquals((String)"Very old points", (long)100L, (long)metrics.value(5000L));
        metrics.add(1000L, 10L);
        Assert.assertEquals((String)"Very old points but not that old", (long)10L, (long)metrics.value(5000L));
    }

    @Test
    public void testTimedAverageMetricsDataBound() {
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = this.generateTimedAverageMetrics(1, 100L, 1, 100L, 0L, 50L, 1L);
        Assert.assertEquals((String)"Window size 1", (long)100L, (long)metrics.value(100L));
        metrics = this.generateTimedAverageMetrics(3, 100L, 4, 50L, 10L, 50L, 10L);
        Assert.assertEquals((String)"Window size 1 with multiple data", (long)65L, (long)metrics.value(100L));
    }

    @Test(expected=AssertionError.class)
    public void testTimedAverageMetricsWindowSizeZero() {
        this.generateTimedAverageMetrics(0, 100L, 2, 50L, 50L, 0L, 50L);
    }

    @Test
    public void testTimedAverageMetricsChanging() {
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = this.generateTimedAverageMetrics(3, 30L, 6, 0L, 10L, 0L, 10L);
        Assert.assertEquals((String)"Position 0", (long)40L, (long)metrics.value(60L));
        metrics = this.generateTimedAverageMetrics(3, 30L, 5, 0L, 10L, 0L, 10L);
        Assert.assertEquals((String)"Position windowDataSize - 1", (long)30L, (long)metrics.value(50L));
    }

    @Test
    public void testTimedAverageMetricsReal() {
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = new LlapDaemonExecutorMetrics.TimedAverageMetrics(10, 6000000L);
        for (int i = 0; i < 50; ++i) {
            metrics.add(100L);
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertEquals((String)"Checking the calculated value", (long)100L, (long)metrics.value());
    }

    @Test
    public void testTimedAverageMetricsBigData() {
        long currentTime = System.nanoTime();
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = this.generateTimedAverageMetrics(15000, 600000000000L, 20000, -5000L, 1L, currentTime, 50000000L);
        Assert.assertEquals((String)"Checking the calculated value", (long)9000L, (long)metrics.value(currentTime + 1000000000000L));
    }

    @Test
    public void testSimpleAndDerivedMetricsCalculations() {
        int numExecutorsConfigured = 4;
        int numExecutors = 2;
        int numExecutorsAvailable = 1;
        int waitQueueSizeConfigured = 10;
        int waitQueueSize = 5;
        int queuedRequests = 3;
        LlapDaemonExecutorMetrics metrics = LlapDaemonExecutorMetrics.create((String)"test", (String)"test", (int)numExecutorsConfigured, (int)waitQueueSizeConfigured, (int[])new int[]{1}, (int)1, (long)1L, (int)1);
        metrics.setNumExecutors(numExecutors);
        metrics.setNumExecutorsAvailable(numExecutorsAvailable);
        metrics.setWaitQueueSize(waitQueueSize);
        metrics.setExecutorNumQueuedRequests(queuedRequests);
        HashMap data = Maps.newHashMap();
        metrics.getMetrics((MetricsCollector)new DumpingMetricsCollector((Map)data), true);
        Assert.assertTrue(((long)numExecutorsConfigured == (Long)data.get(LlapDaemonExecutorInfo.ExecutorNumExecutorsConfigured.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)numExecutors == (Long)data.get(LlapDaemonExecutorInfo.ExecutorNumExecutors.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)waitQueueSizeConfigured == (Long)data.get(LlapDaemonExecutorInfo.ExecutorWaitQueueSizeConfigured.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)waitQueueSize == (Long)data.get(LlapDaemonExecutorInfo.ExecutorWaitQueueSize.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)queuedRequests == (Long)data.get(LlapDaemonExecutorInfo.ExecutorNumQueuedRequests.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)numExecutorsAvailable == (Long)data.get(LlapDaemonExecutorInfo.ExecutorNumExecutorsAvailable.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)(waitQueueSizeConfigured + numExecutorsConfigured) == (Long)data.get(LlapDaemonExecutorInfo.ExecutorMaxFreeSlotsConfigured.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)(waitQueueSize + numExecutors) == (Long)data.get(LlapDaemonExecutorInfo.ExecutorMaxFreeSlots.name()) ? 1 : 0) != 0);
        Assert.assertTrue(((long)(waitQueueSize + numExecutorsAvailable - queuedRequests) == (Long)data.get(LlapDaemonExecutorInfo.ExecutorAvailableFreeSlots.name()) ? 1 : 0) != 0);
    }

    private LlapDaemonExecutorMetrics.TimedAverageMetrics generateTimedAverageMetrics(int windowDataSize, long windowTimeSize, int dataNum, long firstData, long dataDelta, long firstTime, long timeDelta) {
        LlapDaemonExecutorMetrics.TimedAverageMetrics metrics = new LlapDaemonExecutorMetrics.TimedAverageMetrics(windowDataSize, windowTimeSize, firstTime - windowTimeSize);
        for (int i = 0; i < dataNum; ++i) {
            metrics.add(firstTime + (long)i * timeDelta, firstData + (long)i * dataDelta);
        }
        return metrics;
    }
}

