/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.llap.io.api.impl.LlapRecordReader;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class LlapRecordReaderQueueSizeTest {
    private static final int END_EXCLUSIVE = 300;
    private static final int MAX_BUFFERED_SIZE = 0x40000000;

    @Test
    public void testMaxEqMin() {
        int expected = LlapRecordReader.determineQueueLimit((long)0L, (int)100, (int)100, null, null, (boolean)true);
        Assert.assertEquals((long)100L, (long)expected);
    }

    @Test
    public void testMaxIsEnforced() {
        TypeInfo[] cols = new TypeInfo[]{new DecimalTypeInfo()};
        int[] colsProjected = new int[]{0};
        int actual = LlapRecordReader.determineQueueLimit((long)Long.MAX_VALUE, (int)10, (int)1, (TypeInfo[])cols, (int[])colsProjected, (boolean)true);
        Assert.assertEquals((long)10L, (long)actual);
    }

    @Test
    public void testMinIsEnforced() {
        TypeInfo[] cols = new TypeInfo[]{new DecimalTypeInfo()};
        int[] colsProjected = new int[]{0};
        int actual = LlapRecordReader.determineQueueLimit((long)0L, (int)10, (int)5, (TypeInfo[])cols, (int[])colsProjected, (boolean)true);
        Assert.assertEquals((long)5L, (long)actual);
    }

    @Test
    public void testOrderDecimal64VsFatDecimals() {
        TypeInfo[] cols = (TypeInfo[])IntStream.range(0, 300).mapToObj(i -> new DecimalTypeInfo()).toArray(TypeInfo[]::new);
        int[] colsProjected = IntStream.range(0, 300).toArray();
        int actual = LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])cols, (int[])colsProjected, (boolean)true);
        Assert.assertEquals((long)75L, (long)actual);
        actual = LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])cols, (int[])colsProjected, (boolean)false);
        Assert.assertEquals((long)7L, (long)actual);
    }

    @Test
    public void testOrderDecimal64VsLong() {
        TypeInfo[] decimalCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> new DecimalTypeInfo(18, 0));
        TypeInfo[] longCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.longTypeInfo);
        int[] colsProjected = IntStream.range(0, 300).toArray();
        Assert.assertEquals((long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])longCols, (int[])colsProjected, (boolean)true), (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])decimalCols, (int[])colsProjected, (boolean)true));
    }

    @Test
    public void testStringsColumns() {
        TypeInfo[] charsCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.charTypeInfo);
        TypeInfo[] stringCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.stringTypeInfo);
        TypeInfo[] binaryCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.binaryTypeInfo);
        int[] colsProjected = IntStream.range(0, 300).toArray();
        Assert.assertEquals((long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])stringCols, (int[])colsProjected, (boolean)true), (long)9L);
        Assert.assertEquals((long)9L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])charsCols, (int[])colsProjected, (boolean)true));
        Assert.assertEquals((long)9L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])binaryCols, (int[])colsProjected, (boolean)true));
    }

    @Test
    public void testLongColumns() {
        TypeInfo[] longsCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.longTypeInfo);
        TypeInfo[] intCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.intTypeInfo);
        TypeInfo[] byteCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.byteTypeInfo);
        int[] colsProjected = IntStream.range(0, 300).toArray();
        Assert.assertEquals((long)75L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])longsCols, (int[])colsProjected, (boolean)true));
        Assert.assertEquals((long)75L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])intCols, (int[])colsProjected, (boolean)true));
        Assert.assertEquals((long)75L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])byteCols, (int[])colsProjected, (boolean)true));
    }

    @Test
    public void testTimestampsColumns() {
        TypeInfo[] tsCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.timestampTypeInfo);
        TypeInfo[] intervalCols = LlapRecordReaderQueueSizeTest.ArrayOf(() -> TypeInfoFactory.intervalDayTimeTypeInfo);
        int[] colsProjected = IntStream.range(0, 300).toArray();
        Assert.assertEquals((long)38L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])tsCols, (int[])colsProjected, (boolean)true));
        Assert.assertEquals((long)38L, (long)LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])intervalCols, (int[])colsProjected, (boolean)true));
    }

    @Test
    public void testProjectedColumns() {
        TypeInfo[] cols = (TypeInfo[])IntStream.range(0, 300).mapToObj(i -> new DecimalTypeInfo()).toArray(TypeInfo[]::new);
        int[] colsProjected = new int[]{0};
        int actual = LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])cols, (int[])colsProjected, (boolean)true);
        Assert.assertEquals((long)10000L, (long)actual);
        actual = LlapRecordReader.determineQueueLimit((long)0x40000000L, (int)10000, (int)5, (TypeInfo[])cols, (int[])colsProjected, (boolean)false);
        Assert.assertEquals((long)10000L, (long)actual);
    }

    private static TypeInfo[] ArrayOf(Supplier<TypeInfo> supplier) {
        return (TypeInfo[])IntStream.range(0, 300).mapToObj(i -> (TypeInfo)supplier.get()).toArray(TypeInfo[]::new);
    }
}

