/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.services.impl.LlapWebServices;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLlapWebServices {
    private static LlapWebServices llapWS = null;
    private static int llapWSPort;

    @BeforeClass
    public static void beforeTests() throws Exception {
        llapWSPort = MetaStoreTestUtils.findFreePortExcepting((int)Integer.valueOf(HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT.getDefaultValue()));
        llapWS = new LlapWebServices(llapWSPort, null, null);
        llapWS.init((Configuration)new HiveConf());
        llapWS.start();
        Thread.sleep(5000L);
        TestLlapWebServices.ensureUniqueInClasspath("javax/servlet/http/HttpServletRequest.class");
        TestLlapWebServices.ensureUniqueInClasspath("javax/servlet/http/HttpServlet.class");
    }

    private static void ensureUniqueInClasspath(String name) throws IOException {
        Enumeration<URL> rr = TestLlapWebServices.class.getClassLoader().getResources(name);
        ArrayList<URL> found = new ArrayList<URL>();
        while (rr.hasMoreElements()) {
            found.add(rr.nextElement());
        }
        if (found.size() != 1) {
            throw new RuntimeException(name + " unexpected number of occurences on the classpath:" + ((Object)found).toString());
        }
    }

    @Test
    public void testContextRootUrlRewrite() throws Exception {
        String contextRootURL = "http://localhost:" + llapWSPort + "/";
        String contextRootContent = TestLlapWebServices.getURLResponseAsString(contextRootURL, 200);
        String indexHtmlUrl = "http://localhost:" + llapWSPort + "/index.html";
        String indexHtmlContent = TestLlapWebServices.getURLResponseAsString(indexHtmlUrl, 200);
        Assert.assertEquals((Object)contextRootContent, (Object)indexHtmlContent);
    }

    @Test
    public void testDirListingDisabled() throws Exception {
        for (String folder : ImmutableSet.of((Object)"images", (Object)"js", (Object)"css")) {
            String url = "http://localhost:" + llapWSPort + "/" + folder;
            TestLlapWebServices.getURLResponseAsString(url, 403);
        }
    }

    @Test
    public void testBaseUrlResponseHeader() throws Exception {
        String baseURL = "http://localhost:" + llapWSPort + "/";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        String xXSSProtectionHeader = conn.getHeaderField("X-XSS-Protection");
        String xContentTypeHeader = conn.getHeaderField("X-Content-Type-Options");
        Assert.assertNotNull((Object)xfoHeader);
        Assert.assertNotNull((Object)xXSSProtectionHeader);
        Assert.assertNotNull((Object)xContentTypeHeader);
    }

    private static String getURLResponseAsString(String baseURL, int expectedStatus) throws IOException {
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)expectedStatus, (long)conn.getResponseCode());
        if (expectedStatus != 200) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    @AfterClass
    public static void afterTests() throws Exception {
        llapWS.stop();
    }
}

