/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.LlapDaemonTestUtils;
import org.apache.hadoop.hive.llap.daemon.impl.EvictingPriorityBlockingQueue;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorTestHelpers;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.FirstInFirstOutComparator;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.ShortestJobFirstComparator;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;

public class TestFirstInFirstOutComparator {
    private LlapDaemonProtocolProtos.SubmitWorkRequestProto createRequest(int fragmentNumber, int numSelfAndUpstreamTasks, int dagStartTime, int attemptStartTime) throws IOException {
        return this.createRequest(fragmentNumber, numSelfAndUpstreamTasks, 0, dagStartTime, attemptStartTime, 1);
    }

    private LlapDaemonProtocolProtos.SubmitWorkRequestProto createRequest(int fragmentNumber, int numSelfAndUpstreamTasks, int numSelfAndUpstreamComplete, int dagStartTime, int attemptStartTime, int withinDagPriority) throws IOException {
        return this.createRequest(fragmentNumber, numSelfAndUpstreamTasks, numSelfAndUpstreamComplete, dagStartTime, attemptStartTime, withinDagPriority, "MockDag");
    }

    private LlapDaemonProtocolProtos.SubmitWorkRequestProto createRequest(int fragmentNumber, int numSelfAndUpstreamTasks, int numSelfAndUpstreamComplete, int dagStartTime, int attemptStartTime, int withinDagPriority, String dagName) throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)9999L, (int)72);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)dagId, (int)35);
        return LlapDaemonTestUtils.buildSubmitProtoRequest(fragmentNumber, appId.toString(), dagId.getId(), vId.getId(), dagName, dagStartTime, attemptStartTime, numSelfAndUpstreamTasks, numSelfAndUpstreamComplete, withinDagPriority, new Credentials());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparator() throws InterruptedException, IOException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), false, 1000000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        TaskExecutorService.TaskWrapper r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), false, 1000000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 1, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 1, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 1, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 1, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), false, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r2, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 1, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 2, 5, 100), false, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 4, 4, 200), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 6, 3, 300), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 8, 2, 400), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(5, 10, 2, 500), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorCanFinish() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 0, 10L, 100L, 2), true, false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 0, 10L, 100L, 1), false, true, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 0, 10L, 100L, 5), true, true, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorWithinDagPriority() throws InterruptedException, IOException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 1, 0, 100, 100, 10), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 1, 0, 100, 100, 1), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 1, 0, 100, 100, 5), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorWithinSameDagPriority() throws InterruptedException, IOException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 1, 0, 10, 100, 10), true, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 1, 0, 10, 100, 10), true, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 1, 0, 10, 100, 10), true, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 3);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(4, 1, 0, 10, 100, 10), true, 100000);
        Assert.assertEquals((Object)r4, (Object)queue.offer((Object)r4, 0));
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorParallelism() throws InterruptedException, IOException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(1, 10, 3, 100, 100, 1, "q1"), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(2, 10, 7, 100, 100, 1, "q2"), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(this.createRequest(3, 10, 5, 100, 100, 1, "q3"), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new FirstInFirstOutComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }
}

