/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.impl.LlapLoadGeneratorService;
import org.junit.Assert;
import org.junit.Test;

public class TestLlapLoadGeneratorService {
    @Test
    public void testLoadGeneratorStops() throws InterruptedException, UnknownHostException {
        int i;
        LlapLoadGeneratorService service = new LlapLoadGeneratorService();
        HiveConf conf = new HiveConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_HOSTNAMES, (String)(InetAddress.getLocalHost().getHostName() + ",???"));
        HiveConf.setFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_UTILIZATION, (float)0.5f);
        HiveConf.setTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_INTERVAL, (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        service.init((Configuration)conf);
        service.start();
        Assert.assertEquals((String)"The number of threads is not correct", (long)Runtime.getRuntime().availableProcessors(), (long)service.threads.length);
        for (i = 0; i < service.threads.length; ++i) {
            Assert.assertTrue((String)("The thread [" + i + "] should be alive"), (boolean)service.threads[i].isAlive());
        }
        service.stop();
        Thread.sleep(1000L);
        for (i = 0; i < service.threads.length; ++i) {
            Thread.State state = service.threads[i].getState();
            Assert.assertFalse((String)("The thread [" + i + "] should be terminated"), (boolean)service.threads[i].isAlive());
        }
    }

    @Test(expected=RuntimeException.class)
    public void testLoadGeneratorFails() throws InterruptedException, UnknownHostException {
        LlapLoadGeneratorService service = new LlapLoadGeneratorService();
        HiveConf conf = new HiveConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_HOSTNAMES, (String)(InetAddress.getLocalHost().getHostName() + ",???"));
        HiveConf.setFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_UTILIZATION, (float)1.2f);
        HiveConf.setTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_INTERVAL, (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        service.init((Configuration)conf);
        service.start();
        service.stop();
    }
}

