/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.daemon.ContainerRunner;
import org.apache.hadoop.hive.llap.daemon.impl.LlapProtocolServerImpl;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.impl.LlapProtocolClientImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLlapDaemonProtocolServerImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSimpleCall() throws ServiceException, IOException {
        LlapDaemonConfiguration daemonConf = new LlapDaemonConfiguration();
        int numHandlers = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_NUM_HANDLERS);
        ContainerRunner containerRunnerMock = (ContainerRunner)Mockito.mock(ContainerRunner.class);
        LlapProtocolServerImpl server = new LlapProtocolServerImpl(null, numHandlers, containerRunnerMock, new AtomicReference(), new AtomicReference(), 0, 0, 0, null, null);
        Mockito.when((Object)containerRunnerMock.submitWork((LlapDaemonProtocolProtos.SubmitWorkRequestProto)Mockito.any(LlapDaemonProtocolProtos.SubmitWorkRequestProto.class))).thenReturn((Object)LlapDaemonProtocolProtos.SubmitWorkResponseProto.newBuilder().setSubmissionState(LlapDaemonProtocolProtos.SubmissionStateProto.ACCEPTED).build());
        try {
            server.init(new Configuration());
            server.start();
            InetSocketAddress serverAddr = server.getBindAddress();
            LlapProtocolClientImpl client = new LlapProtocolClientImpl(new Configuration(), serverAddr.getHostName(), serverAddr.getPort(), null, null, null);
            LlapDaemonProtocolProtos.SubmitWorkResponseProto responseProto = client.submitWork(null, LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder().setAmHost("amhost").setAmPort(2000).build());
            Assert.assertEquals((Object)responseProto.getSubmissionState().name(), (Object)LlapDaemonProtocolProtos.SubmissionStateProto.ACCEPTED.name());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testGetDaemonMetrics() throws ServiceException, IOException {
        LlapDaemonConfiguration daemonConf = new LlapDaemonConfiguration();
        int numHandlers = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_NUM_HANDLERS);
        LlapDaemonExecutorMetrics executorMetrics = LlapDaemonExecutorMetrics.create((String)"LLAP", (String)"SessionId", (int)numHandlers, (int)1, (int[])new int[]{30, 60, 300}, (int)0, (long)0L, (int)0);
        LlapProtocolServerImpl server = new LlapProtocolServerImpl(null, numHandlers, null, new AtomicReference(), new AtomicReference(), 0, 0, 0, null, executorMetrics);
        executorMetrics.addMetricsFallOffFailedTimeLost(10L);
        executorMetrics.addMetricsFallOffKilledTimeLost(11L);
        executorMetrics.addMetricsFallOffSuccessTimeLost(12L);
        executorMetrics.addMetricsPreemptionTimeLost(13L);
        executorMetrics.addMetricsPreemptionTimeToKill(14L);
        executorMetrics.incrExecutorTotalExecutionFailed();
        executorMetrics.incrExecutorTotalKilled();
        executorMetrics.incrExecutorTotalRequestsHandled();
        executorMetrics.incrExecutorTotalSuccess();
        executorMetrics.incrTotalEvictedFromWaitQueue();
        executorMetrics.incrTotalRejectedRequests();
        executorMetrics.setCacheMemoryPerInstance(15L);
        executorMetrics.setExecutorNumPreemptableRequests(16);
        executorMetrics.setExecutorNumQueuedRequests(17);
        executorMetrics.setJvmMaxMemory(18L);
        executorMetrics.setMemoryPerInstance(19L);
        executorMetrics.setNumExecutorsAvailable(20);
        executorMetrics.setWaitQueueSize(21);
        try {
            server.init(new Configuration());
            server.start();
            InetSocketAddress serverAddr = server.getManagementBindAddress();
            LlapManagementProtocolClientImpl client = new LlapManagementProtocolClientImpl(new Configuration(), serverAddr.getHostName(), serverAddr.getPort(), null, null);
            LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto responseProto = client.getDaemonMetrics(null, LlapDaemonProtocolProtos.GetDaemonMetricsRequestProto.newBuilder().build());
            HashMap result = new HashMap(responseProto.getMetricsCount());
            responseProto.getMetricsList().forEach(me -> result.put(me.getKey(), me.getValue()));
            Assert.assertTrue((String)"Checking ExecutorFallOffFailedTimeLost", ((Long)result.get("ExecutorFallOffFailedTimeLost") == 10L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorFallOffKilledTimeLost", ((Long)result.get("ExecutorFallOffKilledTimeLost") == 11L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorFallOffSuccessTimeLost", ((Long)result.get("ExecutorFallOffSuccessTimeLost") == 12L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalPreemptionTimeLost", ((Long)result.get("ExecutorTotalPreemptionTimeLost") == 13L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalPreemptionTimeToKill", ((Long)result.get("ExecutorTotalPreemptionTimeToKill") == 14L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalFailed", ((Long)result.get("ExecutorTotalFailed") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalKilled", ((Long)result.get("ExecutorTotalKilled") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalRequestsHandled", ((Long)result.get("ExecutorTotalRequestsHandled") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalSuccess", ((Long)result.get("ExecutorTotalSuccess") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalEvictedFromWaitQueue", ((Long)result.get("ExecutorTotalEvictedFromWaitQueue") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorTotalRejectedRequests", ((Long)result.get("ExecutorTotalRejectedRequests") == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorCacheMemoryPerInstance", ((Long)result.get("ExecutorCacheMemoryPerInstance") == 15L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorNumPreemptableRequests", ((Long)result.get("ExecutorNumPreemptableRequests") == 16L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorNumQueuedRequests", ((Long)result.get("ExecutorNumQueuedRequests") == 17L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorJvmMaxMemory", ((Long)result.get("ExecutorJvmMaxMemory") == 18L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorMemoryPerInstance", ((Long)result.get("ExecutorMemoryPerInstance") == 19L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorNumExecutorsAvailable", ((Long)result.get("ExecutorNumExecutorsAvailable") == 20L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Checking ExecutorWaitQueueSize", ((Long)result.get("ExecutorWaitQueueSize") == 21L ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSetCapacity() throws ServiceException, IOException {
        LlapDaemonConfiguration daemonConf = new LlapDaemonConfiguration();
        int numHandlers = HiveConf.getIntVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_NUM_HANDLERS);
        ContainerRunner containerRunnerMock = (ContainerRunner)Mockito.mock(ContainerRunner.class);
        Mockito.when((Object)containerRunnerMock.setCapacity((LlapDaemonProtocolProtos.SetCapacityRequestProto)Mockito.any(LlapDaemonProtocolProtos.SetCapacityRequestProto.class))).thenReturn((Object)LlapDaemonProtocolProtos.SetCapacityResponseProto.newBuilder().build());
        LlapDaemonExecutorMetrics executorMetrics = LlapDaemonExecutorMetrics.create((String)"LLAP", (String)"SessionId", (int)numHandlers, (int)1, (int[])new int[]{30, 60, 300}, (int)0, (long)0L, (int)0);
        LlapProtocolServerImpl server = new LlapProtocolServerImpl(null, numHandlers, containerRunnerMock, new AtomicReference(), new AtomicReference(), 0, 0, 0, null, executorMetrics);
        try {
            server.init(new Configuration());
            server.start();
            InetSocketAddress serverAddr = server.getManagementBindAddress();
            LlapManagementProtocolClientImpl client = new LlapManagementProtocolClientImpl(new Configuration(), serverAddr.getHostName(), serverAddr.getPort(), null, null);
            client.setCapacity(null, LlapDaemonProtocolProtos.SetCapacityRequestProto.newBuilder().setExecutorNum(1).setQueueSize(1).build());
        }
        finally {
            server.stop();
        }
    }
}

