/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.util.reflection.Fields;
import org.mockito.internal.util.reflection.InstanceField;

public class TestLlapDaemon {
    private static final String[] METRICS_SOURCES = new String[]{"JvmMetrics", "LlapDaemonExecutorMetrics-" + MetricsUtils.getHostName(), "LlapDaemonJvmMetrics-" + MetricsUtils.getHostName(), "LlapDaemon"};
    public static final String TEST_LOCAL_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestLlapDaemon.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private Configuration hiveConf = new HiveConf();
    @Mock
    private LlapRegistryService mockRegistry;
    @Captor
    private ArgumentCaptor<Iterable<Map.Entry<String, String>>> captor;
    private LlapDaemon daemon;
    private String[] localDirs = new String[]{TEST_LOCAL_DIR};
    private int defaultWebPort;

    public TestLlapDaemon() {
        this.defaultWebPort = HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT.defaultIntVal;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupConf(this.hiveConf);
        LlapDaemonInfo.initialize((String)"testDaemon", (Configuration)this.hiveConf);
    }

    private void setupConf(Configuration conf) {
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS, (String)"localhost");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST, (boolean)true);
    }

    @After
    public void tearDown() {
        MetricsSystem ms = LlapMetricsSystem.instance();
        for (String mSource : METRICS_SOURCES) {
            ms.unregisterSource(mSource);
        }
        if (this.daemon != null) {
            this.daemon.shutdown();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnforceProperNumberOfIOThreads() throws IOException {
        HiveConf.setIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE, (int)3);
        this.daemon = new LlapDaemon(this.hiveConf, 4, LlapDaemon.getTotalHeapSize(), true, false, -1L, new String[1], 0, false, 0, 0, 0, this.defaultWebPort, "TestLlapDaemon");
    }

    @Test
    public void testLocalDirCleaner() throws IOException, InterruptedException {
        HiveConf.setTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LOCAL_DIR_CLEANER_CLEANUP_INTERVAL, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        HiveConf.setTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LOCAL_DIR_CLEANER_FILE_MODIFY_TIME_THRESHOLD, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.createFile(this.localDirs[0] + "/hive/appcache/file1");
        this.createFile(this.localDirs[0] + "/hive/appcache/file2");
        this.createFile(this.localDirs[0] + "/file3");
        this.daemon = new LlapDaemon(this.hiveConf, 1, LlapDaemon.getTotalHeapSize(), false, false, -1L, this.localDirs, 0, false, 0, 0, 0, this.defaultWebPort, "TestLlapDaemon");
        this.daemon.init(this.hiveConf);
        this.assertFileExists(this.localDirs[0] + "/hive/appcache/file1", true);
        this.assertFileExists(this.localDirs[0] + "/hive/appcache/file2", true);
        this.assertFileExists(this.localDirs[0] + "/file3", true);
        this.daemon.start();
        Thread.sleep(5000L);
        this.assertFileExists(this.localDirs[0] + "/hive/appcache/file1", false);
        this.assertFileExists(this.localDirs[0] + "/hive/appcache/file2", false);
        this.assertFileExists(this.localDirs[0] + "/file3", false);
        this.assertFileExists(this.localDirs[0] + "/hive/appcache", true);
    }

    private void assertFileExists(String strPath, boolean exists) {
        Assert.assertEquals((String)(strPath + " " + (exists ? "doesn't exist" : "exists")), (Object)exists, (Object)Files.exists(Paths.get(strPath, new String[0]), new LinkOption[0]));
    }

    private void createFile(String strPath) throws IOException {
        Path path = Paths.get(strPath, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.createFile(path, new FileAttribute[0]);
    }

    @Test
    public void testUpdateRegistration() throws IOException {
        int enabledExecutors = 0;
        int enabledQueue = 2;
        this.daemon = new LlapDaemon(this.hiveConf, 1, LlapDaemon.getTotalHeapSize(), false, false, -1L, new String[1], 0, false, 0, 0, 0, this.defaultWebPort, "TestLlapDaemon");
        TestLlapDaemon.trySetMock(this.daemon, LlapRegistryService.class, this.mockRegistry);
        this.daemon.setCapacity(LlapDaemonProtocolProtos.SetCapacityRequestProto.newBuilder().setQueueSize(enabledQueue).setExecutorNum(enabledExecutors).build());
        ((LlapRegistryService)Mockito.verify((Object)this.mockRegistry)).updateRegistration((Iterable)this.captor.capture());
        Map<String, String> attributes = StreamSupport.stream(((Iterable)this.captor.getValue()).spliterator(), false).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        Assert.assertTrue((boolean)attributes.containsKey("hive.llap.daemon.num.enabled.executors"));
        Assert.assertTrue((boolean)attributes.containsKey("hive.llap.daemon.task.scheduler.enabled.wait.queue.size"));
        Assert.assertEquals((long)enabledQueue, (long)Integer.parseInt(attributes.get("hive.llap.daemon.task.scheduler.enabled.wait.queue.size")));
        Assert.assertEquals((long)enabledExecutors, (long)Integer.parseInt(attributes.get("hive.llap.daemon.num.enabled.executors")));
    }

    static <T> void trySetMock(Object o, Class<T> clazz, T mock) {
        List instanceFields = Fields.allDeclaredFieldsOf((Object)o).filter(instanceField -> !clazz.isAssignableFrom(instanceField.jdkField().getType())).instanceFields();
        if (instanceFields.size() != 1) {
            throw new RuntimeException("Mocking is only supported, if only one field is assignable from the given class.");
        }
        InstanceField instanceField2 = (InstanceField)instanceFields.get(0);
        instanceField2.set(mock);
    }
}

