/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.LlapUgiManager;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.daemon.LlapDaemonTestUtils;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.ContainerRunnerImpl;
import org.apache.hadoop.hive.llap.daemon.impl.QueryTracker;
import org.apache.hadoop.hive.llap.daemon.impl.Scheduler;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.llap.shufflehandler.ShuffleHandler;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.TokenCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestContainerRunnerImpl {
    ContainerRunnerImpl containerRunner;
    LlapDaemonConfiguration daemonConf = new LlapDaemonConfiguration();
    private final int numExecutors = 1;
    private final int waitQueueSize = HiveConf.getIntVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_SCHEDULER_WAIT_QUEUE_SIZE);
    private final boolean enablePreemption = false;
    private final int numLocalDirs = 1;
    private final String[] localDirs = new String[1];
    private final File testWorkDir = new File("target", "container-runner-tests");
    private final AtomicReference<Integer> shufflePort = new AtomicReference();
    private final AtomicReference<InetSocketAddress> srvAddress = new AtomicReference();
    private final int executorMemoryPerInstance = 1024;
    private LlapDaemonExecutorMetrics metrics;
    private AMReporter amReporter;
    private final String testUser = "testUser";
    private final String appId = "application_1540489363818_0021";
    private final int dagId = 1234;
    private final int vId = 12345;
    private final String hostname = "test.cluster";
    private final DaemonId daemonId = new DaemonId("testUser", "ContainerTests", "test.cluster", "application_1540489363818_0021", System.currentTimeMillis());
    private final SocketFactory socketFactory = NetUtils.getDefaultSocketFactory((Configuration)this.daemonConf);
    private QueryTracker queryTracker;
    private TaskExecutorService executorService;
    private InetSocketAddress serverSocket;

    @Before
    public void setup() throws Exception {
        String[] strIntervals = HiveConf.getTrimmedStringsVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_TASK_PREEMPTION_METRICS_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String strInterval : strIntervals) {
                intervalList.add(Integer.valueOf(strInterval));
            }
        }
        this.amReporter = (AMReporter)Mockito.mock(AMReporter.class);
        this.serverSocket = new InetSocketAddress("localhost", 0);
        this.srvAddress.set(this.serverSocket);
        this.metrics = LlapDaemonExecutorMetrics.create((String)"ContinerRunerTests", (String)MetricsUtils.getUUID(), (int)1, (int)this.waitQueueSize, (int[])Ints.toArray(intervalList), (int)0, (long)0L, (int)0);
        for (int i = 0; i < 1; ++i) {
            File f = new File(this.testWorkDir, "localDir");
            f.mkdirs();
            this.localDirs[i] = f.getAbsolutePath();
        }
        String waitQueueSchedulerClassName = HiveConf.getVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WAIT_QUEUE_COMPARATOR_CLASS_NAME);
        this.queryTracker = new QueryTracker((Configuration)this.daemonConf, this.localDirs, this.daemonId.getClusterString());
        this.executorService = new TaskExecutorService(1, this.waitQueueSize, waitQueueSchedulerClassName, false, Thread.currentThread().getContextClassLoader(), this.metrics, null);
        this.shufflePort.set(HiveConf.getIntVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT));
        this.containerRunner = new ContainerRunnerImpl((Configuration)this.daemonConf, 1, this.shufflePort, this.srvAddress, 1024L, this.metrics, this.amReporter, this.queryTracker, (Scheduler)this.executorService, this.daemonId, LlapUgiManager.getInstance((Configuration)this.daemonConf), this.socketFactory);
        ShuffleHandler.initializeAndStart((Configuration)this.daemonConf);
        this.executorService.init((Configuration)this.daemonConf);
        this.executorService.start();
        this.queryTracker.init((Configuration)this.daemonConf);
        this.queryTracker.start();
        this.containerRunner.init((Configuration)this.daemonConf);
        this.containerRunner.start();
    }

    @After
    public void cleanup() throws Exception {
        for (Object key : ShuffleHandler.get().getRegisteredApps().keySet()) {
            String appId = (String)key;
            ShuffleHandler.get().unregisterDag(null, appId, 1234);
        }
        this.containerRunner.serviceStop();
        this.queryTracker.serviceStop();
        this.executorService.serviceStop();
        this.executorService.serviceStop();
        LlapMetricsSystem.shutdown();
    }

    @Test(timeout=10000L)
    public void testRegisterDag() throws Exception {
        Credentials credentials = new Credentials();
        Token sessionToken = new Token("identifier".getBytes(), "testPassword".getBytes(), new Text("kind"), new Text("service"));
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)credentials);
        LlapDaemonProtocolProtos.RegisterDagRequestProto request = LlapDaemonProtocolProtos.RegisterDagRequestProto.newBuilder().setUser("testUser").setCredentialsBinary(ByteString.copyFrom((ByteBuffer)LlapTezUtils.serializeCredentials((Credentials)credentials))).setQueryIdentifier(LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString("application_1540489363818_0021").setDagIndex(1234).build()).build();
        this.containerRunner.registerDag(request);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredApps().size(), (long)1L);
        Assert.assertEquals(ShuffleHandler.get().getRegisteredApps().get("application_1540489363818_0021"), (Object)1234);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredDirectories().size(), (long)0L);
        this.containerRunner.registerDag(request);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredApps().size(), (long)1L);
        Assert.assertEquals(ShuffleHandler.get().getRegisteredApps().get("application_1540489363818_0021"), (Object)1234);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredDirectories().size(), (long)0L);
        LlapDaemonProtocolProtos.SubmitWorkRequestProto sRequest = LlapDaemonTestUtils.buildSubmitProtoRequest(1, "application_1540489363818_0021", 1234, 12345, "dagName", 0, 0, 0, 0, 1, credentials);
        this.containerRunner.submitWork(sRequest);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredApps().size(), (long)1L);
        Assert.assertEquals(ShuffleHandler.get().getRegisteredApps().get("application_1540489363818_0021"), (Object)1234);
        if (ShuffleHandler.get().isDirWatcherEnabled()) {
            Assert.assertEquals((long)ShuffleHandler.get().getRegisteredDirectories().size(), (long)1L);
            Assert.assertEquals(ShuffleHandler.get().getRegisteredDirectories().get("application_1540489363818_0021"), (Object)1234);
        }
    }

    @Test(timeout=10000L)
    public void testSubmitSameFragment() throws Exception {
        Credentials credentials = new Credentials();
        Token sessionToken = new Token("identifier".getBytes(), "testPassword".getBytes(), new Text("kind"), new Text("service"));
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)credentials);
        LlapDaemonProtocolProtos.RegisterDagRequestProto request = LlapDaemonProtocolProtos.RegisterDagRequestProto.newBuilder().setUser("testUser").setCredentialsBinary(ByteString.copyFrom((ByteBuffer)LlapTezUtils.serializeCredentials((Credentials)credentials))).setQueryIdentifier(LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString("application_1540489363818_0021").setDagIndex(1234).build()).build();
        this.containerRunner.registerDag(request);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredApps().size(), (long)1L);
        Assert.assertEquals(ShuffleHandler.get().getRegisteredApps().get("application_1540489363818_0021"), (Object)1234);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredDirectories().size(), (long)0L);
        int fragNum = 1;
        int attemptNum = 0;
        LlapDaemonProtocolProtos.SubmitWorkRequestProto sRequest1 = LlapDaemonTestUtils.buildSubmitProtoRequest(fragNum, attemptNum, "application_1540489363818_0021", 1234, 12345, "dagName", 0, 0, 0, 0, 1, credentials);
        this.containerRunner.submitWork(sRequest1);
        Assert.assertEquals((long)ShuffleHandler.get().getRegisteredApps().size(), (long)1L);
        Assert.assertEquals(ShuffleHandler.get().getRegisteredApps().get("application_1540489363818_0021"), (Object)1234);
        if (ShuffleHandler.get().isDirWatcherEnabled()) {
            Assert.assertEquals((long)ShuffleHandler.get().getRegisteredDirectories().size(), (long)1L);
            Assert.assertEquals(ShuffleHandler.get().getRegisteredDirectories().get("application_1540489363818_0021"), (Object)1234);
        }
        Assert.assertEquals((long)1L, (long)this.containerRunner.getExecutorStatus().size());
        boolean caughtException = false;
        try {
            LlapDaemonProtocolProtos.SubmitWorkRequestProto sRequest2 = LlapDaemonTestUtils.buildSubmitProtoRequest(fragNum, attemptNum, "application_1540489363818_0021", 1234, 12345, "dagName", 0, 0, 0, 0, 1, credentials);
            this.containerRunner.submitWork(sRequest2);
        }
        catch (IllegalArgumentException err) {
            err.printStackTrace();
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
        Assert.assertEquals((long)1L, (long)this.containerRunner.getExecutorStatus().size());
        attemptNum = 1;
        LlapDaemonProtocolProtos.SubmitWorkRequestProto sRequest3 = LlapDaemonTestUtils.buildSubmitProtoRequest(fragNum, attemptNum, "application_1540489363818_0021", 1234, 12345, "dagName", 0, 0, 0, 0, 1, credentials);
        this.containerRunner.submitWork(sRequest3);
        Assert.assertEquals((long)2L, (long)this.containerRunner.getExecutorStatus().size());
    }
}

