/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class LlapDaemonExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final String[] METRICS_SOURCES = new String[]{"JvmMetrics", "LlapDaemonExecutorMetrics-" + MetricsUtils.getHostName(), "LlapDaemonJvmMetrics-" + MetricsUtils.getHostName(), "LlapDaemon"};
    private static LlapDaemon daemon = null;

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!LOCK.tryLock(1L, TimeUnit.MINUTES)) {
            throw new IllegalStateException("Lock acquisition failed cause another test is using the LlapDaemon.");
        }
        String appName = "testLlapDaemon" + context.getUniqueId();
        HiveConf conf = new HiveConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS, (String)"llap");
        LlapDaemonInfo.initialize((String)appName, (Configuration)conf);
        daemon = new LlapDaemon((Configuration)conf, 1, LlapDaemon.getTotalHeapSize(), false, false, -1L, new String[1], 0, false, 0, 0, 0, 0, appName);
        daemon.init((Configuration)conf);
        daemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) {
        try {
            daemon.stop();
            for (String ms : METRICS_SOURCES) {
                LlapMetricsSystem.instance().unregisterSource(ms);
            }
            daemon = null;
        }
        finally {
            LOCK.unlock();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == LlapDaemon.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        assert (daemon != null);
        return daemon;
    }
}

