/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.hadoop.hive.llap.cli.service.LlapServiceCommandLine;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestLlapServiceCommandLine {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testArgumentParsingEmpty() throws Exception {
        this.thrown.expect(ParseException.class);
        this.thrown.expectMessage("instance must be set");
        new LlapServiceCommandLine(new String[0]);
    }

    @Test
    public void testArgumentParsingDefault() throws Exception {
        LlapServiceCommandLine cl = new LlapServiceCommandLine(new String[]{"--instances", "1"});
        TestCase.assertEquals(null, (String)cl.getAuxJars());
        TestCase.assertEquals((long)-1L, (long)cl.getCache());
        TestCase.assertEquals((Object)new Properties(), (Object)cl.getConfig());
        TestCase.assertEquals(null, (String)cl.getDirectory());
        TestCase.assertEquals((int)-1, (int)cl.getExecutors());
        TestCase.assertEquals((int)-1, (int)cl.getIoThreads());
        TestCase.assertEquals((boolean)true, (boolean)cl.getIsHBase());
        TestCase.assertEquals((boolean)true, (boolean)cl.getIsHiveAux());
        TestCase.assertEquals(null, (String)cl.getJavaPath());
        TestCase.assertEquals(null, (String)cl.getLlapQueueName());
        TestCase.assertEquals(null, (String)cl.getLogger());
        TestCase.assertEquals(null, (String)cl.getName());
        TestCase.assertEquals(null, (String)cl.getOutput());
        TestCase.assertEquals((long)-1L, (long)cl.getSize());
        TestCase.assertEquals((long)-1L, (long)cl.getXmx());
        TestCase.assertEquals((boolean)false, (boolean)cl.isStarting());
    }

    @Test
    public void testParsingArguments() throws Exception {
        LlapServiceCommandLine cl = new LlapServiceCommandLine(new String[]{"--instances", "2", "--auxjars", "auxjarsVal", "--cache", "10k", "--hiveconf", "a=b", "--directory", "directoryVal", "--executors", "4", "--iothreads", "5", "--auxhbase", "false", "--auxhive", "false", "--javaHome", "javaHomeVal", "--queue", "queueVal", "--logger", "console", "--name", "nameVal", "--output", "outputVal", "--size", "10m", "--xmx", "10g", "--startImmediately"});
        TestCase.assertEquals((String)"auxjarsVal", (String)cl.getAuxJars());
        TestCase.assertEquals((long)10240L, (long)cl.getCache());
        TestCase.assertEquals((Object)ConfigurationConverter.getProperties((Configuration)new MapConfiguration((Map)ImmutableMap.of((Object)"a", (Object)"b"))), (Object)cl.getConfig());
        TestCase.assertEquals((String)"directoryVal", (String)cl.getDirectory());
        TestCase.assertEquals((int)4, (int)cl.getExecutors());
        TestCase.assertEquals((int)5, (int)cl.getIoThreads());
        TestCase.assertEquals((boolean)false, (boolean)cl.getIsHBase());
        TestCase.assertEquals((boolean)false, (boolean)cl.getIsHiveAux());
        TestCase.assertEquals((String)"javaHomeVal", (String)cl.getJavaPath());
        TestCase.assertEquals((String)"queueVal", (String)cl.getLlapQueueName());
        TestCase.assertEquals((String)"console", (String)cl.getLogger());
        TestCase.assertEquals((String)"nameVal", (String)cl.getName());
        TestCase.assertEquals((String)"outputVal", (String)cl.getOutput());
        TestCase.assertEquals((long)0xA00000L, (long)cl.getSize());
        TestCase.assertEquals((long)0x280000000L, (long)cl.getXmx());
        TestCase.assertEquals((boolean)true, (boolean)cl.isStarting());
    }

    @Test
    public void testIllegalLogger() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--logger", "someValue"});
    }

    @Test
    public void testIllegalInstances() throws Exception {
        this.thrown.expect(NumberFormatException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "a"});
    }

    @Test
    public void testIllegalCache() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--cache", "a"});
    }

    @Test
    public void testIllegalExecutors() throws Exception {
        this.thrown.expect(NumberFormatException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--executors", "a"});
    }

    @Test
    public void testIllegalIoThreads() throws Exception {
        this.thrown.expect(NumberFormatException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--iothreads", "a"});
    }

    @Test
    public void testIllegalSize() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--size", "a"});
    }

    @Test
    public void testIllegalXmx() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new LlapServiceCommandLine(new String[]{"--instances", "1", "--xmx", "a"});
    }
}

