/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.IllegalCacheConfigurationException;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapIoDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.apache.orc.impl.OrcTail;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcMetadataCache {
    private static final int INCOMPLETE = 0;
    private static final int DRL = 1;

    @Test
    public void testCaseSomePartialBuffersAreEvicted() {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Object fileKey1 = new Object();
        Random rdm = new Random();
        ByteBuffer smallBuffer = ByteBuffer.allocate(128);
        rdm.nextBytes(smallBuffer.array());
        MetadataCache.LlapBufferOrBuffers result = cache.putFileMetadata(fileKey1, smallBuffer, null, null);
        Assert.assertEquals((long)2L, (long)result.getMultipleLlapBuffers().length);
        LlapAllocatorBuffer[] buffers = result.getMultipleLlapBuffers();
        buffers[1].decRef();
        buffers[1].invalidateAndRelease();
        Assert.assertNull((Object)cache.getFileMetadata(fileKey1));
    }

    @Test
    public void testBuffers() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Object fileKey1 = new Object();
        Random rdm = new Random();
        ByteBuffer smallBuffer = ByteBuffer.allocate(63);
        rdm.nextBytes(smallBuffer.array());
        MetadataCache.LlapBufferOrBuffers result = cache.putFileMetadata(fileKey1, smallBuffer, null, null);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        ByteBuffer cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        result = cache.putFileMetadata(fileKey1, smallBuffer, null, null);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        result = cache.getFileMetadata(fileKey1);
        cacheBuf = result.getSingleBuffer().getByteBufferDup();
        Assert.assertEquals((Object)smallBuffer, (Object)cacheBuf);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cache.notifyEvicted((MetadataCache.LlapMetadataBuffer)result.getSingleBuffer());
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result);
        ByteBuffer largeBuffer = ByteBuffer.allocate(160);
        rdm.nextBytes(largeBuffer.array());
        result = cache.putFileMetadata(fileKey1, largeBuffer, null, null);
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        Assert.assertNull((Object)result.getSingleBuffer());
        Assert.assertEquals((Object)largeBuffer, (Object)this.extractResultBbs(result));
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result.getSingleBuffer());
        Assert.assertEquals((Object)largeBuffer, (Object)this.extractResultBbs(result));
        LlapAllocatorBuffer b0 = result.getMultipleLlapBuffers()[0];
        LlapAllocatorBuffer b1 = result.getMultipleLlapBuffers()[1];
        cache.decRefBuffer((MemoryBufferOrBuffers)result);
        cache.notifyEvicted((MetadataCache.LlapMetadataBuffer)b1);
        result = cache.getFileMetadata(fileKey1);
        Assert.assertNull((Object)result);
        Assert.assertFalse((b0.incRef() > 0 ? 1 : 0) != 0);
    }

    public ByteBuffer extractResultBbs(MetadataCache.LlapBufferOrBuffers result) {
        int totalLen = 0;
        for (LlapAllocatorBuffer buf : result.getMultipleLlapBuffers()) {
            totalLen += buf.getByteBufferRaw().remaining();
        }
        ByteBuffer combinedBb = ByteBuffer.allocate(totalLen);
        for (LlapAllocatorBuffer buf : result.getMultipleLlapBuffers()) {
            combinedBb.put(buf.getByteBufferDup());
        }
        combinedBb.flip();
        return combinedBb;
    }

    @Test
    public void testIncompleteCbs() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        Object fileKey1 = new Object();
        cache.putIncompleteCbs(fileKey1, new DiskRange[]{new DiskRangeList(0L, 3L)}, 0L, null);
        cp.verifyEquals(1);
        DiskRangeList result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(0L, 3L), 0L, gotAllData);
        Assert.assertTrue((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L);
        cache.putIncompleteCbs(fileKey1, new DiskRange[]{new DiskRangeList(5L, 6L)}, 0L, null);
        cp.verifyEquals(3);
        DiskRangeList ranges = new DiskRangeList(0L, 3L);
        ranges.insertAfter(new DiskRangeList(4L, 6L));
        result = cache.getIncompleteCbs(fileKey1, ranges, 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L, 1L, 4L, 6L);
        ranges = new DiskRangeList(0L, 3L);
        ranges.insertAfter(new DiskRangeList(3L, 5L)).insertAfter(new DiskRangeList(5L, 6L));
        result = cache.getIncompleteCbs(fileKey1, ranges, 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 0L, 3L, 1L, 3L, 5L, 0L, 5L, 6L);
        result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(5L, 6L), 0L, gotAllData);
        Assert.assertTrue((boolean)gotAllData.value);
        this.verifyResult(result, 0L, 5L, 6L);
        result = cache.getIncompleteCbs(fileKey1, new DiskRangeList(4L, 5L), 0L, gotAllData);
        Assert.assertFalse((boolean)gotAllData.value);
        this.verifyResult(result, 1L, 4L, 5L);
    }

    @Test
    public void testGetOrcTailForPath() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 16384L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Path path = new Path("../data/files/alltypesorc");
        Configuration jobConf = new Configuration();
        Configuration daemonConf = new Configuration();
        CacheTag tag = CacheTag.build((String)"test-table");
        OrcTail uncached = OrcEncodedDataReader.getOrcTailForPath((Path)path, (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, null);
        jobConf.set(HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname, "true");
        OrcTail cached = OrcEncodedDataReader.getOrcTailForPath((Path)path, (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, null);
        Assert.assertEquals((Object)uncached.getSerializedTail(), (Object)cached.getSerializedTail());
        Assert.assertEquals((Object)uncached.getFileTail(), (Object)cached.getFileTail());
    }

    @Test
    public void testGetOrcTailForPathWithFileId() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 16384L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Path path = new Path("../data/files/alltypesorc");
        Configuration jobConf = new Configuration();
        Configuration daemonConf = new Configuration();
        CacheTag tag = CacheTag.build((String)"test-table");
        FileSystem fs = FileSystem.get((Configuration)daemonConf);
        FileStatus fileStatus = fs.getFileStatus(path);
        OrcTail uncached = OrcEncodedDataReader.getOrcTailForPath((Path)fileStatus.getPath(), (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, (Object)new SyntheticFileId(fileStatus));
        jobConf.set(HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname, "true");
        OrcTail cached = OrcEncodedDataReader.getOrcTailForPath((Path)fileStatus.getPath(), (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, null);
        Assert.assertEquals((Object)uncached.getSerializedTail(), (Object)cached.getSerializedTail());
        Assert.assertEquals((Object)uncached.getFileTail(), (Object)cached.getFileTail());
    }

    @Test
    public void testGetOrcTailForPathWithFileIdChange() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 16384L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        Path path = new Path("../data/files/alltypesorc");
        Configuration jobConf = new Configuration();
        Configuration daemonConf = new Configuration();
        CacheTag tag = CacheTag.build((String)"test-table");
        OrcEncodedDataReader.getOrcTailForPath((Path)path, (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, (Object)new SyntheticFileId(path, 100L, 100L));
        jobConf.set(HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname, "true");
        IOException ex = null;
        try {
            OrcEncodedDataReader.getOrcTailForPath((Path)path, (Configuration)jobConf, (CacheTag)tag, (Configuration)daemonConf, (MetadataCache)cache, (Object)new SyntheticFileId(path, 100L, 101L));
            Assert.fail();
        }
        catch (IOException e) {
            ex = e;
        }
        Assert.assertTrue((boolean)ex.getMessage().contains(HiveConf.ConfVars.LLAP_IO_CACHE_ONLY.varname));
    }

    @Test(expected=IllegalCacheConfigurationException.class)
    public void testGetOrcTailForPathCacheNotReady() throws Exception {
        Path path = new Path("../data/files/alltypesorc");
        Configuration conf = new Configuration();
        OrcEncodedDataReader.getOrcTailForPath((Path)path, (Configuration)conf, null, (Configuration)conf, null, null);
    }

    @Test
    public void testProactiveEvictionMark() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        int MAX_ALLOC = 64;
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        BuddyAllocator alloc = new BuddyAllocator(false, false, 8, 64, 1, 4096L, 0L, null, (MemoryManager)mm, metrics, null, true);
        MetadataCache cache = new MetadataCache(alloc, (MemoryManager)mm, (LowLevelCachePolicy)cp, true, metrics);
        long fn1 = 1L;
        long fn2 = 2L;
        long fn3 = 3L;
        AtomicBoolean isStopped = new AtomicBoolean(false);
        ByteBuffer bb = ByteBuffer.wrap("small-meta-data-content".getBytes());
        ByteBuffer bb2 = ByteBuffer.wrap("-large-meta-data-content-large-meta-data-content-large-meta-data-".getBytes());
        MetadataCache.LlapBufferOrBuffers table1Buffers1 = cache.putFileMetadata((Object)fn1, bb, CacheTag.build((String)"default.table1"), isStopped);
        Assert.assertNotNull((Object)table1Buffers1.getSingleLlapBuffer());
        MetadataCache.LlapBufferOrBuffers table1Buffers2 = cache.putFileMetadata((Object)fn2, bb2, CacheTag.build((String)"default.table1"), isStopped);
        Assert.assertNotNull((Object)table1Buffers2.getMultipleLlapBuffers());
        Assert.assertEquals((long)2L, (long)table1Buffers2.getMultipleLlapBuffers().length);
        ByteBuffer bb3 = ByteBuffer.wrap("small-meta-data-content-for-otherFile".getBytes());
        MetadataCache.LlapBufferOrBuffers table2Buffers1 = cache.putFileMetadata((Object)fn3, bb3, CacheTag.build((String)"default.table2"), isStopped);
        Assert.assertNotNull((Object)table2Buffers1.getSingleLlapBuffer());
        Predicate<CacheTag> predicate = tag -> "default.table1".equals(tag.getTableName());
        table1Buffers2.getMultipleLlapBuffers()[1].decRef();
        Assert.assertEquals((long)0L, (long)table1Buffers2.getMultipleLlapBuffers()[1].invalidate());
        Assert.assertEquals((long)96L, (long)cache.markBuffersForProactiveEviction(predicate, false));
        Assert.assertTrue((boolean)table1Buffers1.getSingleLlapBuffer().isMarkedForEviction());
        Assert.assertTrue((boolean)table1Buffers2.getMultipleLlapBuffers()[0].isMarkedForEviction());
        Assert.assertFalse((boolean)table1Buffers2.getMultipleLlapBuffers()[1].isMarkedForEviction());
        Assert.assertFalse((boolean)table2Buffers1.getSingleLlapBuffer().isMarkedForEviction());
    }

    public void verifyResult(DiskRangeList result, long ... vals) {
        for (int i = 0; i < vals.length; i += 3) {
            switch ((int)vals[i]) {
                case 0: {
                    Assert.assertTrue((boolean)(result instanceof IncompleteCb));
                    break;
                }
                case 1: {
                    Assert.assertFalse((boolean)(result instanceof IncompleteCb));
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
            Assert.assertEquals((long)vals[i + 1], (long)result.getOffset());
            Assert.assertEquals((long)vals[i + 2], (long)result.getEnd());
            result = result.next;
        }
        Assert.assertNull((Object)result);
    }

    private static class DummyMemoryManager
    implements MemoryManager {
        private int allocs;

        private DummyMemoryManager() {
        }

        public void reserveMemory(long memoryToReserve, AtomicBoolean isStopped) {
            ++this.allocs;
        }

        public long evictMemory(long memoryToEvict) {
            return 0L;
        }

        public void releaseMemory(long memUsage) {
        }

        public void updateMaxSize(long maxSize) {
        }
    }

    private static class DummyCachePolicy
    implements LowLevelCachePolicy {
        int lockCount = 0;
        int unlockCount = 0;

        private DummyCachePolicy() {
        }

        public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
            ++this.lockCount;
        }

        public void notifyLock(LlapCacheableBuffer buffer) {
            ++this.lockCount;
        }

        public void notifyUnlock(LlapCacheableBuffer buffer) {
            ++this.unlockCount;
        }

        public long evictSomeBlocks(long memoryToReserve) {
            return memoryToReserve;
        }

        public void setEvictionListener(EvictionListener listener) {
        }

        public void setParentDebugDumper(LlapIoDebugDump dumper) {
        }

        public long purge() {
            return 0L;
        }

        public void verifyEquals(int i) {
            Assert.assertEquals((long)i, (long)this.lockCount);
            Assert.assertEquals((long)i, (long)this.unlockCount);
        }

        public void debugDumpShort(StringBuilder sb) {
        }
    }
}

