/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCacheAllocationsEvictionsCycles {
    private static final Logger LOG = LoggerFactory.getLogger(TestCacheAllocationsEvictionsCycles.class);
    private static final LlapDaemonCacheMetrics CACHE_METRICS = LlapDaemonCacheMetrics.create((String)"testCache", (String)"testSession");
    private final long maxSize = 1024L;
    private final LowLevelCache dataCache = (LowLevelCache)Mockito.mock(LowLevelCache.class);
    private final SerDeLowLevelCacheImpl serdCache = (SerDeLowLevelCacheImpl)Mockito.mock(SerDeLowLevelCacheImpl.class);
    private final MetadataCache metaDataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private BuddyAllocator allocator;
    private MemoryManager memoryManager;
    private LowLevelCachePolicy cachePolicy;
    private EvictionTracker evictionTracker;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setDouble(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 1.0);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        int minBufferSize = 1;
        this.cachePolicy = new LowLevelLrfuCachePolicy(minBufferSize, 1024L, conf);
        this.memoryManager = new LowLevelCacheMemoryManager(1024L, this.cachePolicy, CACHE_METRICS);
        int maxAllocationSize = 1024;
        int minAllocationSize = 8;
        this.allocator = new BuddyAllocator(true, false, minAllocationSize, maxAllocationSize, 1, 1024L, 0L, null, this.memoryManager, CACHE_METRICS, "no-force-eviction", true);
        EvictionDispatcher evictionDispatcher = new EvictionDispatcher(this.dataCache, this.serdCache, this.metaDataCache, (EvictionAwareAllocator)this.allocator);
        this.evictionTracker = new EvictionTracker((EvictionListener)evictionDispatcher);
        this.cachePolicy.setEvictionListener((EvictionListener)this.evictionTracker);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Purge the cache on tear down");
        this.cachePolicy.purge();
        this.allocator = null;
        this.memoryManager = null;
        this.cachePolicy = null;
    }

    @Test(timeout=6000L)
    public void testMergeOfBlocksAfterDeallocate() {
        MemoryBuffer[] dest2;
        MemoryBuffer[] dest;
        for (MemoryBuffer memoryBuffer : dest = new MemoryBuffer[16]) {
            Assert.assertNull((Object)memoryBuffer);
        }
        this.allocator.allocateMultiple(dest, 64, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (MemoryBuffer value : dest) {
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)value);
        }
        for (MemoryBuffer value : dest) {
            Assert.assertTrue((boolean)(value instanceof LlapDataBuffer));
            LlapDataBuffer buffer = (LlapDataBuffer)value;
            Assert.assertEquals((long)buffer.getMemoryUsage(), (long)this.cachePolicy.evictSomeBlocks(buffer.getMemoryUsage()));
            this.memoryManager.releaseMemory(buffer.getMemoryUsage());
        }
        Assert.assertEquals((long)0L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (MemoryBuffer memoryBuffer : dest2 = new MemoryBuffer[2]) {
            Assert.assertNull((Object)memoryBuffer);
        }
        this.allocator.allocateMultiple(dest2, 512, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (int i = 0; i < dest2.length; ++i) {
            Assert.assertNotNull((Object)dest[i]);
            this.allocator.deallocate(dest2[i]);
        }
        Assert.assertEquals((long)0L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
    }

    @Test(timeout=6000L)
    public void testSimpleAllocateThenEvictThenAllocate() {
        MemoryBuffer[] dest;
        for (MemoryBuffer memoryBuffer : dest = new MemoryBuffer[16]) {
            Assert.assertNull((Object)memoryBuffer);
        }
        this.allocator.allocateMultiple(dest, 64, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (MemoryBuffer buffer : dest) {
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
        }
        dest = new MemoryBuffer[8];
        this.allocator.allocateMultiple(dest, 128, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (MemoryBuffer memoryBuffer : dest) {
            Assert.assertNotNull((Object)memoryBuffer);
            this.allocator.deallocate(memoryBuffer);
        }
    }

    @Test(timeout=6000L)
    public void testRandomFragmentation() {
        LlapDataBuffer buffer;
        int i;
        MemoryBuffer[] memBuffers8B = new MemoryBuffer[64];
        MemoryBuffer[] memBuffers16B = new MemoryBuffer[16];
        MemoryBuffer[] memBuffers32B = new MemoryBuffer[8];
        for (MemoryBuffer memoryBuffer : memBuffers8B) {
            Assert.assertNull((Object)memoryBuffer);
        }
        this.allocator.allocateMultiple(memBuffers8B, 8, null);
        this.allocator.allocateMultiple(memBuffers16B, 16, null);
        this.allocator.allocateMultiple(memBuffers32B, 32, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (i = 0; i < memBuffers8B.length; ++i) {
            LlapDataBuffer buffer2 = (LlapDataBuffer)memBuffers8B[i];
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer2);
            if (i % 2 != 0) continue;
            buffer2.incRef();
        }
        for (i = 0; i < memBuffers16B.length; ++i) {
            LlapDataBuffer buffer3 = (LlapDataBuffer)memBuffers16B[i];
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer3);
            if (i % 2 != 0) continue;
            buffer3.incRef();
        }
        for (i = 0; i < memBuffers32B.length; ++i) {
            LlapDataBuffer buffer4 = (LlapDataBuffer)memBuffers32B[i];
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer4);
            if (i % 2 != 0) continue;
            buffer4.incRef();
        }
        Assert.assertEquals((long)512L, (long)((LowLevelCacheMemoryManager)this.memoryManager).purge());
        for (MemoryBuffer memoryBuffer : memBuffers32B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            if (buffer.isLocked()) {
                buffer.decRef();
            }
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
        }
        for (MemoryBuffer memoryBuffer : memBuffers16B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            if (buffer.isLocked()) {
                buffer.decRef();
            }
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
        }
        for (MemoryBuffer memoryBuffer : memBuffers8B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            if (buffer.isLocked()) {
                buffer.decRef();
            }
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
        }
        Assert.assertEquals((long)512L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        memBuffers8B = new MemoryBuffer[64];
        memBuffers16B = new MemoryBuffer[16];
        memBuffers32B = new MemoryBuffer[8];
        this.evictionTracker.getEvicted().clear();
        this.allocator.allocateMultiple(memBuffers16B, 16, null);
        this.allocator.allocateMultiple(memBuffers8B, 8, null);
        this.allocator.allocateMultiple(memBuffers32B, 32, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        Assert.assertEquals((long)(memBuffers32B.length / 2 + memBuffers16B.length / 2 + memBuffers8B.length / 2), (long)this.evictionTracker.getEvicted().size());
        for (MemoryBuffer memoryBuffer : memBuffers8B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            this.allocator.deallocate((MemoryBuffer)buffer);
        }
        for (MemoryBuffer memoryBuffer : memBuffers16B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            this.allocator.deallocate((MemoryBuffer)buffer);
        }
        for (MemoryBuffer memoryBuffer : memBuffers32B) {
            buffer = (LlapDataBuffer)memoryBuffer;
            this.allocator.deallocate((MemoryBuffer)buffer);
        }
    }

    @Test(timeout=6000L)
    public void testFragmentation() {
        MemoryBuffer[] dest;
        for (MemoryBuffer memoryBuffer : dest = new MemoryBuffer[128]) {
            Assert.assertNull((Object)memoryBuffer);
        }
        this.allocator.allocateMultiple(dest, 8, null);
        Assert.assertEquals((long)1024L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        for (int i = 0; i < dest.length; ++i) {
            LlapDataBuffer buffer = (LlapDataBuffer)dest[i];
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
            if (i % 2 != 0) continue;
            buffer.incRef();
        }
        Assert.assertEquals((long)512L, (long)((LowLevelCacheMemoryManager)this.memoryManager).purge());
        Assert.assertEquals((long)512L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        MemoryBuffer[] dest2 = new MemoryBuffer[1];
        Allocator.AllocatorOutOfMemoryException exception = null;
        try {
            this.allocator.allocateMultiple(dest2, 16, null);
        }
        catch (Allocator.AllocatorOutOfMemoryException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((long)512L, (long)((LowLevelCacheMemoryManager)this.memoryManager).getCurrentUsedSize());
        Assert.assertTrue((boolean)((LlapDataBuffer)dest[0]).isLocked());
        ((LlapDataBuffer)dest[0]).decRef();
        this.evictionTracker.clear();
        this.cachePolicy.notifyUnlock((LlapCacheableBuffer)((LlapDataBuffer)dest[0]));
        this.allocator.allocateMultiple(dest2, 16, null);
        Assert.assertTrue((this.evictionTracker.getEvicted().size() >= 1 ? 1 : 0) != 0);
    }

    private final class EvictionTracker
    implements EvictionListener {
        private final EvictionListener evictionListener;
        private List<LlapCacheableBuffer> evicted = new ArrayList<LlapCacheableBuffer>();

        private EvictionTracker(EvictionListener evictionListener) {
            this.evictionListener = evictionListener;
        }

        public void notifyEvicted(LlapCacheableBuffer buffer) {
            this.evicted.add(buffer);
            this.evictionListener.notifyEvicted(buffer);
        }

        public void notifyProactivelyEvicted(LlapCacheableBuffer buffer) {
            this.evicted.add(buffer);
            this.evictionListener.notifyEvicted(buffer);
        }

        public List<LlapCacheableBuffer> getEvicted() {
            return this.evicted;
        }

        public void clear() {
            this.evicted.clear();
        }
    }
}

