/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestBuddyAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(TestBuddyAllocator.class);
    private final Random rdm = new Random(2284L);
    private final boolean isDirect;
    private final boolean isMapped;
    private final String tmpDir = System.getProperty("java.io.tmpdir", ".");

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({false, false}, {true, false}, {true, true});
    }

    public TestBuddyAllocator(boolean direct, boolean mmap) {
        this.isDirect = direct;
        this.isMapped = mmap;
    }

    @Test
    public void testVariableSizeAllocs() throws Exception {
        this.testVariableSizeInternal(1, 2, 1);
    }

    @Test
    public void testVariableSizeMultiAllocs() throws Exception {
        this.testVariableSizeInternal(3, 2, 3);
        this.testVariableSizeInternal(5, 2, 5);
    }

    @Test
    public void testSameSizes() throws Exception {
        int min = 3;
        int max = 8;
        int maxAlloc = 1 << max;
        BuddyAllocator a = new BuddyAllocator(this.isDirect, this.isMapped, 1 << min, maxAlloc, maxAlloc, (long)maxAlloc, 0L, this.tmpDir, (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), null, true);
        for (int i = max; i >= min; --i) {
            this.allocSameSize(a, 1 << max - i, i);
        }
    }

    @Test
    public void testMultipleArenas() throws Exception {
        int max = 8;
        int maxAlloc = 1 << max;
        int allocLog2 = max - 1;
        int arenaCount = 5;
        BuddyAllocator a = new BuddyAllocator(this.isDirect, this.isMapped, 8, maxAlloc, maxAlloc, (long)(maxAlloc * arenaCount), 0L, this.tmpDir, (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), null, true);
        this.allocSameSize(a, arenaCount * 2, allocLog2);
    }

    @Test
    public void testMTT() {
        int min = 3;
        int max = 8;
        int maxAlloc = 256;
        int allocsPerSize = 3;
        final BuddyAllocator a = new BuddyAllocator(this.isDirect, this.isMapped, 8, 256, 2048, 6144L, 0L, this.tmpDir, (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), "both", true);
        ExecutorService executor = Executors.newFixedThreadPool(3);
        final CountDownLatch cdlIn = new CountDownLatch(3);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        FutureTask<Void> upTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestBuddyAllocator.syncThreadStart(cdlIn, cdlOut);
                TestBuddyAllocator.this.allocateUp(a, 3, 8, 3, false);
                TestBuddyAllocator.this.allocateUp(a, 3, 8, 3, true);
                return null;
            }
        });
        FutureTask<Void> downTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestBuddyAllocator.syncThreadStart(cdlIn, cdlOut);
                TestBuddyAllocator.this.allocateDown(a, 3, 8, 3, false);
                TestBuddyAllocator.this.allocateDown(a, 3, 8, 3, true);
                return null;
            }
        });
        FutureTask<Void> sameTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestBuddyAllocator.syncThreadStart(cdlIn, cdlOut);
                for (int i = 3; i <= 8; ++i) {
                    TestBuddyAllocator.this.allocSameSize(a, (1 << 8 - i) * 3, i);
                }
                return null;
            }
        });
        executor.execute(sameTask);
        executor.execute(upTask);
        executor.execute(downTask);
        try {
            cdlIn.await();
            cdlOut.countDown();
        }
        catch (Throwable t) {
            LOG.error("failed on starting the thread race", t);
            throw new RuntimeException(t);
        }
        try {
            upTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("failed on up task", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            downTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("failed on downTask", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            sameTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("failed on sameTask", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testMTTArenas() {
        int i;
        int min = 3;
        int max = 4;
        int maxAlloc = 16;
        int minAllocCount = 2048;
        int threadCount = 4;
        final BuddyAllocator a = new BuddyAllocator(this.isDirect, this.isMapped, 8, 16, 16, 16384L, 0L, this.tmpDir, (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), null, true);
        ExecutorService executor = Executors.newFixedThreadPool(4);
        final CountDownLatch cdlIn = new CountDownLatch(4);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        Callable<Void> testCallable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestBuddyAllocator.syncThreadStart(cdlIn, cdlOut);
                TestBuddyAllocator.this.allocSameSize(a, 512, 3);
                return null;
            }
        };
        FutureTask[] allocTasks = new FutureTask[4];
        for (i = 0; i < 4; ++i) {
            allocTasks[i] = new FutureTask<Void>(testCallable);
            executor.execute(allocTasks[i]);
        }
        try {
            cdlIn.await();
            cdlOut.countDown();
            for (i = 0; i < 4; ++i) {
                allocTasks[i].get();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Test
    public void testCachedirCreated() throws Exception {
        int min = 3;
        int max = 8;
        int maxAlloc = 1 << max;
        new BuddyAllocator(this.isDirect, this.isMapped, 1 << min, maxAlloc, maxAlloc, (long)maxAlloc, 0L, this.tmpDir + "/testifcreated", (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), null, false);
    }

    static void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void testVariableSizeInternal(int allocCount, int arenaSizeMult, int arenaCount) throws Exception {
        int min = 3;
        int max = 8;
        int maxAlloc = 1 << max;
        int arenaSize = maxAlloc * arenaSizeMult;
        BuddyAllocator a = new BuddyAllocator(this.isDirect, this.isMapped, 1 << min, maxAlloc, arenaSize, (long)(arenaSize * arenaCount), 0L, this.tmpDir, (MemoryManager)new DummyMemoryManager(), LlapDaemonCacheMetrics.create((String)"test", (String)"1"), null, true);
        this.allocateUp(a, min, max, allocCount, true);
        this.allocateDown(a, min, max, allocCount, true);
        this.allocateDown(a, min, max, allocCount, false);
        this.allocateUp(a, min, max, allocCount, true);
        this.allocateUp(a, min, max, allocCount, false);
        this.allocateDown(a, min, max, allocCount, true);
    }

    private void allocSameSize(BuddyAllocator a, int allocCount, int sizeLog2) throws Exception {
        MemoryBuffer[][] allocs = new MemoryBuffer[allocCount][];
        long[][] testValues = new long[allocCount][];
        for (int j = 0; j < allocCount; ++j) {
            this.allocateAndUseBuffer(a, allocs, testValues, 1, j, sizeLog2);
        }
        this.deallocUpOrDown(a, false, allocs, testValues);
    }

    private void allocateUp(BuddyAllocator a, int min, int max, int allocPerSize, boolean isSameOrderDealloc) throws Exception {
        int sizes = max - min + 1;
        MemoryBuffer[][] allocs = new MemoryBuffer[sizes][];
        long[][] testValues = new long[sizes][];
        for (int i = min; i <= max; ++i) {
            this.allocateAndUseBuffer(a, allocs, testValues, allocPerSize, i - min, i);
        }
        this.deallocUpOrDown(a, isSameOrderDealloc, allocs, testValues);
    }

    private void allocateDown(BuddyAllocator a, int min, int max, int allocPerSize, boolean isSameOrderDealloc) throws Exception {
        int sizes = max - min + 1;
        MemoryBuffer[][] allocs = new MemoryBuffer[sizes][];
        long[][] testValues = new long[sizes][];
        for (int i = max; i >= min; --i) {
            this.allocateAndUseBuffer(a, allocs, testValues, allocPerSize, i - min, i);
        }
        this.deallocUpOrDown(a, isSameOrderDealloc, allocs, testValues);
    }

    private void allocateAndUseBuffer(BuddyAllocator a, MemoryBuffer[][] allocs, long[][] testValues, int allocCount, int index, int sizeLog2) throws Exception {
        allocs[index] = new MemoryBuffer[allocCount];
        testValues[index] = new long[allocCount];
        int size = (1 << sizeLog2) - 1;
        try {
            a.allocateMultiple(allocs[index], size);
        }
        catch (Allocator.AllocatorOutOfMemoryException ex) {
            LOG.error("Failed to allocate " + allocCount + " of " + size + "; " + a.testDump());
            throw ex;
        }
        for (int j = 0; j < allocCount; ++j) {
            MemoryBuffer mem = allocs[index][j];
            long l = this.rdm.nextLong();
            testValues[index][j] = l;
            long testValue = l;
            TestBuddyAllocator.putTestValue(mem, testValue);
        }
    }

    public static void putTestValue(MemoryBuffer mem, long testValue) {
        int pos = mem.getByteBufferRaw().position();
        mem.getByteBufferRaw().putLong(pos, testValue);
        int halfLength = mem.getByteBufferRaw().remaining() >> 1;
        if (halfLength + 8 <= mem.getByteBufferRaw().remaining()) {
            mem.getByteBufferRaw().putLong(pos + halfLength, testValue);
        }
    }

    public static void checkTestValue(MemoryBuffer mem, long testValue, String str) {
        int pos = mem.getByteBufferRaw().position();
        Assert.assertEquals((String)("Failed to match (" + pos + ") on " + str), (long)testValue, (long)mem.getByteBufferRaw().getLong(pos));
        int halfLength = mem.getByteBufferRaw().remaining() >> 1;
        if (halfLength + 8 <= mem.getByteBufferRaw().remaining()) {
            Assert.assertEquals((String)("Failed to match half (" + (pos + halfLength) + ") on " + str), (long)testValue, (long)mem.getByteBufferRaw().getLong(pos + halfLength));
        }
    }

    private void deallocUpOrDown(BuddyAllocator a, boolean isSameOrderDealloc, MemoryBuffer[][] allocs, long[][] testValues) {
        if (isSameOrderDealloc) {
            for (int i = 0; i < allocs.length; ++i) {
                this.deallocBuffers(a, allocs[i], testValues[i]);
            }
        } else {
            for (int i = allocs.length - 1; i >= 0; --i) {
                this.deallocBuffers(a, allocs[i], testValues[i]);
            }
        }
    }

    private void deallocBuffers(BuddyAllocator a, MemoryBuffer[] allocs, long[] testValues) {
        for (int j = 0; j < allocs.length; ++j) {
            LlapDataBuffer mem = (LlapDataBuffer)allocs[j];
            long testValue = testValues[j];
            String str = j + "/" + allocs.length;
            TestBuddyAllocator.checkTestValue((MemoryBuffer)mem, testValue, str);
            a.deallocate((MemoryBuffer)mem);
        }
    }

    static class DummyMemoryManager
    implements MemoryManager {
        DummyMemoryManager() {
        }

        public void reserveMemory(long memoryToReserve, AtomicBoolean isStopped) {
        }

        public long evictMemory(long memoryToEvict) {
            return 0L;
        }

        public void releaseMemory(long memUsage) {
        }

        public void updateMaxSize(long maxSize) {
        }
    }
}

