/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.MiniLlapCluster;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.registry.impl.LlapZookeeperRegistryImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLlapRegistryService {
    private static MiniLlapCluster cluster = null;
    private static HiveConf conf = new HiveConf();

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = MiniLlapCluster.create("llap01", null, 1, 2L, false, false, 1L, 1);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_XMX_HEADROOM, (String)"1");
        cluster.serviceInit((Configuration)conf);
        cluster.serviceStart();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (cluster != null) {
            cluster.serviceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockForConfigChange() throws IOException {
        LlapRegistryService client1 = null;
        LlapRegistryService client2 = null;
        try {
            client1 = new LlapRegistryService(false);
            client1.init((Configuration)conf);
            client1.start();
            client2 = new LlapRegistryService(false);
            client2.init((Configuration)conf);
            client2.start();
            Assert.assertTrue((boolean)client1.lockForConfigChange(10000L, 20000L).isSuccess());
            Assert.assertTrue((boolean)client2.lockForConfigChange(30000L, 40000L).isSuccess());
            LlapZookeeperRegistryImpl.ConfigChangeLockResult result = client1.lockForConfigChange(20000L, 30000L);
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertEquals((long)result.getNextConfigChangeTime(), (long)40000L);
            result = client1.lockForConfigChange(30000L, 40000L);
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertEquals((long)result.getNextConfigChangeTime(), (long)40000L);
            result = client1.lockForConfigChange(35000L, 45000L);
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertEquals((long)result.getNextConfigChangeTime(), (long)40000L);
            result = client1.lockForConfigChange(40000L, 50000L);
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertEquals((long)result.getNextConfigChangeTime(), (long)50000L);
        }
        finally {
            if (client1 != null) {
                client1.close();
            }
            if (client2 != null) {
                client2.close();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLockForConfigChangeInvalid() throws IOException {
        try (LlapRegistryService client = null;){
            client = new LlapRegistryService(false);
            client.init((Configuration)conf);
            client.start();
            client.lockForConfigChange(20000L, 10000L);
        }
    }
}

