/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.decode.EncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.encoded.VectorDeserializeOrcWriter;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.impl.SchemaEvolution;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class TestVectorDeserializeOrcWriter {
    private static final int TEST_NUM_COLS = 2;

    private static Field reflectField(Class<?> classToReflect, String fieldNameValueToFetch) {
        try {
            Field reflectField = null;
            Class<?> classForReflect = classToReflect;
            do {
                try {
                    reflectField = classForReflect.getDeclaredField(fieldNameValueToFetch);
                }
                catch (NoSuchFieldException e) {
                    classForReflect = classForReflect.getSuperclass();
                }
            } while (reflectField == null || classForReflect == null);
            reflectField.setAccessible(true);
            return reflectField;
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to reflect " + fieldNameValueToFetch + " from " + classToReflect));
            return null;
        }
    }

    private static void reflectSetValue(Object objToReflect, String fieldNameToSet, Object valueToSet) {
        try {
            Field reflectField = TestVectorDeserializeOrcWriter.reflectField(objToReflect.getClass(), fieldNameToSet);
            reflectField.set(objToReflect, valueToSet);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to reflectively set " + fieldNameToSet + "=" + valueToSet));
        }
    }

    @Test
    public void testConcurrencyIssueWhileWriting() throws Exception {
        EncodedDataConsumer consumer = TestVectorDeserializeOrcWriter.createBlankEncodedDataConsumer();
        Field cvbPoolField = EncodedDataConsumer.class.getDeclaredField("cvbPool");
        cvbPoolField.setAccessible(true);
        FixedSizedObjectPool cvbPool = (FixedSizedObjectPool)cvbPoolField.get(consumer);
        ColumnVectorBatch cvb = new ColumnVectorBatch(2);
        VectorizedRowBatch vrb = new VectorizedRowBatch(2);
        TestVectorDeserializeOrcWriter.createTestVectors(cvb, vrb);
        ConcurrentLinkedQueue<VectorDeserializeOrcWriter.WriteOperation> writeOpQueue = new ConcurrentLinkedQueue<VectorDeserializeOrcWriter.WriteOperation>();
        VectorDeserializeOrcWriter orcWriter = TestVectorDeserializeOrcWriter.createOrcWriter(writeOpQueue, vrb);
        orcWriter.addBatchToWriter();
        consumer.returnData(cvb);
        ((VectorDeserializeOrcWriter.WriteOperation)writeOpQueue.poll()).apply((Writer)Mockito.mock(WriterImpl.class), null);
        ColumnVectorBatch newCvb = (ColumnVectorBatch)cvbPool.take();
        Assert.assertNotEquals((Object)newCvb, (Object)cvb);
        consumer.returnData(cvb);
        newCvb = (ColumnVectorBatch)cvbPool.take();
        Assert.assertEquals((Object)newCvb, (Object)cvb);
    }

    private static void createTestVectors(ColumnVectorBatch cvb, VectorizedRowBatch vrb) {
        for (int i = 0; i < 2; ++i) {
            LongColumnVector cv = new LongColumnVector();
            cv.fill((long)i);
            cvb.cols[i] = cv;
            vrb.cols[i] = cv;
        }
    }

    private static VectorDeserializeOrcWriter createOrcWriter(Queue<VectorDeserializeOrcWriter.WriteOperation> writeOpQueue, VectorizedRowBatch vrb) {
        VectorDeserializeOrcWriter orcWriter = (VectorDeserializeOrcWriter)Mockito.mock(VectorDeserializeOrcWriter.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS));
        TestVectorDeserializeOrcWriter.reflectSetValue(orcWriter, "sourceBatch", vrb);
        TestVectorDeserializeOrcWriter.reflectSetValue(orcWriter, "destinationBatch", vrb);
        TestVectorDeserializeOrcWriter.reflectSetValue(orcWriter, "currentBatches", new ArrayList());
        TestVectorDeserializeOrcWriter.reflectSetValue(orcWriter, "queue", writeOpQueue);
        TestVectorDeserializeOrcWriter.reflectSetValue(orcWriter, "isAsync", true);
        return orcWriter;
    }

    private static EncodedDataConsumer createBlankEncodedDataConsumer() {
        return new EncodedDataConsumer(null, 1, null, null){

            protected void decodeBatch(EncodedColumnBatch batch, Consumer downstreamConsumer) throws InterruptedException {
            }

            public SchemaEvolution getSchemaEvolution() {
                return null;
            }

            public void consumeData(EncodedColumnBatch data) throws InterruptedException {
            }
        };
    }
}

