/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.TestBuddyAllocatorForceEvict;
import org.apache.hadoop.hive.llap.io.LlapIoMocks;
import org.apache.hadoop.hive.llap.io.encoded.LlapOrcCacheLoader;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.junit.Before;
import org.junit.Test;

public class TestLlapOrcCacheLoader {
    private static final int ORC_PADDING = 3;
    private static final String TEST_PATH = "../data/files/orc_compressed";
    private static final String TEST_PATH_UNCOMPRESSED = "../data/files/orc_uncompressed";
    private Configuration conf;
    private BuddyAllocator buddyAllocator;
    private LlapDaemonCacheMetrics metrics;
    private MetadataCache metaCache;
    private FixedSizedObjectPool<IoTrace> tracePool;
    private LowLevelCacheImpl cache;
    private DataCache mockDataCache;
    private LlapIoMocks.MockDiskRangeListFactory mockDiskRangeListFactory;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE, (int)1);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, 39L, this.conf);
        this.buddyAllocator = TestBuddyAllocatorForceEvict.create(2048, 2, 4096, false, true);
        this.metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        this.metaCache = new MetadataCache(this.buddyAllocator, null, (LowLevelCachePolicy)lrfu, false, this.metrics);
        this.tracePool = IoTrace.createTracePool((Configuration)this.conf);
        this.cache = new LowLevelCacheImpl(this.metrics, (LowLevelCachePolicy)lrfu, (Allocator)this.buddyAllocator, true);
        this.mockDataCache = new LlapIoMocks.MockDataCache(this.cache, (Allocator)this.buddyAllocator, (LowLevelCachePolicy)lrfu);
        this.mockDiskRangeListFactory = new LlapIoMocks.MockDiskRangeListFactory();
    }

    @Test(expected=IOException.class)
    public void testWrongFileKey() throws IOException {
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(new Path(TEST_PATH), null, this.conf, null, null, null, null);){
            loader.init();
        }
    }

    @Test
    public void testLoadFooter() throws IOException {
        Path path = new Path(TEST_PATH);
        SyntheticFileId key = this.fileId(path);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, null, (FileMetadataCache)this.metaCache, null, null);){
            loader.init();
            loader.loadFileFooter();
        }
        MetadataCache.LlapBufferOrBuffers metadata = this.metaCache.getFileMetadata((Object)key);
        Assert.notNull((Object)metadata);
    }

    @Test
    public void testLoadUncompressedRanges() throws IOException {
        Path path = new Path(TEST_PATH_UNCOMPRESSED);
        SyntheticFileId key = this.fileId(path);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, this.mockDataCache, (FileMetadataCache)this.metaCache, null, this.tracePool);){
            loader.init();
            DiskRangeList range = new DiskRangeList(3L, 296L);
            loader.loadRanges(range);
            DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
            this.cache.getFileData((Object)key, range, 0L, (DataCache.DiskRangeListFactory)this.mockDiskRangeListFactory, null, gotAllData);
            Assert.isTrue((boolean)gotAllData.value);
        }
    }

    @Test
    public void testLoadValidRanges() throws IOException {
        Path path = new Path(TEST_PATH);
        SyntheticFileId key = this.fileId(path);
        DiskRangeList range = new DiskRangeList(3L, 38L);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, this.mockDataCache, (FileMetadataCache)this.metaCache, null, this.tracePool);){
            loader.init();
            loader.loadRanges(range);
        }
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        this.cache.getFileData((Object)key, range, 0L, (DataCache.DiskRangeListFactory)this.mockDiskRangeListFactory, null, gotAllData);
        Assert.isTrue((boolean)gotAllData.value);
    }

    @Test
    public void testLoadAlreadyLoadedRange() throws IOException {
        Path path = new Path(TEST_PATH);
        SyntheticFileId key = this.fileId(path);
        DiskRangeList range = new DiskRangeList(3L, 38L);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, this.mockDataCache, (FileMetadataCache)this.metaCache, null, this.tracePool);){
            loader.init();
            loader.loadRanges(range);
        }
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        this.cache.getFileData((Object)key, range, 0L, (DataCache.DiskRangeListFactory)this.mockDiskRangeListFactory, null, gotAllData);
        Assert.isTrue((boolean)gotAllData.value);
        DiskRangeList range2 = new DiskRangeList(3L, 14L);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, this.mockDataCache, (FileMetadataCache)this.metaCache, null, this.tracePool);){
            loader.init();
            loader.loadRanges(range2);
        }
        gotAllData.value = false;
        this.cache.getFileData((Object)key, range, 0L, (DataCache.DiskRangeListFactory)this.mockDiskRangeListFactory, null, gotAllData);
        Assert.isTrue((boolean)gotAllData.value);
    }

    @Test
    public void testLoadBadlyEstimatedRanges() throws IOException {
        Path path = new Path(TEST_PATH);
        SyntheticFileId key = this.fileId(path);
        DiskRangeList range = new DiskRangeList(3L, 40L);
        try (LlapOrcCacheLoader loader = new LlapOrcCacheLoader(path, (Object)key, this.conf, this.mockDataCache, (FileMetadataCache)this.metaCache, null, this.tracePool);){
            loader.init();
            loader.loadRanges(range);
        }
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        this.cache.getFileData((Object)key, range, 0L, (DataCache.DiskRangeListFactory)this.mockDiskRangeListFactory, null, gotAllData);
        Assert.isTrue((!gotAllData.value ? 1 : 0) != 0);
    }

    private SyntheticFileId fileId(Path path) throws IOException {
        FileStatus fs = path.getFileSystem(this.conf).getFileStatus(path);
        return new SyntheticFileId(path, fs.getLen(), fs.getModificationTime());
    }
}

