/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryLimitedPathCache;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.apache.hadoop.hive.llap.cache.TestBuddyAllocatorForceEvict;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.LlapIoMocks;
import org.apache.hadoop.hive.llap.io.api.impl.LlapCacheMetadataSerializer;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLlapCacheMetadataSerializer {
    private static final String TEST_PATH = "../data/files/orc_compressed";
    private FileMetadataCache fileMetadataCache;
    private DataCache mockDataCache;
    private Configuration conf;
    private PathCache pathCache;
    private FixedSizedObjectPool<IoTrace> tracePool;
    private LowLevelCachePolicy cachePolicy;
    private LlapCacheMetadataSerializer serializer;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE, (int)1);
        HiveConf.setFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_HOTBUFFERS_PERCENTAGE, (float)1.0f);
        BuddyAllocator buddyAllocator = TestBuddyAllocatorForceEvict.create(16384, 2, 32768, false, true);
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"", (String)"");
        this.cachePolicy = new LowLevelLrfuCachePolicy(1, 5L, this.conf);
        LowLevelCacheImpl cache = new LowLevelCacheImpl(metrics, this.cachePolicy, (Allocator)buddyAllocator, true);
        this.fileMetadataCache = new MetadataCache(buddyAllocator, null, this.cachePolicy, false, metrics);
        this.tracePool = IoTrace.createTracePool((Configuration)this.conf);
        this.mockDataCache = new LlapIoMocks.MockDataCache(cache, (Allocator)buddyAllocator, this.cachePolicy);
        this.pathCache = new MemoryLimitedPathCache(this.conf);
        this.tracePool = IoTrace.createTracePool((Configuration)this.conf);
        this.serializer = new LlapCacheMetadataSerializer(this.fileMetadataCache, this.mockDataCache, this.conf, this.pathCache, this.tracePool, this.cachePolicy);
    }

    @Test
    public void testLoadData() throws IOException {
        LlapDaemonProtocolProtos.CacheEntryList dummyMetadata = this.createDummyMetadata();
        this.serializer.loadData(dummyMetadata);
        LlapDaemonProtocolProtos.CacheEntryList cachedMetadata = this.serializer.fetchCachedContentInfo();
        Assert.assertEquals((Object)dummyMetadata, (Object)cachedMetadata);
    }

    @Test
    public void testEncodeDecodeLongFileKey() throws IOException {
        Long originalKey = new Long(12345678L);
        ByteString encodedKey = LlapCacheMetadataSerializer.encodeFileKey((Object)originalKey);
        Object decodedKey = LlapCacheMetadataSerializer.decodeFileKey((ByteString)encodedKey);
        Assert.assertEquals((Object)originalKey, (Object)decodedKey);
    }

    @Test
    public void testEncodeDecodeSyntheticFileKey() throws IOException {
        SyntheticFileId originalKey = new SyntheticFileId(new Path("dummy"), 123L, 99999999L);
        ByteString encodedKey = LlapCacheMetadataSerializer.encodeFileKey((Object)originalKey);
        Object decodedKey = LlapCacheMetadataSerializer.decodeFileKey((ByteString)encodedKey);
        Assert.assertEquals((Object)originalKey, (Object)decodedKey);
    }

    private LlapDaemonProtocolProtos.CacheEntryList createDummyMetadata() throws IOException {
        LlapDaemonProtocolProtos.CacheEntryRange re1 = LlapDaemonProtocolProtos.CacheEntryRange.newBuilder().setStart(3L).setEnd(14L).build();
        LlapDaemonProtocolProtos.CacheEntryRange re2 = LlapDaemonProtocolProtos.CacheEntryRange.newBuilder().setStart(14L).setEnd(38L).build();
        LlapDaemonProtocolProtos.CacheTag ct = LlapDaemonProtocolProtos.CacheTag.newBuilder().setTableName("dummyTable").build();
        Path path = new Path(TEST_PATH);
        SyntheticFileId syntheticFileId = this.fileId(path);
        this.pathCache.touch((Object)syntheticFileId, path.toUri().toString());
        ByteString fileKey = LlapCacheMetadataSerializer.encodeFileKey((Object)syntheticFileId);
        LlapDaemonProtocolProtos.CacheEntry ce = LlapDaemonProtocolProtos.CacheEntry.newBuilder().setCacheTag(ct).setFilePath(TEST_PATH).setFileKey(fileKey).addRanges(re2).addRanges(re1).build();
        LlapDaemonProtocolProtos.CacheEntryList cel = LlapDaemonProtocolProtos.CacheEntryList.newBuilder().addEntries(ce).build();
        return cel;
    }

    private SyntheticFileId fileId(Path path) throws IOException {
        FileStatus fs = path.getFileSystem(this.conf).getFileStatus(path);
        return new SyntheticFileId(path, fs.getLen(), fs.getModificationTime());
    }
}

