/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io;

import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;

public final class LlapIoMocks {
    private LlapIoMocks() {
    }

    public static final class MockDiskRangeListFactory
    implements DataCache.DiskRangeListFactory {
        public DiskRangeList createCacheChunk(MemoryBuffer buffer, long startOffset, long endOffset) {
            return new CacheChunk(buffer, startOffset, endOffset);
        }
    }

    public static final class MockDataCache
    implements DataCache,
    Allocator.BufferObjectFactory {
        private LowLevelCacheImpl cache;
        private Allocator allocator;
        private LowLevelCachePolicy cachePolicy;

        public MockDataCache(LowLevelCacheImpl cache, Allocator allocator, LowLevelCachePolicy cachePolicy) {
            this.cache = cache;
            this.allocator = allocator;
            this.cachePolicy = cachePolicy;
        }

        public MemoryBuffer create() {
            return new LlapDataBuffer();
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            return this.cache.getFileData(fileKey, range, baseOffset, factory, null, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            return data != null ? this.cache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, null, null) : null;
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            this.cachePolicy.notifyUnlock((LlapCacheableBuffer)buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
        }

        public Allocator getAllocator() {
            return this.allocator;
        }

        public Allocator.BufferObjectFactory getDataBufferFactory() {
            return this;
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset, CacheTag tag) {
            return data != null ? this.cache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, null, tag) : null;
        }
    }
}

