/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.EvictingPriorityBlockingQueue;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorTestHelpers;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.ShortestJobFirstComparator;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestShortestJobFirstComparator {
    @Test(timeout=60000L)
    public void testWaitQueueComparator() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, "q1"), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, "q2"), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, "q3"), false, 1000000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, "q4"), false, 1000000);
        TaskExecutorService.TaskWrapper r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), false, 1000000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r5, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, "q1"), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, "q2"), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, "q3"), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, "q4"), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r5, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 100L, 1000L, "q1"), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 200L, 900L, "q2"), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 300L, 800L, "q3"), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 1, 400L, 700L, "q4"), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r4, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, "q1"), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, "q2"), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, "q3"), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, "q4"), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r4, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, "q1"), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, "q2"), false, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, "q3"), false, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, "q4"), false, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertEquals((Object)r4, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r5, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, "q1"), false, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, "q2"), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, "q3"), true, 1000000);
        r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, "q4"), true, 1000000);
        r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 10, 500L, 600L, "q5"), true, 1000000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertEquals((Object)r1, (Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r4, (Object)queue.take());
        Assert.assertEquals((Object)r5, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorWithinDagPriority() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 0, 10L, 100L, 10), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 0, 10L, 100L, 1), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 0, 10L, 100L, 5), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorCanFinish() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 0, 10L, 100L, 2), true, false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 0, 10L, 100L, 1), false, true, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 0, 10L, 100L, 5), true, true, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorWithinSameDagPriority() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 0, 10L, 1L, 10), true, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 0, 10L, 2L, 10), true, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 0, 10L, 3L, 10), true, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 3);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 1, 0, 10L, 100L, 10), true, 100000);
        Assert.assertEquals((Object)r4, (Object)queue.offer((Object)r4, 0));
        TaskExecutorService.TaskWrapper r0 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(0, 1, 0, 10L, 0L, 10), true, 100000);
        Assert.assertEquals((Object)r3, (Object)queue.offer((Object)r0, 0));
        Assert.assertEquals((Object)r0, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorParallelism() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 10, 3, 10L, 100L, 1, "q1", 35, false), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 10, 7, 10L, 100L, 1, "q2", 35, false), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 10, 5, 10L, 100L, 1, "q3", 35, false), false, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueComparatorAging() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 10, 100L, 200L, "q1"), true, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 20, 100L, 200L, "q2"), true, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 30, 100L, 200L, "q3"), true, 100000);
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r1, (Object)queue.take());
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 10, 100L, 200L, "q1"), true, 100000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 20, 100L, 3000L, "q2"), true, 100000);
        r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 30, 100L, 4000L, "q3"), true, 100000);
        queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 4);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r2, (Object)queue.take());
        Assert.assertEquals((Object)r3, (Object)queue.take());
        Assert.assertEquals((Object)r1, (Object)queue.take());
    }

    @Test(timeout=60000L)
    public void testWaitQueueAging() throws InterruptedException {
        TaskExecutorService.TaskWrapper[] r = new TaskExecutorService.TaskWrapper[50];
        for (int i = 0; i < 50; ++i) {
            LlapDaemonProtocolProtos.SubmitWorkRequestProto proto = TaskExecutorTestHelpers.createSubmitWorkRequestProto(i, 1, (long)(100 + i), (long)(100 + i), "q" + i, true);
            r[i] = TaskExecutorTestHelpers.createTaskWrapper(proto, true, 100000);
        }
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 50);
        for (int i = 0; i < 50; ++i) {
            Assert.assertNull((Object)queue.offer((Object)r[i], 0));
        }
        TaskExecutorService.TaskWrapper prev = (TaskExecutorService.TaskWrapper)queue.take();
        for (int i = 1; i < 50; ++i) {
            TaskExecutorService.TaskWrapper curr = (TaskExecutorService.TaskWrapper)queue.take();
            Assert.assertTrue((curr.getRequestId().compareTo(prev.getRequestId()) > 0 ? 1 : 0) != 0);
            prev = curr;
        }
    }

    @Test(timeout=60000L)
    public void testWaitQueueEdgeCases() {
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 10);
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 1000L, 1000L, "q11", true), true, 1000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 12, 11, 1000L, 1500L, 1, "q12", 35, true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        queue.remove((Object)r1);
        queue.remove((Object)r2);
        Assert.assertTrue((boolean)queue.isEmpty());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 800L, 1000L, "q11", true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        queue.remove((Object)r1);
        queue.remove((Object)r2);
        Assert.assertTrue((boolean)queue.isEmpty());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 1000L, 1000L, "q11", true), true, 1000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 12, 5, 1000L, 1000L, 1, "q12", 35, true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        queue.remove((Object)r1);
        queue.remove((Object)r2);
        Assert.assertTrue((boolean)queue.isEmpty());
        r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 5, 800L, 1000L, "q11", true), true, 1000);
        r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 12, 7, 700L, 900L, 1, "q12", 35, true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
    }

    @Test(timeout=60000L)
    public void testWaitQueueAgingComplex() throws InterruptedException {
        EvictingPriorityBlockingQueue queue = new EvictingPriorityBlockingQueue((Comparator)new ShortestJobFirstComparator(), 10);
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 1, 200L, 200L, "q1", true), true, 1000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 1, 199L, 199L, "q2", true), true, 1000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 1, 300L, 310L, "q3", true), true, 1000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 1, 400L, 420L, "q4", true), true, 1000);
        TaskExecutorService.TaskWrapper r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 1, 500L, 521L, "q5", true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r1, 0));
        Assert.assertEquals((Object)r1, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r2, 0));
        Assert.assertEquals((Object)r2, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r3, 0));
        Assert.assertEquals((Object)r3, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r4, 0));
        Assert.assertEquals((Object)r4, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r5, 0));
        Assert.assertEquals((Object)r5, (Object)queue.peek());
        TaskExecutorService.TaskWrapper r6 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(6, 10, 100L, 200L, "q6", true), true, 1000);
        TaskExecutorService.TaskWrapper r7 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(7, 10, 200L, 400L, "q7", true), true, 1000);
        TaskExecutorService.TaskWrapper r8 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(8, 10, 300L, 600L, "q8", true), true, 1000);
        TaskExecutorService.TaskWrapper r9 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(9, 10, 400L, 800L, "q9", true), true, 1000);
        TaskExecutorService.TaskWrapper r10 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(10, 10, 500L, 1000L, "q10", true), true, 1000);
        Assert.assertNull((Object)queue.offer((Object)r6, 0));
        Assert.assertEquals((Object)r5, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r7, 0));
        Assert.assertEquals((Object)r5, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r8, 0));
        Assert.assertEquals((Object)r8, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r9, 0));
        Assert.assertEquals((Object)r9, (Object)queue.peek());
        Assert.assertNull((Object)queue.offer((Object)r10, 0));
        Assert.assertEquals((Object)r10, (Object)queue.peek());
    }
}

