/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.SchedulerFragmentCompletingListener;
import org.apache.hadoop.hive.llap.daemon.impl.Scheduler;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorTestHelpers;
import org.apache.hadoop.hive.llap.daemon.impl.comparator.ShortestJobFirstComparator;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.testhelpers.ControlledClock;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTaskExecutorService {
    @Mock
    private LlapDaemonExecutorMetrics mockMetrics;
    Logger LOG = LoggerFactory.getLogger(TestTaskExecutorService.class);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeout=10000L)
    public void testPreemptionQueueComparator() throws InterruptedException {
        TaskExecutorService.TaskWrapper r1 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(1, 2, 100L, 200L, false), false, 100000);
        TaskExecutorService.TaskWrapper r2 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(2, 4, 200L, 300L, false), false, 100000);
        TaskExecutorService.TaskWrapper r3 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(3, 6, 300L, 400L, false), false, 1000000);
        TaskExecutorService.TaskWrapper r4 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(4, 8, 400L, 500L, false), false, 1000000);
        TaskExecutorService.TaskWrapper r5 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(5, 2, 100L, 200L, false), true, 1000000);
        TaskExecutorService.TaskWrapper r6 = TaskExecutorTestHelpers.createTaskWrapper(TaskExecutorTestHelpers.createSubmitWorkRequestProto(6, 8, 400L, 500L, true), false, 1000000);
        PriorityBlockingQueue<TaskExecutorService.TaskWrapper> queue = new PriorityBlockingQueue<TaskExecutorService.TaskWrapper>(6, (Comparator<TaskExecutorService.TaskWrapper>)new TaskExecutorService.PreemptionQueueComparator());
        queue.offer(r6);
        queue.offer(r5);
        queue.offer(r1);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r2);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r3);
        Assert.assertEquals((Object)r1, queue.peek());
        queue.offer(r4);
        Assert.assertEquals((Object)r1, queue.take());
        Assert.assertEquals((Object)r2, queue.take());
        Assert.assertEquals((Object)r3, queue.take());
        Assert.assertEquals((Object)r4, queue.take());
        Assert.assertEquals((Object)r5, queue.take());
        Assert.assertEquals((Object)r6, queue.take());
    }

    @Test(timeout=20000L)
    public void testFinishablePreemptsNonFinishable() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 50000000L, false, 10);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 10000000L, false, 11);
        this.testPreemptionHelper(r1, r2, true);
        r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 5000L, true, 12);
        r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 1000L, true, 13);
        this.testPreemptionHelper(r1, r2, true);
        r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 500L, true, 14);
        r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 1000L, false, 15);
        this.testPreemptionHelper(r1, r2, false);
        r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 500L, false, 15);
        r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 1000L, false, 15);
        this.testPreemptionHelper(r1, r2, false);
    }

    @Test
    public void testDuckPreemptsNonDuck() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 5000L, false, 1);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, false, 1000L, true, 2);
        this.testPreemptionHelper(r1, r2, true);
        r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 5000L, false, 2);
        r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, false, 1000L, true, 3);
        this.testPreemptionHelper(r1, r2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPreemptionHelper(TaskExecutorTestHelpers.MockRequest r1, TaskExecutorTestHelpers.MockRequest r2, boolean isPreemted) throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(r1);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            taskExecutorService.schedule(r2);
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            r1.awaitEnd();
            Assert.assertEquals((Object)isPreemted, (Object)r1.wasPreempted());
            Assert.assertTrue((boolean)r1.hasFinished());
            r2.complete();
            r2.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl1 = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl2 = taskExecutorService.getInternalCompletionListenerForTest(r2.getRequestId());
            icl1.awaitCompletion();
            icl2.awaitCompletion();
            Assert.assertEquals((long)0L, (long)taskExecutorService.knownTasks.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPreemptionStateOnTaskFlagChanges() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, true, 2000000L, true);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            String fragmentId = r1.getRequestId();
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            TaskExecutorService.TaskWrapper taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            r1.setCanUpdateFinishable();
            taskWrapper.finishableStateUpdated(true);
            TaskExecutorService.TaskWrapper taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper2);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            boolean result = taskExecutorService.updateFragment(fragmentId, true);
            Assert.assertTrue((boolean)result);
            taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper2);
            Assert.assertFalse((boolean)taskWrapper.isInPreemptionQueue());
            r1.complete();
            r1.awaitEnd();
            fragmentId = r2.getRequestId();
            submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper);
            result = taskExecutorService.updateFragment(fragmentId, false);
            Assert.assertTrue((boolean)result);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            result = taskExecutorService.updateFragment(fragmentId, true);
            Assert.assertTrue((boolean)result);
            taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper2);
            Assert.assertFalse((boolean)taskWrapper.isInPreemptionQueue());
            r2.setCanUpdateFinishable();
            taskWrapper.finishableStateUpdated(false);
            taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper2);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            r2.complete();
            r2.awaitEnd();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPreemptionQueueOnFinishableStateUpdates() throws InterruptedException {
        long r1WorkTime = 1000L;
        long r2WorkTime = 2000L;
        long r3WorkTime = 2000L;
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 2, 100L, 200L, false, r1WorkTime, false);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 200L, false, r2WorkTime, false);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 3, 50L, 200L, false, r3WorkTime, false);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(4, 2, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            String fragmentId1 = r1.getRequestId();
            Scheduler.SubmissionState submissionState1 = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState1);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            String fragmentId2 = r2.getRequestId();
            Scheduler.SubmissionState submissionState2 = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState2);
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            String fragmentId3 = r3.getRequestId();
            Scheduler.SubmissionState submissionState3 = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState3);
            this.awaitStartAndSchedulerRun(r3, taskExecutorService);
            TaskExecutorService.TaskWrapper taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId2, (Object)taskWrapper.getRequestId());
            Assert.assertEquals((long)3L, (long)taskExecutorService.preemptionQueue.size());
            r1.setCanUpdateFinishable();
            r2.setCanUpdateFinishable();
            r3.setCanUpdateFinishable();
            TaskExecutorService.TaskWrapper taskWrapper1 = (TaskExecutorService.TaskWrapper)taskExecutorService.knownTasks.get(fragmentId1);
            TaskExecutorService.TaskWrapper taskWrapper2 = (TaskExecutorService.TaskWrapper)taskExecutorService.knownTasks.get(fragmentId2);
            TaskExecutorService.TaskWrapper taskWrapper3 = (TaskExecutorService.TaskWrapper)taskExecutorService.knownTasks.get(fragmentId3);
            taskExecutorService.finishableStateUpdated(taskWrapper2, true);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId1, (Object)taskWrapper.getRequestId());
            Assert.assertFalse((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)3L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.finishableStateUpdated(taskWrapper1, true);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId3, (Object)taskWrapper.getRequestId());
            Assert.assertFalse((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)3L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.finishableStateUpdated(taskWrapper3, true);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId2, (Object)taskWrapper.getRequestId());
            Assert.assertTrue((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)3L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.finishableStateUpdated(taskWrapper3, true);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId2, (Object)taskWrapper.getRequestId());
            Assert.assertTrue((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)3L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.killFragment(fragmentId2);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId1, (Object)taskWrapper.getRequestId());
            Assert.assertTrue((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)2L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.finishableStateUpdated(taskWrapper3, false);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId3, (Object)taskWrapper.getRequestId());
            Assert.assertFalse((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)2L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.tryScheduleUnderLock(taskWrapper);
            Assert.assertEquals((long)2L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.killFragment(fragmentId3);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNotNull((Object)taskWrapper);
            Assert.assertTrue((boolean)taskWrapper.isInPreemptionQueue());
            Assert.assertEquals((Object)fragmentId1, (Object)taskWrapper.getRequestId());
            Assert.assertTrue((boolean)taskWrapper.canFinishForPriority());
            Assert.assertEquals((long)1L, (long)taskExecutorService.preemptionQueue.size());
            taskExecutorService.killFragment(fragmentId1);
            taskWrapper = (TaskExecutorService.TaskWrapper)taskExecutorService.preemptionQueue.peek();
            Assert.assertNull((Object)taskWrapper);
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testWaitQueueAcceptAfterAMTaskReport() throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 1, 200L, 2000L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 1, 2, 300L, 420L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 3, 400L, 510L, false, 20000L, false);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            r1.awaitStart();
            submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            taskExecutorService.fragmentCompleting(r1.getRequestId(), SchedulerFragmentCompletingListener.State.SUCCESS);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            Assert.assertEquals((long)3L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)1L, (long)taskExecutorService.completingFragmentMap.size());
            r1.complete();
            r1.awaitEnd();
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            Assert.assertEquals((long)0L, (long)taskExecutorService.completingFragmentMap.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    @Test(timeout=10000L)
    public void testWaitQueuePreemption() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 1, 200L, 330L, false, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 2, 2, 300L, 420L, false, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 3, 400L, 510L, false, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r5 = TaskExecutorTestHelpers.createMockRequest(5, 1, 500L, 610L, true, 20000L, false);
        this.testWaitQueuePreemptionHelper(r1, r2, r3, r4, r5);
    }

    @Test(timeout=10000L)
    public void testWaitQueuePreemptionDucks() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 200L, false, 20000L, true);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 1, 200L, 330L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 2, 2, 300L, 420L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 3, 400L, 510L, false, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r5 = TaskExecutorTestHelpers.createMockRequest(5, 1, 500L, 610L, false, 20000L, true);
        this.testWaitQueuePreemptionHelper(r1, r2, r3, r4, r5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWaitQueuePreemptionHelper(TaskExecutorTestHelpers.MockRequest r1, TaskExecutorTestHelpers.MockRequest r2, TaskExecutorTestHelpers.MockRequest r3, TaskExecutorTestHelpers.MockRequest r4, TaskExecutorTestHelpers.MockRequest r5) throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 2, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(r1);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r5);
            Assert.assertEquals((Object)Scheduler.SubmissionState.EVICTED_OTHER, (Object)submissionState);
            Assert.assertEquals((Object)true, (Object)r3.wasPreempted());
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl1 = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            Assert.assertEquals((long)3L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r1.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r5.getRequestId()));
            r1.complete();
            r1.awaitEnd();
            icl1.awaitCompletion();
            Assert.assertEquals((long)2L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r5.getRequestId()));
            this.awaitStartAndSchedulerRun(r5, taskExecutorService);
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl5 = taskExecutorService.getInternalCompletionListenerForTest(r5.getRequestId());
            r5.complete();
            r5.awaitEnd();
            icl5.awaitCompletion();
            Assert.assertEquals((long)1L, (long)taskExecutorService.knownTasks.size());
            Assert.assertTrue((boolean)taskExecutorService.knownTasks.containsKey(r2.getRequestId()));
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl2 = taskExecutorService.getInternalCompletionListenerForTest(r2.getRequestId());
            r2.complete();
            r2.awaitEnd();
            icl2.awaitCompletion();
            Assert.assertEquals((long)0L, (long)taskExecutorService.knownTasks.size());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    @Test(timeout=10000L)
    public void testDontKillMultiple() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest victim1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 100L, false, 20000L, false, 1);
        TaskExecutorTestHelpers.MockRequest victim2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 100L, false, 20000L, false, 2);
        this.runPreemptionGraceTest(victim1, victim2, 200);
        Assert.assertNotEquals((Object)victim1.wasPreempted(), (Object)victim2.wasPreempted());
    }

    @Test(timeout=10000L)
    public void testDoKillMultiple() throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest victim1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 100L, 100L, false, 20000L, false, 1);
        TaskExecutorTestHelpers.MockRequest victim2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 100L, 100L, false, 20000L, false, 2);
        this.runPreemptionGraceTest(victim1, victim2, 1000);
        Assert.assertTrue((boolean)victim1.wasPreempted());
        Assert.assertTrue((boolean)victim2.wasPreempted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSetCapacity() throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 1, 100L, 200L, true, 20000L, true);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 2, 100L, 200L, true, 20000L, true);
        TaskExecutorTestHelpers.MockRequest r3 = TaskExecutorTestHelpers.createMockRequest(3, 1, 3, 100L, 200L, true, 20000L, true);
        TaskExecutorTestHelpers.MockRequest r4 = TaskExecutorTestHelpers.createMockRequest(4, 1, 4, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r5 = TaskExecutorTestHelpers.createMockRequest(5, 1, 5, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r6 = TaskExecutorTestHelpers.createMockRequest(6, 1, 6, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r7 = TaskExecutorTestHelpers.createMockRequest(7, 1, 7, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r8 = TaskExecutorTestHelpers.createMockRequest(8, 1, 8, 100L, 200L, true, 20000L, false);
        TaskExecutorTestHelpers.MockRequest r9 = TaskExecutorTestHelpers.createMockRequest(9, 1, 9, 100L, 200L, true, 20000L, false);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r3);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r4);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            this.awaitStartAndSchedulerRun(r2, taskExecutorService);
            Assert.assertEquals((long)2L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)0L, (long)taskExecutorService.numSlotsAvailable.get());
            taskExecutorService.setCapacity(1, 1);
            Assert.assertEquals((long)1L, (long)taskExecutorService.waitQueue.waitQueueSize);
            Assert.assertEquals((long)1L, (long)taskExecutorService.maxParallelExecutors);
            Assert.assertEquals((long)2L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)-1L, (long)taskExecutorService.numSlotsAvailable.get());
            submissionState = taskExecutorService.schedule(r5);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            r1.awaitStart();
            r1.complete();
            r1.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            icl.awaitCompletion();
            Assert.assertEquals((long)2L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)0L, (long)taskExecutorService.numSlotsAvailable.get());
            r2.awaitStart();
            r2.complete();
            r2.awaitEnd();
            icl = taskExecutorService.getInternalCompletionListenerForTest(r2.getRequestId());
            icl.awaitCompletion();
            this.awaitStartAndSchedulerRun(r3, taskExecutorService);
            Assert.assertEquals((long)1L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)0L, (long)taskExecutorService.numSlotsAvailable.get());
            submissionState = taskExecutorService.schedule(r6);
            Assert.assertEquals((Object)Scheduler.SubmissionState.REJECTED, (Object)submissionState);
            r3.complete();
            r3.awaitEnd();
            icl = taskExecutorService.getInternalCompletionListenerForTest(r3.getRequestId());
            icl.awaitCompletion();
            submissionState = taskExecutorService.schedule(r7);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            taskExecutorService.setCapacity(2, 3);
            Assert.assertEquals((long)3L, (long)taskExecutorService.waitQueue.waitQueueSize);
            Assert.assertEquals((long)2L, (long)taskExecutorService.maxParallelExecutors);
            this.awaitStartAndSchedulerRun(r7, taskExecutorService);
            Assert.assertEquals((long)0L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)0L, (long)taskExecutorService.numSlotsAvailable.get());
            submissionState = taskExecutorService.schedule(r8);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r9);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            Assert.assertEquals((long)2L, (long)taskExecutorService.waitQueue.size());
            Assert.assertEquals((long)0L, (long)taskExecutorService.numSlotsAvailable.get());
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testZeroCapacity() throws InterruptedException {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(1, 1, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        TaskExecutorTestHelpers.MockRequest r1 = TaskExecutorTestHelpers.createMockRequest(1, 1, 1, 100L, 200L, true, 20000L, true);
        TaskExecutorTestHelpers.MockRequest r2 = TaskExecutorTestHelpers.createMockRequest(2, 1, 2, 100L, 200L, true, 20000L, true);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            Scheduler.SubmissionState submissionState = taskExecutorService.schedule(r1);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            submissionState = taskExecutorService.schedule(r2);
            Assert.assertEquals((Object)Scheduler.SubmissionState.ACCEPTED, (Object)submissionState);
            this.awaitStartAndSchedulerRun(r1, taskExecutorService);
            taskExecutorService.setCapacity(0, 0);
            Assert.assertTrue((boolean)r2.wasPreempted());
            Assert.assertFalse((boolean)r1.wasPreempted());
            r1.complete();
            r1.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl = taskExecutorService.getInternalCompletionListenerForTest(r1.getRequestId());
            icl.awaitCompletion();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void testSetCapacityHighExecutors() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.setCapacity(3, 3);
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void testSetCapacityHighQueueSize() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.setCapacity(2, 5);
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void testSetCapacityNegativeExecutors() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.setCapacity(-3, 3);
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void testSetCapacityNegativeQueueSize() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        taskExecutorService.setCapacity(2, -5);
    }

    @Test(timeout=10000L)
    public void testCapacityMetricsInitial() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 10, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        ((LlapDaemonExecutorMetrics)Mockito.verify((Object)this.mockMetrics)).setNumExecutors(2);
        ((LlapDaemonExecutorMetrics)Mockito.verify((Object)this.mockMetrics)).setWaitQueueSize(10);
    }

    @Test(timeout=10000L)
    public void testCapacityMetricsModification() {
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 10, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics);
        Mockito.reset((Object[])new LlapDaemonExecutorMetrics[]{this.mockMetrics});
        taskExecutorService.setCapacity(1, 5);
        ((LlapDaemonExecutorMetrics)Mockito.verify((Object)this.mockMetrics)).setNumExecutors(1);
        ((LlapDaemonExecutorMetrics)Mockito.verify((Object)this.mockMetrics)).setWaitQueueSize(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreemptionGraceTest(TaskExecutorTestHelpers.MockRequest victim1, TaskExecutorTestHelpers.MockRequest victim2, int time) throws InterruptedException {
        TaskExecutorTestHelpers.MockRequest preemptor = TaskExecutorTestHelpers.createMockRequest(3, 1, 100L, 100L, true, 20000L, false);
        victim1.setSleepAfterKill();
        victim2.setSleepAfterKill();
        ControlledClock clock = new ControlledClock((Clock)new SystemClock());
        clock.setTime(0L);
        TaskExecutorServiceForTest taskExecutorService = new TaskExecutorServiceForTest(2, 3, ShortestJobFirstComparator.class.getName(), true, this.mockMetrics, (Clock)clock);
        taskExecutorService.init(new Configuration());
        taskExecutorService.start();
        try {
            taskExecutorService.schedule(victim1);
            this.awaitStartAndSchedulerRun(victim1, taskExecutorService);
            taskExecutorService.schedule(victim2);
            this.awaitStartAndSchedulerRun(victim2, taskExecutorService);
            taskExecutorService.schedule(preemptor);
            taskExecutorService.waitForScheduleRuns(5);
            clock.setTime((long)time);
            taskExecutorService.waitForScheduleRuns(5);
            victim1.unblockKill();
            victim2.unblockKill();
            preemptor.complete();
            preemptor.awaitEnd();
            TaskExecutorServiceForTest.InternalCompletionListenerForTest icl3 = taskExecutorService.getInternalCompletionListenerForTest(preemptor.getRequestId());
            icl3.awaitCompletion();
        }
        finally {
            taskExecutorService.shutDown(false);
        }
    }

    private void awaitStartAndSchedulerRun(TaskExecutorTestHelpers.MockRequest mockRequest, TaskExecutorServiceForTest taskExecutorServiceForTest) throws InterruptedException {
        mockRequest.awaitStart();
        taskExecutorServiceForTest.awaitTryScheduleIfInProgress();
    }

    private static class TaskExecutorServiceForTest
    extends TaskExecutorService {
        private final Lock iclCreationLock = new ReentrantLock();
        private final Map<String, Condition> iclCreationConditions = new HashMap<String, Condition>();
        private final Lock tryScheduleLock = new ReentrantLock();
        private final Condition tryScheduleCondition = this.tryScheduleLock.newCondition();
        private boolean isInTrySchedule = false;
        private int scheduleAttempts = 0;
        private ConcurrentMap<String, InternalCompletionListenerForTest> completionListeners = new ConcurrentHashMap<String, InternalCompletionListenerForTest>();

        public TaskExecutorServiceForTest(int numExecutors, int waitQueueSize, String waitQueueComparatorClassName, boolean enablePreemption, LlapDaemonExecutorMetrics metrics) {
            this(numExecutors, waitQueueSize, waitQueueComparatorClassName, enablePreemption, metrics, null);
        }

        public TaskExecutorServiceForTest(int numExecutors, int waitQueueSize, String waitQueueComparatorClassName, boolean enablePreemption, LlapDaemonExecutorMetrics metrics, Clock clock) {
            super(numExecutors, waitQueueSize, waitQueueComparatorClassName, enablePreemption, Thread.currentThread().getContextClassLoader(), metrics, clock);
        }

        void tryScheduleUnderLock(TaskExecutorService.TaskWrapper taskWrapper) throws RejectedExecutionException {
            this.tryScheduleLock.lock();
            try {
                this.isInTrySchedule = true;
                super.tryScheduleUnderLock(taskWrapper);
            }
            finally {
                this.isInTrySchedule = false;
                ++this.scheduleAttempts;
                this.tryScheduleCondition.signal();
                this.tryScheduleLock.unlock();
            }
        }

        public void waitForScheduleRuns(int n) throws InterruptedException {
            this.tryScheduleLock.lock();
            try {
                int targetRuns = this.scheduleAttempts + n;
                while (this.scheduleAttempts < targetRuns) {
                    this.tryScheduleCondition.await(100L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.tryScheduleLock.unlock();
            }
        }

        private void awaitTryScheduleIfInProgress() throws InterruptedException {
            this.tryScheduleLock.lock();
            try {
                while (this.isInTrySchedule) {
                    this.tryScheduleCondition.await();
                }
            }
            finally {
                this.tryScheduleLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TaskExecutorService.InternalCompletionListener createInternalCompletionListener(TaskExecutorService.TaskWrapper taskWrapper) {
            this.iclCreationLock.lock();
            try {
                InternalCompletionListenerForTest icl = new InternalCompletionListenerForTest(taskWrapper);
                this.completionListeners.put(taskWrapper.getRequestId(), icl);
                Condition condition = this.iclCreationConditions.get(taskWrapper.getRequestId());
                if (condition == null) {
                    condition = this.iclCreationLock.newCondition();
                    this.iclCreationConditions.put(taskWrapper.getRequestId(), condition);
                }
                condition.signalAll();
                InternalCompletionListenerForTest internalCompletionListenerForTest = icl;
                return internalCompletionListenerForTest;
            }
            finally {
                this.iclCreationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InternalCompletionListenerForTest getInternalCompletionListenerForTest(String requestId) throws InterruptedException {
            this.iclCreationLock.lock();
            try {
                Condition condition = this.iclCreationConditions.get(requestId);
                if (condition == null) {
                    condition = this.iclCreationLock.newCondition();
                    this.iclCreationConditions.put(requestId, condition);
                }
                while (this.completionListeners.get(requestId) == null) {
                    condition.await();
                }
                InternalCompletionListenerForTest internalCompletionListenerForTest = (InternalCompletionListenerForTest)((Object)this.completionListeners.get(requestId));
                return internalCompletionListenerForTest;
            }
            finally {
                this.iclCreationLock.unlock();
            }
        }

        private class InternalCompletionListenerForTest
        extends TaskExecutorService.InternalCompletionListener {
            private final Lock lock;
            private final Condition completionCondition;
            private final AtomicBoolean isComplete;

            public InternalCompletionListenerForTest(TaskExecutorService.TaskWrapper taskWrapper) {
                super((TaskExecutorService)TaskExecutorServiceForTest.this, taskWrapper);
                this.lock = new ReentrantLock();
                this.completionCondition = this.lock.newCondition();
                this.isComplete = new AtomicBoolean(false);
            }

            public void onSuccess(TaskRunner2Result result) {
                super.onSuccess(result);
                this.markComplete();
            }

            public void onFailure(Throwable t) {
                super.onFailure(t);
                this.markComplete();
            }

            private void markComplete() {
                this.lock.lock();
                try {
                    this.isComplete.set(true);
                    this.completionCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void awaitCompletion() throws InterruptedException {
                this.lock.lock();
                try {
                    while (!this.isComplete.get()) {
                        this.completionCondition.await();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

