/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.hadoop.hive.llap.daemon.LlapDaemonExtension;
import org.apache.hadoop.hive.llap.daemon.LlapDaemonTestUtils;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.testutils.junit.extensions.DoNothingTCPServer;
import org.apache.hive.testutils.junit.extensions.DoNothingTCPServerExtension;
import org.apache.logging.log4j.core.test.junit.LoggerContextSource;
import org.apache.tez.common.security.TokenCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;

@LoggerContextSource(value="llap-daemon-routing-log4j2.properties")
public class TestLlapDaemonLogging {
    @Test
    @Extensions(value={@ExtendWith(value={LlapDaemonExtension.class}), @ExtendWith(value={DoNothingTCPServerExtension.class})})
    void testQueryRoutingNoLeakFileDescriptors(LlapDaemon daemon, DoNothingTCPServer amMockServer) throws IOException, InterruptedException {
        int amPort = amMockServer.port();
        Credentials credentials = TestLlapDaemonLogging.validSessionCredentials();
        String appId = "application_1540489363818_0021";
        for (int i = 0; i < 10; ++i) {
            String queryId = "query" + i;
            int dagId = 1000 + i;
            daemon.registerDag(LlapDaemonTestUtils.buildRegisterDagRequest(appId, dagId, credentials));
            daemon.submitWork(LlapDaemonTestUtils.buildSubmitProtoRequest(appId, dagId, queryId, amPort, credentials));
            daemon.queryComplete(LlapDaemonTestUtils.buildQueryCompleteRequest(appId, dagId));
        }
        while (!daemon.getExecutorsStatus().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(8000L);
        Pattern pn = Pattern.compile("query\\d++-dag_1540489363818_0021_\\d{4}\\.log");
        Assertions.assertEquals((long)0L, (long)TestLlapDaemonLogging.findOpenFileDescriptors(pn).count());
    }

    @Test
    @Extensions(value={@ExtendWith(value={LlapDaemonExtension.class}), @ExtendWith(value={DoNothingTCPServerExtension.class})})
    void testQueryRoutingLogFileNameOnIncompleteQuery(LlapDaemon daemon, DoNothingTCPServer amMockServer) throws IOException, InterruptedException {
        int amPort = amMockServer.port();
        Credentials credentials = TestLlapDaemonLogging.validSessionCredentials();
        String appId = "application_2500489363818_0021";
        String queryId = "query0";
        int dagId = 2000;
        daemon.registerDag(LlapDaemonTestUtils.buildRegisterDagRequest(appId, dagId, credentials));
        daemon.submitWork(LlapDaemonTestUtils.buildSubmitProtoRequest(appId, dagId, queryId, amPort, credentials));
        while (!daemon.getExecutorsStatus().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(8000L);
        TestLlapDaemonLogging.assertFileExists("query0-dag_2500489363818_0021_2000.log");
    }

    @Test
    @Extensions(value={@ExtendWith(value={LlapDaemonExtension.class}), @ExtendWith(value={DoNothingTCPServerExtension.class})})
    void testQueryRoutingLogFileNameOnCompleteQuery(LlapDaemon daemon, DoNothingTCPServer amMockServer) throws IOException, InterruptedException {
        int amPort = amMockServer.port();
        Credentials credentials = TestLlapDaemonLogging.validSessionCredentials();
        String appId = "application_3500489363818_0021";
        String queryId = "query0";
        int dagId = 3000;
        daemon.registerDag(LlapDaemonTestUtils.buildRegisterDagRequest(appId, dagId, credentials));
        daemon.submitWork(LlapDaemonTestUtils.buildSubmitProtoRequest(appId, dagId, queryId, amPort, credentials));
        daemon.queryComplete(LlapDaemonTestUtils.buildQueryCompleteRequest(appId, dagId));
        while (!daemon.getExecutorsStatus().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(8000L);
        TestLlapDaemonLogging.assertFileExists("query0-dag_3500489363818_0021_3000.log.done");
    }

    private static Credentials validSessionCredentials() {
        Credentials credentials = new Credentials();
        Token sessionToken = new Token("foo".getBytes(), "bar".getBytes(), new Text("kind"), new Text("service"));
        TokenCache.setSessionToken((Token)sessionToken, (Credentials)credentials);
        return credentials;
    }

    private static Stream<Path> findOpenFileDescriptors(Pattern searchPattern) throws IOException {
        return Files.walk(Paths.get("/proc/self/fd", new String[0]), new FileVisitOption[0]).filter(p -> {
            Path resolved = p;
            if (Files.isSymbolicLink(p)) {
                try {
                    resolved = Files.readSymbolicLink(p);
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
            }
            return searchPattern.matcher(resolved.toString()).find();
        });
    }

    private static void assertFileExists(String fileName) throws IOException {
        boolean found = Files.walk(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), new FileVisitOption[0]).anyMatch(p -> p.endsWith(fileName));
        Assertions.assertTrue((boolean)found, (String)("File " + fileName + " was not found under " + System.getProperty("java.io.tmpdir")));
    }
}

