/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.status;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.hive.llap.cli.status.LlapStatusServiceCommandLine;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestLlapStatusServiceCommandLine {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testArgumentParsingDefault() throws Exception {
        LlapStatusServiceCommandLine cl = new LlapStatusServiceCommandLine(new String[0]);
        TestCase.assertEquals((String)"findAppTimeout should be the default value if not specified otherwise", (long)cl.getFindAppTimeoutMs(), (long)20000L);
        TestCase.assertEquals((String)"refreshInterval should be the default value if not specified otherwise", (long)cl.getRefreshIntervalMs(), (long)1000L);
        TestCase.assertEquals((String)"watchTimeout should be the default value if not specified otherwise", (long)cl.getWatchTimeoutMs(), (long)300000L);
        TestCase.assertEquals((String)"runningNodesThreshold should be the default value if not specified otherwise", (Object)Float.valueOf(cl.getRunningNodesThreshold()), (Object)Float.valueOf(1.0f));
        TestCase.assertEquals((String)"hiveConf should be empty properties if not specified otherwise", (Object)cl.getHiveConf(), (Object)new Properties());
        TestCase.assertEquals((String)"isLaunched should be the true if not specified otherwise", (boolean)cl.isLaunched(), (boolean)true);
        TestCase.assertEquals((String)"watchMode should be the false if not specified otherwise", (boolean)cl.isWatchMode(), (boolean)false);
    }

    @Test
    public void testNegativeRefreshInterval() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Refresh interval should be >0");
        new LlapStatusServiceCommandLine(new String[]{"--refreshInterval", "-1"});
    }

    @Test
    public void testNegativeWatchTimeout() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Watch timeout should be >0");
        new LlapStatusServiceCommandLine(new String[]{"--watchTimeout", "-1"});
    }

    @Test
    public void testNegativeRunningNodesThreshold() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Running nodes threshold value should be between 0.0 and 1.0 (inclusive)");
        new LlapStatusServiceCommandLine(new String[]{"--runningNodesThreshold", "-1"});
    }

    @Test
    public void testRunningNodesThresholdOverOne() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Running nodes threshold value should be between 0.0 and 1.0 (inclusive)");
        new LlapStatusServiceCommandLine(new String[]{"--runningNodesThreshold", "1.1"});
    }
}

