/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.MemoryLimitedPathCache;
import org.junit.Assert;
import org.junit.Test;

public class TestMemoryLimitedPathCache {
    @Test
    public void testCache() {
        Configuration conf = new Configuration();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PATH_CACHE_SIZE, (String)"10Mb");
        MemoryLimitedPathCache pathCache = new MemoryLimitedPathCache(conf);
        Long[] keys = new Long[]{0L, 1L, 2L, 3L, 4L};
        String[] values = new String[]{"test_0", "test_1", "test_2", "test_3", "test_4"};
        pathCache.touch((Object)keys[0], values[0]);
        pathCache.touch((Object)keys[1], values[1]);
        pathCache.touch((Object)keys[2], values[2]);
        pathCache.touch((Object)keys[3], values[3]);
        pathCache.touch((Object)keys[4], values[4]);
        Assert.assertEquals((Object)values[4], (Object)pathCache.resolve((Object)keys[4]));
        Assert.assertEquals((Object)values[3], (Object)pathCache.resolve((Object)keys[3]));
        Assert.assertEquals((Object)values[0], (Object)pathCache.resolve((Object)keys[0]));
        Assert.assertEquals((Object)values[1], (Object)pathCache.resolve((Object)keys[1]));
        Assert.assertEquals((Object)values[2], (Object)pathCache.resolve((Object)keys[2]));
    }

    @Test
    public void testMemoryLimit() {
        Configuration conf = new Configuration();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PATH_CACHE_SIZE, (String)"400");
        MemoryLimitedPathCache pathCache = new MemoryLimitedPathCache(conf);
        Long key = 1L;
        String value = "36_36_36_36_36_36_36_36_36_36_36_36_";
        pathCache.touch((Object)key, value);
        String resolve = pathCache.resolve((Object)key);
        Assert.assertEquals((Object)value, (Object)resolve);
        pathCache.touch((Object)2, value);
        pathCache.touch((Object)3, value);
        pathCache.touch((Object)4, value);
        pathCache.touch((Object)5, value);
        resolve = pathCache.resolve((Object)key);
        Assert.assertNull((Object)resolve);
    }
}

