/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.cache.TestProactiveEviction;
import org.apache.hadoop.hive.llap.daemon.impl.LlapPooledIOThread;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLowLevelLrfuCachePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestLowLevelLrfuCachePolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegression_HIVE_12178() throws Exception {
        LOG.info("Testing wrong list status after eviction");
        EvictionTracker et = new EvictionTracker();
        int memSize = 2;
        Configuration conf = new Configuration();
        conf.setDouble(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 1.0);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        final LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)memSize, conf);
        Field f = LowLevelLrfuCachePolicy.class.getDeclaredField("listLock");
        f.setAccessible(true);
        ReentrantLock listLock = (ReentrantLock)f.get(lrfu);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)memSize, (LowLevelCachePolicy)lrfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lrfu.setEvictionListener((EvictionListener)et);
        final LlapDataBuffer buffer1 = LowLevelCacheImpl.allocateFake();
        LlapDataBuffer buffer2 = LowLevelCacheImpl.allocateFake();
        Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer1));
        Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer2));
        buffer1.incRef();
        Assert.assertEquals((long)-2L, (long)buffer1.indexInHeap);
        listLock.lock();
        try {
            Thread otherThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    lrfu.notifyLock((LlapCacheableBuffer)buffer1);
                }
            });
            otherThread.start();
            otherThread.join();
        }
        finally {
            listLock.unlock();
        }
        mm.reserveMemory(1L, false, null);
        Assert.assertSame((Object)buffer2, (Object)et.evicted.get(0));
        TestLowLevelLrfuCachePolicy.unlock(lrfu, buffer1);
    }

    @Test
    public void testHeapSize2() {
        this.testHeapSize(2);
    }

    @Test
    public void testHeapSize8() {
        this.testHeapSize(8);
    }

    @Test
    public void testHeapSize30() {
        this.testHeapSize(30);
    }

    @Test
    public void testHeapSize64() {
        this.testHeapSize(64);
    }

    @Test
    public void testLfuExtreme() {
        int i;
        int heapSize = 4;
        LOG.info("Testing lambda 0 (LFU)");
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 0.0f);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lfu.setEvictionListener((EvictionListener)et);
        for (i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lfu, et, buffer));
            inserted.add(buffer);
        }
        Collections.shuffle(inserted, rdm);
        for (i = inserted.size() - 1; i >= 0; --i) {
            for (int j = 0; j < i + 1; ++j) {
                lfu.notifyLock((LlapCacheableBuffer)inserted.get(i));
                lfu.notifyUnlock((LlapCacheableBuffer)inserted.get(i));
            }
        }
        this.verifyOrder(mm, lfu, et, inserted, null);
    }

    @Test
    public void testLruExtreme() {
        int i;
        int heapSize = 4;
        LOG.info("Testing lambda 1 (LRU)");
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 1.0f);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lru = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lru, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lru.setEvictionListener((EvictionListener)et);
        for (i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lru, et, buffer));
            inserted.add(buffer);
        }
        Collections.shuffle(inserted, rdm);
        for (i = 0; i < inserted.size(); ++i) {
            for (int j = 0; j < inserted.size() - i; ++j) {
                lru.notifyLock((LlapCacheableBuffer)inserted.get(i));
                lru.notifyUnlock((LlapCacheableBuffer)inserted.get(i));
            }
        }
        this.verifyOrder(mm, lru, et, inserted, null);
    }

    @Test
    public void testPurge() {
        int HEAP_SIZE = 32;
        Configuration conf = new Configuration();
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 0.2f);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, 32L, conf);
        MetricsMock m = this.createMetricsMock();
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager(32L, (LowLevelCachePolicy)lrfu, m.metricsMock);
        lrfu.setEvictionListener((EvictionListener)et);
        Assert.assertEquals((long)0L, (long)lrfu.purge());
        for (int testSize = 1; testSize <= 32; ++testSize) {
            LOG.info("Starting with " + testSize);
            ArrayList<LlapDataBuffer> purge = new ArrayList<LlapDataBuffer>(testSize);
            ArrayList<LlapDataBuffer> dontPurge = new ArrayList<LlapDataBuffer>(testSize);
            for (int i = 0; i < testSize; ++i) {
                LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
                Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
                if ((i + 1) % 3 == 0) {
                    buffer.incRef();
                    dontPurge.add(buffer);
                    continue;
                }
                purge.add(buffer);
            }
            lrfu.purge();
            for (LlapDataBuffer buffer : purge) {
                Assert.assertTrue((String)(buffer + " " + testSize), (boolean)buffer.isInvalid());
                mm.releaseMemory(buffer.getMemoryUsage());
            }
            for (LlapDataBuffer buffer : dontPurge) {
                Assert.assertFalse((boolean)buffer.isInvalid());
                buffer.decRef();
                mm.releaseMemory(buffer.getMemoryUsage());
            }
        }
    }

    @Test
    public void testDeadlockResolution() {
        int heapSize = 4;
        LOG.info("Testing deadlock resolution");
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        EvictionTracker et = new EvictionTracker();
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lrfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lrfu.setEvictionListener((EvictionListener)et);
        for (int i = 0; i < heapSize; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
            inserted.add(buffer);
        }
        LlapDataBuffer locked = (LlapDataBuffer)inserted.get(0);
        TestLowLevelLrfuCachePolicy.lock(lrfu, locked);
        mm.reserveMemory(1L, false, null);
        LlapDataBuffer evicted = et.evicted.get(0);
        Assert.assertNotNull((Object)evicted);
        Assert.assertTrue((boolean)evicted.isInvalid());
        Assert.assertNotSame((Object)locked, (Object)evicted);
        TestLowLevelLrfuCachePolicy.unlock(lrfu, locked);
    }

    @Test
    public void testBPWrapperFlush() throws Exception {
        LlapPooledIOThread thread = new LlapPooledIOThread(() -> {
            LlapDataBuffer buffer;
            int i;
            int heapSize = 20;
            LOG.info("Testing bp wrapper flush logic");
            ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
            EvictionTracker et = new EvictionTracker();
            Configuration conf = new Configuration();
            conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 10);
            LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
            LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lrfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
            lrfu.setEvictionListener((EvictionListener)et);
            for (i = 0; i < 4; ++i) {
                buffer = LowLevelCacheImpl.allocateFake();
                Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
                inserted.add(buffer);
            }
            Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 4L, 4L, 4L, 0L}, (long[])lrfu.metrics.getUsageStats());
            Assert.assertEquals((long)4L, (long)mm.purge());
            Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, (long[])lrfu.metrics.getUsageStats());
            for (i = 0; i < 8; ++i) {
                buffer = LowLevelCacheImpl.allocateFake();
                Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
                inserted.add(buffer);
            }
            Assert.assertArrayEquals((long[])new long[]{6L, 0L, 0L, 0L, 0L, 0L, 0L, 2L, 2L, 2L, 0L}, (long[])lrfu.metrics.getUsageStats());
            Assert.assertEquals((long)8L, (long)mm.purge());
            Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L}, (long[])lrfu.metrics.getUsageStats());
            Assert.assertTrue((boolean)et.evicted.containsAll(inserted));
        });
        thread.start();
        thread.join(30000L);
    }

    @Test
    public void testProactiveEvictionLFU() throws Exception {
        this.testProactiveEviction(0.0f, false);
    }

    @Test
    public void testProactiveEvictionLFUWithInstantDealloc() throws Exception {
        this.testProactiveEviction(0.0f, true);
    }

    @Test
    public void testProactiveEvictionLRU() throws Exception {
        this.testProactiveEviction(1.0f, false);
    }

    @Test
    public void testProactiveEvictionLRUWithInstantDealloc() throws Exception {
        this.testProactiveEviction(1.0f, true);
    }

    @Test
    public void testHotBuffers() {
        int heapSize = 10;
        int buffers = 20;
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_HOTBUFFERS_PERCENTAGE.varname, 0.1f);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LlapDataBuffer[] buffs = (LlapDataBuffer[])IntStream.range(0, buffers).mapToObj(i -> LowLevelCacheImpl.allocateFake()).toArray(LlapDataBuffer[]::new);
        Arrays.stream(buffs).forEach(b -> {
            b.allocSize = 10;
            lrfu.notifyUnlock((LlapCacheableBuffer)b);
        });
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[2]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[1]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[0]);
        List hotBuffers = lrfu.getHotBuffers();
        Assert.assertEquals(hotBuffers.get(0), (Object)buffs[0]);
        Assert.assertEquals(hotBuffers.get(1), (Object)buffs[1]);
        Assert.assertEquals((long)2L, (long)hotBuffers.size());
    }

    @Test
    public void testHotBuffersHeapAndList() {
        int heapSize = 3;
        int buffers = 20;
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_HOTBUFFERS_PERCENTAGE.varname, 0.2f);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LlapDataBuffer[] buffs = (LlapDataBuffer[])IntStream.range(0, buffers).mapToObj(i -> LowLevelCacheImpl.allocateFake()).toArray(LlapDataBuffer[]::new);
        Arrays.stream(buffs).forEach(b -> {
            b.allocSize = 10;
            lrfu.notifyUnlock((LlapCacheableBuffer)b);
        });
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[2]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[1]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[0]);
        List hotBuffers = lrfu.getHotBuffers();
        Assert.assertEquals(hotBuffers.get(0), (Object)buffs[0]);
        Assert.assertEquals(hotBuffers.get(1), (Object)buffs[1]);
        Assert.assertEquals(hotBuffers.get(2), (Object)buffs[2]);
        Assert.assertEquals(hotBuffers.get(3), (Object)buffs[19]);
        Assert.assertEquals((long)4L, (long)hotBuffers.size());
    }

    @Test
    public void testHotBuffersOnHalfFullHeap() {
        int heapSize = 39;
        int buffers = 20;
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_HOTBUFFERS_PERCENTAGE.varname, 0.2f);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LlapDataBuffer[] buffs = (LlapDataBuffer[])IntStream.range(0, buffers).mapToObj(i -> LowLevelCacheImpl.allocateFake()).toArray(LlapDataBuffer[]::new);
        Arrays.stream(buffs).forEach(b -> {
            b.allocSize = 10;
            lrfu.notifyUnlock((LlapCacheableBuffer)b);
        });
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[2]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[1]);
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[0]);
        List hotBuffers = lrfu.getHotBuffers();
        Assert.assertEquals(hotBuffers.get(0), (Object)buffs[0]);
        Assert.assertEquals(hotBuffers.get(1), (Object)buffs[1]);
        Assert.assertEquals(hotBuffers.get(2), (Object)buffs[2]);
        Assert.assertEquals(hotBuffers.get(3), (Object)buffs[19]);
        Assert.assertEquals((long)4L, (long)hotBuffers.size());
    }

    @Test
    public void testHotBuffersCutoff() {
        int heapSize = 3;
        int buffers = 20;
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_HOTBUFFERS_PERCENTAGE.varname, 0.2f);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        LlapDataBuffer[] buffs = (LlapDataBuffer[])IntStream.range(0, buffers).mapToObj(i -> LowLevelCacheImpl.allocateFake()).toArray(LlapDataBuffer[]::new);
        Arrays.stream(buffs).forEach(b -> {
            b.allocSize = 10;
            lrfu.notifyUnlock((LlapCacheableBuffer)b);
        });
        buffs[5].allocSize = 40;
        lrfu.notifyUnlock((LlapCacheableBuffer)buffs[5]);
        List hotBuffers = lrfu.getHotBuffers();
        Assert.assertEquals(hotBuffers.get(0), (Object)buffs[5]);
        Assert.assertEquals((long)1L, (long)hotBuffers.size());
    }

    private void testProactiveEviction(float lambda, boolean isInstantDealloc) throws Exception {
        TestProactiveEviction.closeSweeperExecutorForTest();
        int lrfuMaxSize = 10;
        HiveConf conf = new HiveConf();
        conf.setTimeVar(HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_SWEEP_INTERVAL, 1L, TimeUnit.HOURS);
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, lambda);
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        if (isInstantDealloc) {
            conf.setBoolVar(HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_INSTANT_DEALLOC, true);
        }
        EvictionTracker et = new EvictionTracker();
        LowLevelLrfuCachePolicy lfu = new LowLevelLrfuCachePolicy(1, (long)lrfuMaxSize, (Configuration)conf);
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)lrfuMaxSize, (LowLevelCachePolicy)lfu, LlapDaemonCacheMetrics.create((String)"test", (String)"1"));
        lfu.setEvictionListener((EvictionListener)et);
        et.mm = mm;
        LlapDataBuffer[] buffs = (LlapDataBuffer[])IntStream.range(0, lrfuMaxSize).mapToObj(i -> LowLevelCacheImpl.allocateFake()).toArray(LlapDataBuffer[]::new);
        Arrays.stream(buffs).forEach(b -> Assert.assertTrue((boolean)this.cache(mm, lfu, et, (LlapDataBuffer)b)));
        if (isInstantDealloc) {
            if ((double)lambda < 0.5) {
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[4]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[1]);
            } else {
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[1]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[5]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[2]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[4]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[9]);
                lfu.notifyUnlock((LlapCacheableBuffer)buffs[6]);
            }
        }
        buffs[1].markForEviction();
        buffs[3].markForEviction();
        buffs[5].markForEviction();
        buffs[7].markForEviction();
        if (isInstantDealloc) {
            int i2;
            for (i2 = 0; i2 < buffs.length; ++i2) {
                if (i2 != 1 && i2 != 3 && i2 != 5 && i2 != 7) continue;
                buffs[i2].invalidateAndRelease();
                mm.releaseMemory(buffs[i2].getMemoryUsage());
            }
            Assert.assertEquals((long)6L, (long)mm.getCurrentUsedSize());
            Assert.assertEquals((long)2L, (long)lfu.evictSomeBlocks(2L));
            mm.releaseMemory(2L);
            for (i2 = 0; i2 < buffs.length; ++i2) {
                Assert.assertEquals((Object)(i2 != 2 && i2 != 4 && i2 != 6 && i2 != 9 ? 1 : 0), (Object)buffs[i2].isInvalid());
                Assert.assertEquals((Object)(i2 == 0 || i2 == 8 ? 1 : 0), (Object)et.evicted.contains(buffs[i2]));
                Assert.assertEquals((Object)(i2 == 3 || i2 == 7 ? 1 : 0), (Object)et.proactivelyEvicted.contains(buffs[i2]));
            }
            lfu.evictProactively();
            for (i2 = 0; i2 < buffs.length; ++i2) {
                Assert.assertEquals((Object)(i2 != 2 && i2 != 4 && i2 != 6 && i2 != 9 ? 1 : 0), (Object)buffs[i2].isInvalid());
                Assert.assertEquals((Object)(i2 == 0 || i2 == 8 ? 1 : 0), (Object)et.evicted.contains(buffs[i2]));
                Assert.assertEquals((Object)(i2 == 1 || i2 == 3 || i2 == 5 || i2 == 7 ? 1 : 0), (Object)et.proactivelyEvicted.contains(buffs[i2]));
            }
            buffs[9].markForEviction();
            buffs[9].invalidateAndRelease();
            mm.releaseMemory(buffs[9].getMemoryUsage());
            Assert.assertEquals((long)3L, (long)lfu.purge());
            for (i2 = 0; i2 < buffs.length; ++i2) {
                Assert.assertTrue((boolean)buffs[i2].isInvalid());
                Assert.assertEquals((Object)(i2 == 0 || i2 == 2 || i2 == 4 || i2 == 6 || i2 == 8 ? 1 : 0), (Object)et.evicted.contains(buffs[i2]));
                Assert.assertEquals((Object)(i2 == 1 || i2 == 3 || i2 == 5 || i2 == 7 || i2 == 9 ? 1 : 0), (Object)et.proactivelyEvicted.contains(buffs[i2]));
            }
        } else {
            Assert.assertEquals((long)lrfuMaxSize, (long)mm.getCurrentUsedSize());
            buffs[4].markForEviction();
            lfu.notifyUnlock((LlapCacheableBuffer)buffs[4]);
            Assert.assertFalse((boolean)buffs[4].isMarkedForEviction());
            lfu.evictProactively();
            Assert.assertEquals((long)6L, (long)mm.getCurrentUsedSize());
            for (int i3 = 0; i3 < buffs.length; ++i3) {
                Assert.assertEquals((Object)(i3 == 1 || i3 == 3 || i3 == 5 || i3 == 7 ? 1 : 0), (Object)buffs[i3].isInvalid());
                Assert.assertEquals((Object)(i3 == 1 || i3 == 3 || i3 == 5 || i3 == 7 ? 1 : 0), (Object)et.proactivelyEvicted.contains(buffs[i3]));
            }
            mm.reserveMemory(10L, false, null);
            IntStream.range(0, lrfuMaxSize).forEach(i -> Assert.assertTrue((boolean)buffs[i].isInvalid()));
            Assert.assertEquals((long)0L, (long)lfu.purge());
        }
    }

    public boolean cache(LowLevelCacheMemoryManager mm, LowLevelLrfuCachePolicy lrfu, EvictionTracker et, LlapDataBuffer buffer) {
        if (mm != null && !mm.reserveMemory(1L, false, null)) {
            return false;
        }
        buffer.incRef();
        lrfu.cache((LlapCacheableBuffer)buffer, LowLevelCache.Priority.NORMAL);
        buffer.decRef();
        lrfu.notifyUnlock((LlapCacheableBuffer)buffer);
        return true;
    }

    private LlapDataBuffer getOneEvictedBuffer(EvictionTracker et) {
        Assert.assertTrue((et.evicted.size() == 0 || et.evicted.size() == 1 ? 1 : 0) != 0);
        LlapDataBuffer result = et.evicted.isEmpty() ? null : et.evicted.get(0);
        et.evicted.clear();
        return result;
    }

    private static void lock(LowLevelLrfuCachePolicy lrfu, LlapDataBuffer locked) {
        locked.incRef();
        lrfu.notifyLock((LlapCacheableBuffer)locked);
    }

    private static void unlock(LowLevelLrfuCachePolicy lrfu, LlapDataBuffer locked) {
        locked.decRef();
        lrfu.notifyUnlock((LlapCacheableBuffer)locked);
    }

    private MetricsMock createMetricsMock() {
        LlapDaemonCacheMetrics metricsMock = (LlapDaemonCacheMetrics)Mockito.mock(LlapDaemonCacheMetrics.class);
        final AtomicLong cacheUsed = new AtomicLong(0L);
        ((LlapDaemonCacheMetrics)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                cacheUsed.addAndGet((Long)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)metricsMock)).incrCacheCapacityUsed(ArgumentMatchers.anyLong());
        return new MetricsMock(cacheUsed, metricsMock);
    }

    private void testHeapSize(int heapSize) {
        LOG.info("Testing heap size " + heapSize);
        Random rdm = new Random(1234L);
        Configuration conf = new Configuration();
        conf.setFloat(HiveConf.ConfVars.LLAP_LRFU_LAMBDA.varname, 0.2f);
        EvictionTracker et = new EvictionTracker();
        conf.setInt(HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE.varname, 1);
        LowLevelLrfuCachePolicy lrfu = new LowLevelLrfuCachePolicy(1, (long)heapSize, conf);
        MetricsMock m = this.createMetricsMock();
        LowLevelCacheMemoryManager mm = new LowLevelCacheMemoryManager((long)heapSize, (LowLevelCachePolicy)lrfu, m.metricsMock);
        lrfu.setEvictionListener((EvictionListener)et);
        int toEvict = 2;
        ArrayList<LlapDataBuffer> inserted = new ArrayList<LlapDataBuffer>(heapSize);
        LlapDataBuffer[] evicted = new LlapDataBuffer[toEvict];
        Assume.assumeTrue((toEvict <= heapSize ? 1 : 0) != 0);
        for (int i = 0; i < heapSize + toEvict; ++i) {
            LlapDataBuffer buffer = LowLevelCacheImpl.allocateFake();
            Assert.assertTrue((boolean)this.cache(mm, lrfu, et, buffer));
            Assert.assertEquals((long)Math.min(i + 1, heapSize), (long)m.cacheUsed.get());
            LlapDataBuffer evictedBuf = this.getOneEvictedBuffer(et);
            if (i < toEvict) {
                evicted[i] = buffer;
                continue;
            }
            if (i >= heapSize) {
                Assert.assertSame((Object)evicted[i - heapSize], (Object)evictedBuf);
                Assert.assertTrue((boolean)evictedBuf.isInvalid());
            } else {
                Assert.assertNull((Object)evictedBuf);
            }
            inserted.add(buffer);
        }
        LOG.info("Inserted " + this.dumpInserted(inserted));
        Collections.shuffle(inserted, rdm);
        LOG.info("Touch order " + this.dumpInserted(inserted));
        for (LlapDataBuffer buf : inserted) {
            TestLowLevelLrfuCachePolicy.lock(lrfu, buf);
        }
        Assert.assertEquals((long)heapSize, (long)m.cacheUsed.get());
        Assert.assertFalse((boolean)mm.reserveMemory(1L, false, null));
        if (!et.evicted.isEmpty()) {
            Assert.assertTrue((String)("Got " + et.evicted.get(0)), (boolean)et.evicted.isEmpty());
        }
        for (LlapDataBuffer buf : inserted) {
            TestLowLevelLrfuCachePolicy.unlock(lrfu, buf);
        }
        for (LlapDataBuffer buf : inserted) {
            for (int j = 0; j < 10; ++j) {
                lrfu.notifyLock((LlapCacheableBuffer)buf);
                lrfu.notifyUnlock((LlapCacheableBuffer)buf);
            }
        }
        this.verifyOrder(mm, lrfu, et, inserted, m.cacheUsed);
    }

    private void verifyOrder(LowLevelCacheMemoryManager mm, LowLevelLrfuCachePolicy lrfu, EvictionTracker et, ArrayList<LlapDataBuffer> inserted, AtomicLong cacheUsed) {
        int i;
        et.evicted.clear();
        for (i = 0; i < inserted.size(); ++i) {
            Assert.assertTrue((boolean)mm.reserveMemory(1L, false, null));
            if (cacheUsed == null) continue;
            Assert.assertEquals((long)inserted.size(), (long)cacheUsed.get());
        }
        Assert.assertFalse((boolean)mm.reserveMemory(1L, false, null));
        if (cacheUsed != null) {
            Assert.assertEquals((long)inserted.size(), (long)cacheUsed.get());
        }
        for (i = 0; i < inserted.size(); ++i) {
            LlapDataBuffer block = et.evicted.get(i);
            Assert.assertTrue((boolean)block.isInvalid());
            Assert.assertSame((Object)inserted.get(i), (Object)block);
        }
        if (cacheUsed != null) {
            mm.releaseMemory((long)inserted.size());
            Assert.assertEquals((long)0L, (long)cacheUsed.get());
        }
    }

    private String dumpInserted(ArrayList<LlapDataBuffer> inserted) {
        Object debugStr = "";
        for (int i = 0; i < inserted.size(); ++i) {
            if (i != 0) {
                debugStr = (String)debugStr + ", ";
            }
            debugStr = (String)debugStr + inserted.get(i);
        }
        return debugStr;
    }

    static class EvictionTracker
    implements EvictionListener {
        public List<LlapDataBuffer> evicted = new ArrayList<LlapDataBuffer>();
        public List<LlapDataBuffer> proactivelyEvicted = new ArrayList<LlapDataBuffer>();
        public MemoryManager mm;

        EvictionTracker() {
        }

        public void notifyEvicted(LlapCacheableBuffer buffer) {
            this.evicted.add((LlapDataBuffer)buffer);
        }

        public void notifyProactivelyEvicted(LlapCacheableBuffer buffer) {
            int res = ((LlapAllocatorBuffer)buffer).releaseInvalidated();
            if (this.mm != null && res >= 0) {
                this.mm.releaseMemory(buffer.getMemoryUsage());
            }
            this.proactivelyEvicted.add((LlapDataBuffer)buffer);
        }
    }

    private static class MetricsMock {
        public AtomicLong cacheUsed;
        public LlapDaemonCacheMetrics metricsMock;

        public MetricsMock(AtomicLong cacheUsed, LlapDaemonCacheMetrics metricsMock) {
            this.cacheUsed = cacheUsed;
            this.metricsMock = metricsMock;
        }
    }
}

