/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.ql.io.orc.encoded.LlapDataReader;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.orc.CompressionCodec;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.OrcIndex;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIncrementalObjectSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(TestIncrementalObjectSizeEstimator.class);

    @Test
    public void testSimpleTypes() {
        JavaDataModel memModel = JavaDataModel.get();
        int intSize = this.runEstimate(0, memModel, null);
        this.runEstimate("", memModel, "empty string");
        this.runEstimate("foobarzzzzzzzzzzzzzz", memModel, null);
        ArrayList<Object> list = new ArrayList<Object>(0);
        this.runEstimate(list, memModel, "empty ArrayList");
        list.add("zzz");
        this.runEstimate(list, memModel, "ArrayList - one string");
        list.add(5);
        list.add(6);
        int arrayListSize = this.runEstimate(list, memModel, "ArrayList - 3 elements");
        LinkedHashSet<Object> list2 = new LinkedHashSet<Object>(0);
        this.runEstimate(list2, memModel, "empty LinkedHashSet");
        list2.add("zzzz");
        this.runEstimate(list2, memModel, "LinkedHashSet - one string");
        list2.add(7);
        list2.add(4);
        int lhsSize = this.runEstimate(list2, memModel, "LinkedHashSet - 3 elements");
        Struct struct = new Struct();
        int structSize = this.runEstimate(struct, memModel, "Struct - empty");
        struct.i = 10;
        int structSize2 = this.runEstimate(struct, memModel, "Struct - one reference");
        Assert.assertEquals((long)(intSize + structSize), (long)structSize2);
        struct.list = list;
        int structSize3 = this.runEstimate(struct, memModel, "Struct - with ArrayList");
        Assert.assertEquals((long)(arrayListSize + structSize2), (long)structSize3);
        struct.list2 = list2;
        int structSize4 = this.runEstimate(struct, memModel, "Struct - with LinkedHashSet");
        Assert.assertEquals((long)(lhsSize + structSize3), (long)structSize4);
        Struct2 struct2 = new Struct2();
        int recSize1 = this.runEstimate(struct2, memModel, "recursive struct - empty");
        struct2.next = new Struct2();
        struct2.top = new Struct2();
        int recSize2 = this.runEstimate(struct2, memModel, "recursive struct - no ring");
        Assert.assertEquals((long)(recSize1 * 3), (long)recSize2);
        struct2.next.prev = struct2;
        int recSize3 = this.runEstimate(struct2, memModel, "recursive struct - ring added");
        Assert.assertEquals((long)recSize2, (long)recSize3);
    }

    private int runEstimate(Object obj, JavaDataModel memModel, String desc) {
        HashMap map = IncrementalObjectSizeEstimator.createEstimators((Object)obj);
        IncrementalObjectSizeEstimator.ObjectEstimator root = (IncrementalObjectSizeEstimator.ObjectEstimator)map.get(obj.getClass());
        int estimate = root.estimate(obj, map);
        LOG.info("Estimated " + estimate + " for " + (desc == null ? obj.getClass().getName() : desc));
        return estimate;
    }

    private static class Struct {
        Integer i;
        int j = 0;
        LinkedHashSet<Object> list2;
        List<Object> list;

        private Struct() {
        }
    }

    private static class Struct2 {
        Struct2 next;
        Struct2 prev;
        Struct2 top;

        private Struct2() {
        }
    }

    private static class DummyMetadataReader
    implements LlapDataReader {
        public boolean doStreamStep = false;
        public boolean isEmpty;

        private DummyMetadataReader() {
        }

        public void open() throws IOException {
        }

        public OrcIndex readRowIndex(StripeInformation stripe, TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            if (this.isEmpty) {
                return new OrcIndex(new OrcProto.RowIndex[0], bloomFilterKinds, new OrcProto.BloomFilterIndex[0]);
            }
            OrcProto.ColumnStatistics cs = OrcProto.ColumnStatistics.newBuilder().setBucketStatistics(OrcProto.BucketStatistics.newBuilder().addCount(0L)).setStringStatistics(OrcProto.StringStatistics.newBuilder().setMaximum("zzz").setMinimum("aaa")).setBinaryStatistics(OrcProto.BinaryStatistics.newBuilder().setSum(5L)).setDateStatistics(OrcProto.DateStatistics.newBuilder().setMinimum(4545).setMaximum(6656)).setDecimalStatistics(OrcProto.DecimalStatistics.newBuilder().setMaximum("zzz").setMinimum("aaa")).setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(0.5).setMaximum(1.5)).setIntStatistics(OrcProto.IntegerStatistics.newBuilder().setMaximum(10L).setMinimum(5L)).setTimestampStatistics(OrcProto.TimestampStatistics.newBuilder().setMaximum(10L)).build();
            OrcProto.RowIndex ri = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(1L)).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(2L).setStatistics(cs)).build();
            OrcProto.RowIndex ri2 = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(3L)).build();
            OrcProto.BloomFilterIndex bfi = OrcProto.BloomFilterIndex.newBuilder().addBloomFilter(OrcProto.BloomFilter.newBuilder().addBitset(0L).addBitset(1L)).build();
            if (this.doStreamStep) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos);
                ri.writeTo(cos);
                cos.flush();
                ri = ((OrcProto.RowIndex.Builder)OrcProto.RowIndex.newBuilder().mergeFrom(baos.toByteArray())).build();
                baos = new ByteArrayOutputStream();
                cos = CodedOutputStream.newInstance((OutputStream)baos);
                ri2.writeTo(cos);
                cos.flush();
                ri2 = ((OrcProto.RowIndex.Builder)OrcProto.RowIndex.newBuilder().mergeFrom(baos.toByteArray())).build();
                baos = new ByteArrayOutputStream();
                cos = CodedOutputStream.newInstance((OutputStream)baos);
                bfi.writeTo(cos);
                cos.flush();
                bfi = ((OrcProto.BloomFilterIndex.Builder)OrcProto.BloomFilterIndex.newBuilder().mergeFrom(baos.toByteArray())).build();
            }
            return new OrcIndex(new OrcProto.RowIndex[]{ri, ri2}, bloomFilterKinds, new OrcProto.BloomFilterIndex[]{bfi});
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            OrcProto.StripeFooter.Builder fb = OrcProto.StripeFooter.newBuilder();
            if (!this.isEmpty) {
                fb.addStreams(OrcProto.Stream.newBuilder().setColumn(0).setLength(20L).setKind(OrcProto.Stream.Kind.LENGTH)).addStreams(OrcProto.Stream.newBuilder().setColumn(0).setLength(40L).setKind(OrcProto.Stream.Kind.DATA)).addColumns(OrcProto.ColumnEncoding.newBuilder().setDictionarySize(10).setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2));
            }
            OrcProto.StripeFooter footer = fb.build();
            if (this.doStreamStep) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos);
                footer.writeTo(cos);
                cos.flush();
                footer = ((OrcProto.StripeFooter.Builder)OrcProto.StripeFooter.newBuilder().mergeFrom(baos.toByteArray())).build();
            }
            return footer;
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            return null;
        }

        public boolean isTrackingDiskRanges() {
            return false;
        }

        public void releaseBuffer(ByteBuffer toRelease) {
        }

        public LlapDataReader clone() {
            return null;
        }

        public void close() throws IOException {
        }

        public boolean isOpen() {
            return false;
        }

        public CompressionCodec getCompressionCodec() {
            return null;
        }
    }
}

