/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.LinkedHashMap;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.llap.cache.CacheContentsTracker;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCacheContentsTracker {
    private static CacheContentsTracker tracker;
    private static final String EXPECTED_CACHE_STATE_WHEN_FULL = "\nCache state: \ndefault : 2/2, 2101248/2101248\ndefault.testtable : 2/2, 2101248/2101248\notherdb : 7/7, 1611106304/1611106304\notherdb.testtable : 4/4, 231424/231424\notherdb.testtable/p=v1 : 3/3, 100352/100352\notherdb.testtable/p=v1/pp=vv1 : 2/2, 34816/34816\notherdb.testtable/p=v1/pp=vv2 : 1/1, 65536/65536\notherdb.testtable/p=v2 : 1/1, 131072/131072\notherdb.testtable/p=v2/pp=vv1 : 1/1, 131072/131072\notherdb.testtable2 : 2/2, 537133056/537133056\notherdb.testtable2/p=v3 : 2/2, 537133056/537133056\notherdb.testtable3 : 1/1, 1073741824/1073741824";
    private static final String EXPECTED_CACHE_STATE_AFTER_EVICTION = "\nCache state: \ndefault : 0/2, 0/2101248\ndefault.testtable : 0/2, 0/2101248\notherdb : 5/7, 1074202624/1611106304\notherdb.testtable : 3/4, 198656/231424\notherdb.testtable/p=v1 : 2/3, 67584/100352\notherdb.testtable/p=v1/pp=vv1 : 1/2, 2048/34816\notherdb.testtable/p=v1/pp=vv2 : 1/1, 65536/65536\notherdb.testtable/p=v2 : 1/1, 131072/131072\notherdb.testtable/p=v2/pp=vv1 : 1/1, 131072/131072\notherdb.testtable2 : 1/2, 262144/537133056\notherdb.testtable2/p=v3 : 1/2, 262144/537133056\notherdb.testtable3 : 1/1, 1073741824/1073741824";

    @BeforeClass
    public static void setup() {
        LowLevelCachePolicy lowLevelCachePolicyMock = (LowLevelCachePolicy)Mockito.mock(LowLevelCachePolicy.class);
        EvictionListener evictionListenerMock = (EvictionListener)Mockito.mock(EvictionListener.class);
        tracker = new CacheContentsTracker(lowLevelCachePolicyMock);
        tracker.setEvictionListener(evictionListenerMock);
    }

    @Test
    public void testParentCacheTagGeneration() {
        CacheTag db = TestCacheContentsTracker.cacheTagBuilder("dbname", new String[0]);
        CacheTag table = TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", new String[0]);
        CacheTag p = TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p=v1");
        CacheTag pp = TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p=v1", "pp=vv1");
        CacheTag ppp = TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p=v1", "pp=vv1", "ppp=vvv1");
        Assert.assertTrue((pp.compareTo(CacheTag.createParentCacheTag((CacheTag)ppp)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((p.compareTo(CacheTag.createParentCacheTag((CacheTag)pp)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((table.compareTo(CacheTag.createParentCacheTag((CacheTag)p)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((db.compareTo(CacheTag.createParentCacheTag((CacheTag)table)) == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)CacheTag.createParentCacheTag((CacheTag)db));
    }

    @Test
    public void testAggregatedStatsGeneration() {
        TestCacheContentsTracker.cacheTestBuffers();
        StringBuilder sb = new StringBuilder();
        tracker.debugDumpShort(sb);
        Assert.assertEquals((Object)EXPECTED_CACHE_STATE_WHEN_FULL, (Object)sb.toString());
        TestCacheContentsTracker.evictSomeTestBuffers();
        sb = new StringBuilder();
        tracker.debugDumpShort(sb);
        Assert.assertEquals((Object)EXPECTED_CACHE_STATE_AFTER_EVICTION, (Object)sb.toString());
    }

    @Test
    public void testCacheTagComparison() {
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", new String[0]), null);
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"), null);
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2"), null);
        TestCacheContentsTracker.compareViceVersa(0, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", new String[0]), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", new String[0]));
        TestCacheContentsTracker.compareViceVersa(0, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"));
        TestCacheContentsTracker.compareViceVersa(0, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2"));
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2", "p3=v3"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2"));
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"));
        TestCacheContentsTracker.compareViceVersa(1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", new String[0]));
        TestCacheContentsTracker.compareViceVersa(-1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablenamf", "p1=v0"));
        TestCacheContentsTracker.compareViceVersa(-1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v3"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablenamf", "p1=v1", "p2=v2"));
        TestCacheContentsTracker.compareViceVersa(-25, TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2a"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablename", "p1=v1", "p2=v2z"));
        TestCacheContentsTracker.compareViceVersa(-1, TestCacheContentsTracker.cacheTagBuilder("dbname.tablenameAA", "p1=v1", "p2=v2"), TestCacheContentsTracker.cacheTagBuilder("dbname.tablenameBB", "p1=v1", "p2=v2"));
    }

    @Test
    public void testEncodingDecoding() throws Exception {
        LinkedHashMap<String, String> partDescs = new LinkedHashMap<String, String>();
        partDescs.put("pytha=goras", "a2+b2=c2");
        CacheTag tag = CacheTag.build((String)"math.rules", partDescs);
        CacheTag.SinglePartitionCacheTag stag = (CacheTag.SinglePartitionCacheTag)tag;
        Assert.assertEquals((Object)"pytha=goras=a2+b2=c2", (Object)stag.partitionDescToString());
        Assert.assertEquals((long)1L, (long)stag.getPartitionDescMap().size());
        Assert.assertEquals((Object)"a2+b2=c2", stag.getPartitionDescMap().get("pytha=goras"));
        partDescs.clear();
        partDescs.put("mutli=one", "one=/1");
        partDescs.put("mutli=two/", "two=2");
        tag = CacheTag.build((String)"math.rules", partDescs);
        CacheTag.MultiPartitionCacheTag mtag = (CacheTag.MultiPartitionCacheTag)tag;
        Assert.assertEquals((Object)"mutli=one=one=/1/mutli=two/=two=2", (Object)mtag.partitionDescToString());
        Assert.assertEquals((long)2L, (long)mtag.getPartitionDescMap().size());
        Assert.assertEquals((Object)"one=/1", mtag.getPartitionDescMap().get("mutli=one"));
        Assert.assertEquals((Object)"two=2", mtag.getPartitionDescMap().get("mutli=two/"));
    }

    private static void compareViceVersa(int expected, CacheTag a, CacheTag b) {
        if (a != null) {
            Assert.assertEquals((long)expected, (long)a.compareTo(b));
        }
        if (b != null) {
            Assert.assertEquals((long)(-1 * expected), (long)b.compareTo(a));
        }
    }

    private static LlapCacheableBuffer createMockBuffer(long size, CacheTag cacheTag) {
        LlapCacheableBuffer llapCacheableBufferMock = (LlapCacheableBuffer)Mockito.mock(LlapCacheableBuffer.class);
        ((LlapCacheableBuffer)Mockito.doAnswer(invocationOnMock -> size).when((Object)llapCacheableBufferMock)).getMemoryUsage();
        ((LlapCacheableBuffer)Mockito.doAnswer(invocationOnMock -> cacheTag).when((Object)llapCacheableBufferMock)).getTag();
        return llapCacheableBufferMock;
    }

    public static CacheTag cacheTagBuilder(String dbAndTable, String ... partitions) {
        if (partitions != null && partitions.length > 0) {
            LinkedHashMap<String, String> partDescs = new LinkedHashMap<String, String>();
            for (String partition : partitions) {
                String[] partDesc = partition.split("=");
                partDescs.put(partDesc[0], partDesc[1]);
            }
            return CacheTag.build((String)dbAndTable, partDescs);
        }
        return CacheTag.build((String)dbAndTable);
    }

    private static void cacheTestBuffers() {
        tracker.cache(TestCacheContentsTracker.createMockBuffer(4096L, TestCacheContentsTracker.cacheTagBuilder("default.testtable", new String[0])), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(2048L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable", "p=v1", "pp=vv1")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(32768L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable", "p=v1", "pp=vv1")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(65536L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable", "p=v1", "pp=vv2")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(131072L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable", "p=v2", "pp=vv1")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(262144L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable2", "p=v3")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(0x20000000L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable2", "p=v3")), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(0x40000000L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable3", new String[0])), null);
        tracker.cache(TestCacheContentsTracker.createMockBuffer(0x200000L, TestCacheContentsTracker.cacheTagBuilder("default.testtable", new String[0])), null);
    }

    private static void evictSomeTestBuffers() {
        tracker.notifyEvicted(TestCacheContentsTracker.createMockBuffer(32768L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable", "p=v1", "pp=vv1")));
        tracker.notifyEvicted(TestCacheContentsTracker.createMockBuffer(0x20000000L, TestCacheContentsTracker.cacheTagBuilder("otherdb.testtable2", "p=v3")));
        tracker.notifyEvicted(TestCacheContentsTracker.createMockBuffer(0x200000L, TestCacheContentsTracker.cacheTagBuilder("default.testtable", new String[0])));
        tracker.notifyEvicted(TestCacheContentsTracker.createMockBuffer(4096L, TestCacheContentsTracker.cacheTagBuilder("default.testtable", new String[0])));
    }
}

