/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.io.Files;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BasicLlapCacheHydration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestBasicLlapCacheHydration {
    private LlapIo mockIo;
    private BasicLlapCacheHydration hydr;

    @Before
    public void setUp() throws IOException {
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        Configuration conf = new Configuration();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_HYDRATION_SAVE_DIR, (String)tempDir.getAbsolutePath());
        this.hydr = new BasicLlapCacheHydration();
        this.hydr.setConf(conf);
        this.hydr.llapIo = this.mockIo = (LlapIo)Mockito.mock(LlapIo.class);
        this.hydr.initSavePath();
    }

    @Test
    public void testSaveAndLoad() throws IOException {
        LlapDaemonProtocolProtos.CacheEntryList entryList = this.createTestData();
        Mockito.when((Object)this.mockIo.fetchCachedContentInfo()).thenReturn((Object)entryList);
        ArgumentCaptor captor = ArgumentCaptor.forClass(LlapDaemonProtocolProtos.CacheEntryList.class);
        this.hydr.save();
        this.hydr.load();
        ((LlapIo)Mockito.verify((Object)this.mockIo)).loadDataIntoCache((LlapDaemonProtocolProtos.CacheEntryList)captor.capture());
        LlapDaemonProtocolProtos.CacheEntryList res = (LlapDaemonProtocolProtos.CacheEntryList)captor.getValue();
        Assert.assertEquals((Object)entryList, (Object)res);
    }

    private LlapDaemonProtocolProtos.CacheEntryList createTestData() throws IOException {
        LlapDaemonProtocolProtos.CacheEntryRange re1 = LlapDaemonProtocolProtos.CacheEntryRange.newBuilder().setStart(1L).setEnd(10L).build();
        LlapDaemonProtocolProtos.CacheEntryRange re2 = LlapDaemonProtocolProtos.CacheEntryRange.newBuilder().setStart(11L).setEnd(20L).build();
        LlapDaemonProtocolProtos.CacheTag ct = LlapDaemonProtocolProtos.CacheTag.newBuilder().setTableName("dummyTable").build();
        LlapDaemonProtocolProtos.CacheEntry ce = LlapDaemonProtocolProtos.CacheEntry.newBuilder().setCacheTag(ct).setFilePath("dummyPath").setFileKey(ByteString.copyFromUtf8((String)"dummyKey")).addRanges(re2).addRanges(re1).build();
        LlapDaemonProtocolProtos.CacheEntryList cel = LlapDaemonProtocolProtos.CacheEntryList.newBuilder().addEntries(ce).build();
        return cel;
    }
}

