/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.base.Function;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.CacheTag;

class FileCache<T> {
    private static final int EVICTED_REFCOUNT = -1;
    private static final int EVICTING_REFCOUNT = -2;
    private final T cache;
    private final Object fileKey;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final CacheTag tag;

    private FileCache(T value, Object fileKey, CacheTag tag) {
        this.cache = value;
        this.fileKey = fileKey;
        this.tag = tag;
    }

    public T getCache() {
        return this.cache;
    }

    public CacheTag getTag() {
        return this.tag;
    }

    boolean incRef() {
        while (true) {
            int value;
            if ((value = this.refCount.get()) == -1) {
                return false;
            }
            if (value == -2) continue;
            assert (value >= 0);
            if (this.refCount.compareAndSet(value, value + 1)) break;
        }
        return true;
    }

    void decRef() {
        int value = this.refCount.decrementAndGet();
        if (value < 0) {
            throw new AssertionError((Object)("Unexpected refCount " + value));
        }
    }

    boolean startEvicting() {
        int value;
        do {
            if ((value = this.refCount.get()) == 1) continue;
            return false;
        } while (!this.refCount.compareAndSet(value, -2));
        return true;
    }

    void commitEvicting() {
        boolean result = this.refCount.compareAndSet(-2, -1);
        assert (result);
    }

    void abortEvicting() {
        boolean result = this.refCount.compareAndSet(-2, 0);
        assert (result);
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public static <T> FileCache<T> getOrAddFileSubCache(ConcurrentHashMap<Object, FileCache<T>> cache, Object fileKey, Function<Void, T> createFunc, CacheTag tag) {
        FileCache<Object> newSubCache = null;
        while (true) {
            FileCache oldSubCache;
            FileCache<T> subCache;
            if ((subCache = cache.get(fileKey)) != null) {
                if (subCache.incRef()) {
                    return subCache;
                }
                if (newSubCache == null) {
                    newSubCache = new FileCache<Object>(createFunc.apply(null), fileKey, tag);
                    newSubCache.incRef();
                }
                if (!cache.replace(fileKey, subCache, newSubCache)) continue;
                return newSubCache;
            }
            if (newSubCache == null) {
                newSubCache = new FileCache<Object>(createFunc.apply(null), fileKey, tag);
                newSubCache.incRef();
            }
            if ((oldSubCache = (FileCache)cache.putIfAbsent(fileKey, newSubCache)) == null) {
                return newSubCache;
            }
            if (oldSubCache.incRef()) {
                return oldSubCache;
            }
            if (cache.replace(fileKey, oldSubCache, newSubCache)) break;
        }
        return newSubCache;
    }
}

