/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.probe;

import java.io.IOException;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeHashTable;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.io.filter.MutableFilterContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;

public class OrcProbeStringHashMultiSet
extends OrcProbeHashTable {
    private VectorMapJoinBytesHashMultiSet probeStringHashMultiSet;
    private VectorMapJoinHashMultiSetResult hashSetResult;

    public OrcProbeStringHashMultiSet(VectorMapJoinHashTable vTable, VectorMapJoinInfo vInfo) {
        super(vTable, vInfo);
        this.probeStringHashMultiSet = (VectorMapJoinBytesHashMultiSet)this.probeDecodeMapJoinTable;
        this.hashSetResult = this.probeStringHashMultiSet.createHashMultiSetResult();
    }

    @Override
    public void init() throws HiveException {
    }

    @Override
    public void filterColumnVector(ColumnVector cv, MutableFilterContext cntx, int batchSize) {
        int[] selected = cntx.updateSelected(batchSize);
        int newSize = 0;
        boolean selectedInUse = false;
        BytesColumnVector probeCol = (BytesColumnVector)cv;
        byte[][] vector = probeCol.vector;
        int[] start = probeCol.start;
        int[] length = probeCol.length;
        try {
            if (probeCol.isRepeating) {
                boolean isNull;
                boolean bl = isNull = !probeCol.noNulls && probeCol.isNull[0];
                if (isNull) {
                    selectedInUse = true;
                } else if (this.probeStringHashMultiSet.contains(vector[0], start[0], length[0], this.hashSetResult) == JoinUtil.JoinResult.MATCH) {
                    newSize = batchSize;
                } else {
                    selectedInUse = true;
                }
            } else {
                boolean haveSaveKey = false;
                boolean saveKeyMatch = false;
                int saveKeyIndex = -1;
                for (int row = 0; row < batchSize; ++row) {
                    if (!probeCol.noNulls && probeCol.isNull[row]) continue;
                    if (!haveSaveKey || !StringExpr.equal((byte[])vector[saveKeyIndex], (int)start[saveKeyIndex], (int)length[saveKeyIndex], (byte[])vector[row], (int)start[row], (int)length[row])) {
                        haveSaveKey = true;
                        saveKeyIndex = row;
                        boolean bl = saveKeyMatch = this.probeStringHashMultiSet.contains(vector[row], start[row], length[row], this.hashSetResult) == JoinUtil.JoinResult.MATCH;
                    }
                    if (!saveKeyMatch) continue;
                    selected[newSize++] = row;
                }
                selectedInUse = newSize != batchSize;
            }
            cntx.setFilterContext(selectedInUse, selected, newSize);
            LlapIoImpl.LOG.debug("ProbeDecode StrMultiSet Matched: {} selectedInUse {} batchSize {}", new Object[]{newSize, selectedInUse, batchSize});
        }
        catch (IOException e) {
            LlapIoImpl.LOG.error("ProbeDecode StrMultiKey Filter failed: {}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

