/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.probe;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeHashTable;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.io.filter.MutableFilterContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;

public class OrcProbeMultiKeyHashMap
extends OrcProbeHashTable {
    private VectorMapJoinBytesHashMap probeHashMultiMap;
    private VectorMapJoinHashMapResult hashMultiMapResult;
    private SerializeWrite multiKeySerializeWrite;
    private VectorSerializeRow multiKeyVectorSerializeRow;
    private ByteStream.Output currKeyOutput;
    private ByteStream.Output saveKeyOutput;

    public OrcProbeMultiKeyHashMap(VectorMapJoinHashTable vTable, VectorMapJoinInfo vInfo, Properties keyTableProperties) throws HiveException {
        super(vTable, vInfo);
        this.probeHashMultiMap = (VectorMapJoinBytesHashMap)this.probeDecodeMapJoinTable;
        this.hashMultiMapResult = this.probeHashMultiMap.createHashMapResult();
        this.multiKeySerializeWrite = BinarySortableSerializeWrite.with((Properties)keyTableProperties, (int)vInfo.getBigTableKeyColumnMap().length);
        this.multiKeyVectorSerializeRow = new VectorSerializeRow(this.multiKeySerializeWrite);
        this.currKeyOutput = new ByteStream.Output();
        this.saveKeyOutput = new ByteStream.Output();
    }

    @Override
    public void init() throws HiveException {
        this.multiKeyVectorSerializeRow.init(this.probeDecodeMapJoinInfo.getBigTableKeyTypeInfos(), this.probeDecodeMapJoinInfo.getBigTableKeyColumnMap());
    }

    @Override
    public void filterColumnVector(ColumnVector cv, MutableFilterContext cntx, int batchSize) {
        int[] selected = cntx.updateSelected(batchSize);
        int newSize = 0;
        boolean selectedInUse = false;
        ColumnVector probeCol = cv;
        try {
            if (probeCol.isRepeating) {
                if (!probeCol.noNulls && probeCol.isNull[0]) {
                    selectedInUse = true;
                } else {
                    this.multiKeyVectorSerializeRow.setOutput(this.currKeyOutput);
                    this.multiKeySerializeWrite.reset();
                    this.multiKeyVectorSerializeRow.serializeWrite(probeCol, this.multiKeyVectorSerializeRow.getFields()[0], 0);
                    if (this.probeHashMultiMap.lookup(this.currKeyOutput.getData(), 0, this.currKeyOutput.getLength(), this.hashMultiMapResult) == JoinUtil.JoinResult.MATCH) {
                        newSize = batchSize;
                    } else {
                        selectedInUse = true;
                    }
                }
            } else {
                boolean haveSaveKey = false;
                boolean saveKeyMatch = false;
                for (int row = 0; row < batchSize; ++row) {
                    if (!probeCol.noNulls && probeCol.isNull[row]) continue;
                    this.multiKeyVectorSerializeRow.setOutput(this.currKeyOutput);
                    this.multiKeySerializeWrite.reset();
                    this.multiKeyVectorSerializeRow.serializeWrite(probeCol, this.multiKeyVectorSerializeRow.getFields()[0], row);
                    if (!haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currKeyOutput)) {
                        ByteStream.Output temp = this.saveKeyOutput;
                        this.saveKeyOutput = this.currKeyOutput;
                        this.currKeyOutput = temp;
                        haveSaveKey = true;
                        boolean bl = saveKeyMatch = this.probeHashMultiMap.lookup(this.saveKeyOutput.getData(), 0, this.saveKeyOutput.getLength(), this.hashMultiMapResult) == JoinUtil.JoinResult.MATCH;
                    }
                    if (!saveKeyMatch) continue;
                    selected[newSize++] = row;
                }
                selectedInUse = newSize != batchSize;
            }
            cntx.setFilterContext(selectedInUse, selected, newSize);
            LlapIoImpl.LOG.debug("ProbeDecode MultiKeyMap Matched: {} selectedInUse {} batchSize {}", new Object[]{newSize, selectedInUse, batchSize});
        }
        catch (IOException e) {
            LlapIoImpl.LOG.error("ProbeDecode MultiKeyMap Filter failed: {}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

