/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.probe;

import java.io.IOException;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeHashTable;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.io.filter.MutableFilterContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;

public class OrcProbeLongHashMap
extends OrcProbeHashTable {
    private VectorMapJoinLongHashMap probeLongHashMap = (VectorMapJoinLongHashMap)this.probeDecodeMapJoinTable;
    private VectorMapJoinHashMapResult hashMapResult = this.probeLongHashMap.createHashMapResult();
    private boolean useMinMax = this.probeLongHashMap.useMinMax();
    private long min = 0L;
    private long max = 0L;

    public OrcProbeLongHashMap(VectorMapJoinHashTable vTable, VectorMapJoinInfo vInfo) {
        super(vTable, vInfo);
        if (this.useMinMax) {
            this.min = this.probeLongHashMap.min();
            this.max = this.probeLongHashMap.max();
        }
    }

    @Override
    public void init() throws HiveException {
    }

    @Override
    public void filterColumnVector(ColumnVector cv, MutableFilterContext cntx, int batchSize) {
        int[] selected = cntx.updateSelected(batchSize);
        int newSize = 0;
        boolean selectedInUse = false;
        LongColumnVector probeCol = (LongColumnVector)cv;
        try {
            if (probeCol.isRepeating) {
                boolean isNull;
                boolean bl = isNull = !probeCol.noNulls && probeCol.isNull[0];
                if (isNull || this.useMinMax && (probeCol.vector[0] < this.min || probeCol.vector[0] > this.max)) {
                    selectedInUse = true;
                } else if (this.probeLongHashMap.lookup(probeCol.vector[0], this.hashMapResult) == JoinUtil.JoinResult.MATCH) {
                    newSize = batchSize;
                } else {
                    selectedInUse = true;
                }
            } else {
                boolean haveSaveKey = false;
                boolean saveKeyMatch = false;
                long saveKey = 0L;
                for (int row = 0; row < batchSize; ++row) {
                    if (!probeCol.noNulls && probeCol.isNull[row]) continue;
                    long currentKey = probeCol.vector[row];
                    if (!haveSaveKey || currentKey != saveKey) {
                        haveSaveKey = true;
                        saveKey = currentKey;
                        if (this.useMinMax && (currentKey < this.min || currentKey > this.max)) {
                            saveKeyMatch = false;
                        } else {
                            boolean bl = saveKeyMatch = this.probeLongHashMap.lookup(currentKey, this.hashMapResult) == JoinUtil.JoinResult.MATCH;
                        }
                    }
                    if (!saveKeyMatch) continue;
                    selected[newSize++] = row;
                }
                selectedInUse = newSize != batchSize;
            }
            cntx.setFilterContext(selectedInUse, selected, newSize);
            LlapIoImpl.LOG.debug("ProbeDecode LongMap Matched: {} selectedInUse {} batchSize {}", new Object[]{newSize, selectedInUse, batchSize});
        }
        catch (IOException e) {
            LlapIoImpl.LOG.error("ProbeDecode LongMap Filter failed: {}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

