/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.probe;

import org.apache.hadoop.hive.llap.io.probe.OrcProbeLongHashMap;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeLongHashMultiSet;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeLongHashSet;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeMultiKeyHashMap;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeMultiKeyHashMultiSet;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeMultiKeyHashSet;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeStringHashMap;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeStringHashMultiSet;
import org.apache.hadoop.hive.llap.io.probe.OrcProbeStringHashSet;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.io.filter.MutableFilterContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrcProbeHashTable {
    protected static final Logger LOG = LoggerFactory.getLogger((String)OrcProbeHashTable.class.getName());
    protected VectorMapJoinHashTable probeDecodeMapJoinTable;
    protected VectorMapJoinInfo probeDecodeMapJoinInfo;

    protected OrcProbeHashTable(VectorMapJoinHashTable vTable, VectorMapJoinInfo vInfo) {
        this.probeDecodeMapJoinTable = vTable;
        this.probeDecodeMapJoinInfo = vInfo;
    }

    public abstract void init() throws HiveException;

    public abstract void filterColumnVector(ColumnVector var1, MutableFilterContext var2, int var3);

    public static OrcProbeHashTable getOrcProbeHashTable(VectorMapJoinTableContainer vc) throws HiveException {
        OrcProbeHashTable currProbeHashTable = null;
        if (vc.mapJoinDesc().getHashTableKeyType() == VectorMapJoinDesc.HashTableKeyType.MULTI_KEY) {
            switch (vc.mapJoinDesc().getHashTableKind()) {
                case HASH_MAP: {
                    currProbeHashTable = new OrcProbeMultiKeyHashMap(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo(), vc.keyTableProperties());
                    break;
                }
                case HASH_MULTISET: {
                    currProbeHashTable = new OrcProbeMultiKeyHashMultiSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo(), vc.keyTableProperties());
                    break;
                }
                case HASH_SET: {
                    currProbeHashTable = new OrcProbeMultiKeyHashSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo(), vc.keyTableProperties());
                }
            }
        } else if (vc.mapJoinDesc().getHashTableKeyType() == VectorMapJoinDesc.HashTableKeyType.STRING) {
            switch (vc.mapJoinDesc().getHashTableKind()) {
                case HASH_MAP: {
                    currProbeHashTable = new OrcProbeStringHashMap(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                    break;
                }
                case HASH_MULTISET: {
                    currProbeHashTable = new OrcProbeStringHashMultiSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                    break;
                }
                case HASH_SET: {
                    currProbeHashTable = new OrcProbeStringHashSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                }
            }
        } else {
            switch (vc.mapJoinDesc().getHashTableKind()) {
                case HASH_MAP: {
                    currProbeHashTable = new OrcProbeLongHashMap(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                    break;
                }
                case HASH_MULTISET: {
                    currProbeHashTable = new OrcProbeLongHashMultiSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                    break;
                }
                case HASH_SET: {
                    currProbeHashTable = new OrcProbeLongHashSet(vc.vectorMapJoinHashTable(), vc.mapJoinDesc().getVectorMapJoinInfo());
                }
            }
        }
        currProbeHashTable.init();
        return currProbeHashTable;
    }
}

