/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import org.apache.hadoop.hive.llap.io.encoded.SerDeEncodedDataReader;
import org.apache.hadoop.hive.ql.exec.FooterBuffer;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

class PassThruOffsetReader
implements SerDeEncodedDataReader.ReaderWithOffsets {
    protected final RecordReader sourceReader;
    protected final Object key;
    protected final Writable value;
    protected final JobConf jobConf;
    protected final int skipHeaderCnt;
    protected final int skipFooterCnt;
    private transient FooterBuffer footerBuffer;
    private transient boolean initialized = false;

    PassThruOffsetReader(RecordReader sourceReader, JobConf jobConf, int headerCnt, int footerCnt) {
        this.sourceReader = sourceReader;
        this.key = sourceReader.createKey();
        this.value = (Writable)sourceReader.createValue();
        this.jobConf = jobConf;
        this.skipHeaderCnt = headerCnt;
        this.skipFooterCnt = footerCnt;
    }

    @Override
    public boolean next() throws IOException {
        try {
            boolean opNotEOF = true;
            if (!this.initialized) {
                opNotEOF = Utilities.skipHeader((RecordReader)this.sourceReader, (int)this.skipHeaderCnt, (Object)((WritableComparable)this.key), (Object)this.value);
                if (opNotEOF && this.skipFooterCnt > 0) {
                    this.footerBuffer = new FooterBuffer();
                    opNotEOF = this.footerBuffer.initializeBuffer(this.jobConf, this.sourceReader, this.skipFooterCnt, (WritableComparable)this.key, this.value);
                }
                this.initialized = true;
            }
            if (opNotEOF && this.footerBuffer == null) {
                opNotEOF = this.sourceReader.next(this.key, (Object)this.value);
            }
            if (opNotEOF && this.footerBuffer != null) {
                opNotEOF = this.footerBuffer.updateBuffer(this.jobConf, this.sourceReader, (WritableComparable)this.key, this.value);
            }
            return opNotEOF;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Writable getCurrentRow() {
        return this.value;
    }

    @Override
    public void close() throws IOException {
        this.sourceReader.close();
    }

    @Override
    public long getCurrentRowStartOffset() {
        return -1L;
    }

    @Override
    public long getCurrentRowEndOffset() {
        return -1L;
    }

    @Override
    public boolean hasOffsets() {
        return false;
    }
}

