/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.IllegalCacheConfigurationException;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.encoded.LlapRecordReaderUtils;
import org.apache.hadoop.hive.llap.io.encoded.TezCounterSource;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.orc.encoded.LlapDataReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.BufferChunkList;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.ReaderImpl;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.RecordReaderUtils;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.WriterImpl;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcEncodedDataReader
extends CallableWithNdc<Void>
implements ConsumerFeedback<Reader.OrcEncodedColumnBatch>,
TezCounterSource {
    private static final Logger LOG = LoggerFactory.getLogger(OrcEncodedDataReader.class);
    public static final FixedSizedObjectPool<EncodedColumnBatch.ColumnStreamData> CSD_POOL = new FixedSizedObjectPool(8192, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

        public EncodedColumnBatch.ColumnStreamData create() {
            return new EncodedColumnBatch.ColumnStreamData();
        }

        public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
            t.reset();
        }
    });
    public static final FixedSizedObjectPool<Reader.OrcEncodedColumnBatch> ECB_POOL = new FixedSizedObjectPool(1024, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

        public Reader.OrcEncodedColumnBatch create() {
            return new Reader.OrcEncodedColumnBatch();
        }

        public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
            t.reset();
        }
    });
    private static final Reader.PoolFactory POOL_FACTORY = new Reader.PoolFactory(){

        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return CSD_POOL;
        }

        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return ECB_POOL;
        }
    };
    private final MetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final BufferUsageManager bufferManager;
    private final Configuration daemonConf;
    private final Configuration jobConf;
    private final FileSplit split;
    private final SearchArgument sarg;
    private final OrcEncodedDataConsumer consumer;
    private final QueryFragmentCounters counters;
    private final UserGroupInformation ugi;
    private final SchemaEvolution evolution;
    private final PathCache pathCache;
    private final boolean useCodecPool;
    private final boolean useObjectPools;
    private static final String STRIPE_STATS_STREAM = "stripe stats";
    private int stripeIxFrom;
    private OrcFileMetadata fileMetadata;
    private Path path;
    private Reader orcReader;
    private LlapDataReader rawDataReader;
    private boolean isRawDataReaderOpen = false;
    private EncodedReader stripeReader;
    private CompressionCodec codec;
    private Object fileKey;
    private final CacheTag cacheTag;
    private final Map<Path, PartitionDesc> parts;
    private final boolean isReadCacheOnly;
    private Supplier<FileSystem> fsSupplier;
    private boolean[][] stripeRgs;
    private AtomicBoolean isStopped = new AtomicBoolean(false);
    private volatile boolean isPaused = false;
    boolean[] sargColumns = null;
    boolean[] fileIncludes = null;
    private final IoTrace trace;
    private Pool<IoTrace> tracePool;

    public OrcEncodedDataReader(LowLevelCache lowLevelCache, BufferUsageManager bufferManager, MetadataCache metadataCache, Configuration daemonConf, Configuration jobConf, FileSplit split, ColumnVectorProducer.Includes includes, SearchArgument sarg, OrcEncodedDataConsumer consumer, QueryFragmentCounters counters, ColumnVectorProducer.SchemaEvolutionFactory sef, Pool<IoTrace> tracePool, Map<Path, PartitionDesc> parts, PathCache pathCache) throws IOException {
        this.lowLevelCache = lowLevelCache;
        this.metadataCache = metadataCache;
        this.bufferManager = bufferManager;
        this.daemonConf = daemonConf;
        this.split = split;
        this.sarg = sarg;
        this.consumer = consumer;
        this.counters = counters;
        this.trace = (IoTrace)tracePool.take();
        this.tracePool = tracePool;
        this.parts = parts;
        this.pathCache = pathCache;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.useCodecPool = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_CODEC_POOL);
        this.useObjectPools = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_SHARE_OBJECT_POOLS);
        this.orcReader = null;
        PartitionDesc partitionDesc = LlapHiveUtils.partitionDescForPath((Path)split.getPath(), parts);
        this.cacheTag = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE) ? LlapHiveUtils.getDbAndTableNameForMetrics((Path)split.getPath(), (boolean)true, (PartitionDesc)partitionDesc) : null;
        this.fsSupplier = OrcEncodedDataReader.getFsSupplier(split.getPath(), jobConf);
        this.fileKey = OrcEncodedDataReader.determineFileId(this.fsSupplier, split, daemonConf);
        this.fileMetadata = this.getFileFooterFromCacheOrDisk();
        TypeDescription fileSchema = this.fileMetadata.getSchema();
        boolean useZeroCopy = OrcConf.USE_ZEROCOPY.getBoolean(daemonConf);
        if (useZeroCopy != OrcConf.USE_ZEROCOPY.getBoolean(jobConf)) {
            jobConf = new Configuration(jobConf);
            jobConf.setBoolean(OrcConf.USE_ZEROCOPY.getAttribute(), useZeroCopy);
        }
        this.jobConf = jobConf;
        this.evolution = sef.createSchemaEvolution(this.fileMetadata.getSchema());
        this.fileIncludes = includes.generateFileIncludes(fileSchema);
        if (LOG.isDebugEnabled()) {
            LOG.debug("From {}, the file includes are {}", (Object)includes, (Object)DebugUtils.toString((boolean[])this.fileIncludes));
        }
        consumer.setUseDecimal64ColumnVectors(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64"));
        consumer.setFileMetadata(this.fileMetadata);
        consumer.setSchemaEvolution(this.evolution);
        this.isReadCacheOnly = HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_CACHE_ONLY);
    }

    @Override
    public void stop() {
        LOG.debug("Encoded reader is being stopped");
        this.isStopped.set(true);
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    @Override
    public void unpause() {
        this.isPaused = false;
    }

    protected Void callInternal() throws IOException, InterruptedException {
        return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                return OrcEncodedDataReader.this.performDataRead();
            }
        });
    }

    static Supplier<FileSystem> getFsSupplier(Path path, Configuration conf) {
        return () -> {
            try {
                return path.getFileSystem(conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected Void performDataRead() throws IOException, InterruptedException {
        long startTime = this.counters.startTimeCounter();
        LlapIoImpl.LOG.info("Processing data for file {}: {}", this.fileKey, (Object)this.split.getPath());
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.TABLE, this.cacheTag.getTableName());
        this.counters.setDesc(QueryFragmentCounters.Desc.FILE, this.split.getPath() + (this.fileKey == null ? "" : " (" + this.fileKey + ")"));
        try {
            this.validateFileMetadata();
            this.determineStripesToRead();
        }
        catch (Throwable t) {
            this.handleReaderError(startTime, t);
            return null;
        }
        if (this.stripeRgs.length == 0) {
            this.consumer.setDone();
            this.recordReaderTime(startTime);
            this.tracePool.offer((Object)this.trace);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.STRIPES, this.stripeIxFrom + "," + this.stripeRgs.length);
        int stride = this.fileMetadata.getRowIndexStride();
        ArrayList<OrcStripeMetadata> stripeMetadatas = null;
        try {
            boolean hasData;
            if (this.sarg != null && stride != 0) {
                int[] filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx((List)this.sarg.getLeaves(), (SchemaEvolution)this.evolution);
                this.sargColumns = new boolean[this.evolution.getFileSchema().getMaximumId() + 1];
                for (int i : filterColumns) {
                    if (i <= 0) continue;
                    this.sargColumns[i] = true;
                }
                stripeMetadatas = this.readStripesMetadata(this.fileIncludes, this.sargColumns);
            }
            if (!(hasData = this.determineRgsToRead(stride, stripeMetadatas))) {
                this.consumer.setDone();
                this.recordReaderTime(startTime);
                this.tracePool.offer((Object)this.trace);
                return null;
            }
        }
        catch (Throwable t) {
            this.handleReaderError(startTime, t);
            return null;
        }
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return null;
        }
        try {
            this.ensureDataReader();
        }
        catch (Throwable t) {
            this.handleReaderError(startTime, t);
            return null;
        }
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, -1, 0) : null;
        this.pathCache.touch(this.fileKey, this.split.getPath().toUri().toString());
        for (int stripeIxMod = 0; stripeIxMod < this.stripeRgs.length; ++stripeIxMod) {
            StripeInformation si;
            if (this.processStop()) {
                this.recordReaderTime(startTime);
                return null;
            }
            int stripeIx = this.stripeIxFrom + stripeIxMod;
            boolean[] rgs = null;
            OrcStripeMetadata stripeMetadata = null;
            try {
                si = this.fileMetadata.getStripes().get(stripeIx);
                LlapIoImpl.ORC_LOGGER.trace("Reading stripe {}: {}, {}", new Object[]{stripeIx, si.getOffset(), si.getLength()});
                this.trace.logReadingStripe(stripeIx, si.getOffset(), si.getLength());
                rgs = this.stripeRgs[stripeIxMod];
                if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.ORC_LOGGER.trace("stripeRgs[{}]: {}", (Object)stripeIxMod, (Object)Arrays.toString(rgs));
                }
                if (rgs == RecordReaderImpl.SargApplier.READ_NO_RGS) continue;
                if (stripeMetadatas != null) {
                    stripeMetadata = stripeMetadatas.get(stripeIxMod);
                } else {
                    stripeKey.stripeIx = stripeIx;
                    OrcProto.StripeFooter footer = this.getStripeFooterFromCacheOrDisk(si, stripeKey);
                    stripeMetadata = this.createOrcStripeMetadataObject(stripeIx, si, footer, this.fileIncludes, this.sargColumns);
                    this.ensureDataReader();
                    this.stripeReader.readIndexStreams(stripeMetadata.getIndex(), si, footer.getStreamsList(), this.fileIncludes, this.sargColumns);
                    this.consumer.setStripeMetadata(stripeMetadata);
                }
            }
            catch (Throwable t) {
                this.handleReaderError(startTime, t);
                return null;
            }
            if (this.processStop()) {
                this.recordReaderTime(startTime);
                return null;
            }
            try {
                this.stripeReader.readEncodedColumns(stripeIx, si, stripeMetadata.getRowIndexes(), stripeMetadata.getEncodings(), stripeMetadata.getStreams(), this.fileIncludes, rgs, (Consumer)this.consumer);
                continue;
            }
            catch (Throwable t) {
                this.handleReaderError(startTime, t);
                return null;
            }
        }
        this.recordReaderTime(startTime);
        this.consumer.setDone();
        LlapIoImpl.LOG.trace("done processing {}", (Object)this.split);
        this.tracePool.offer((Object)this.trace);
        this.cleanupReaders();
        return null;
    }

    private void handleReaderError(long startTime, Throwable t) throws InterruptedException {
        this.recordReaderTime(startTime);
        this.consumer.setError(t);
        this.trace.dumpLog(LOG);
        this.cleanupReaders();
        this.tracePool.offer((Object)this.trace);
    }

    private void ensureDataReader() throws IOException {
        this.ensureOrcReader();
        DataWrapperForOrc dw = new DataWrapperForOrc();
        this.stripeReader = this.orcReader.encodedReader(this.fileKey, (DataCache)dw, (LlapDataReader)dw, (Reader.PoolFactory)(this.useObjectPools ? POOL_FACTORY : null), this.trace, this.useCodecPool, this.cacheTag, this.isReadCacheOnly);
        this.stripeReader.setTracing(LlapIoImpl.ORC_LOGGER.isTraceEnabled());
        this.stripeReader.setStopped(this.isStopped);
    }

    private void recordReaderTime(long startTime) {
        this.counters.incrWallClockCounter(LlapIOCounters.TOTAL_IO_TIME_NS, startTime);
    }

    private void validateFileMetadata() throws IOException {
        long minAllocSize;
        if (this.fileMetadata.getCompressionKind() == CompressionKind.NONE) {
            return;
        }
        int bufferSize = this.fileMetadata.getCompressionBufferSize();
        if ((long)bufferSize < (minAllocSize = HiveConf.getSizeVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC))) {
            LOG.warn("ORC compression buffer size (" + bufferSize + ") is smaller than LLAP low-level cache minimum allocation size (" + minAllocSize + "). Decrease the value for " + HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC.toString() + " to avoid wasting memory");
        }
    }

    private boolean processStop() {
        if (!this.isStopped.get()) {
            return false;
        }
        LOG.info("Encoded data reader is stopping");
        this.tracePool.offer((Object)this.trace);
        this.cleanupReaders();
        return true;
    }

    static Object determineFileId(Supplier<FileSystem> fsSupplier, FileSplit split, Configuration daemonConf) throws IOException {
        Object fileKey;
        if (split instanceof OrcSplit && (fileKey = ((OrcSplit)split).getFileKey()) != null) {
            return fileKey;
        }
        LOG.warn("Split for " + split.getPath() + " (" + split.getClass() + ") does not have file ID");
        return LlapHiveUtils.createFileIdUsingFS((FileSystem)fsSupplier.get(), (Path)split.getPath(), (Configuration)daemonConf);
    }

    private void cleanupReaders() {
        if (this.stripeReader != null) {
            try {
                this.stripeReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.rawDataReader != null && this.isRawDataReaderOpen) {
            try {
                this.rawDataReader.close();
                this.rawDataReader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureOrcReader() throws IOException {
        OrcTail orcTail;
        if (this.orcReader != null) {
            return;
        }
        this.path = this.split.getPath();
        if (this.fileKey instanceof Long && HiveConf.getBoolVar((Configuration)this.daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH)) {
            this.path = HdfsUtils.getFileIdPath((Path)this.path, (long)((Long)this.fileKey));
        }
        LlapIoImpl.ORC_LOGGER.trace("Creating reader for {} ({})", (Object)this.path, (Object)this.split.getPath());
        long startTime = this.counters.startTimeCounter();
        OrcFile.ReaderOptions opts = EncodedOrcFile.readerOptions((Configuration)this.jobConf).filesystem(this.fsSupplier).fileMetadata((FileMetadata)this.fileMetadata);
        if (this.split instanceof OrcSplit && (orcTail = ((OrcSplit)this.split).getOrcTail()) != null) {
            LlapIoImpl.ORC_LOGGER.debug("Setting OrcTail. path={}", (Object)this.path);
            opts.orcTail(orcTail);
        }
        this.orcReader = EncodedOrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)opts);
        this.counters.incrWallClockCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    private void ensureCodecFromFileMetadata() {
        if (this.codec != null) {
            return;
        }
        this.codec = WriterImpl.createCodec((CompressionKind)this.fileMetadata.getCompressionKind());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrcTail getOrcTailForPath(Path path, Configuration jobConf, CacheTag tag, Configuration daemonConf, MetadataCache metadataCache, Object fileKey) throws IOException {
        Supplier<FileSystem> fsSupplier = OrcEncodedDataReader.getFsSupplier(path, jobConf);
        if (fileKey == null) {
            fileKey = LlapHiveUtils.createFileIdUsingFS((FileSystem)fsSupplier.get(), (Path)path, (Configuration)daemonConf);
        }
        if (fileKey == null || metadataCache == null) {
            throw new IllegalCacheConfigurationException("LLAP metadata cache not available for path " + path.toString());
        }
        MetadataCache.LlapBufferOrBuffers tailBuffers = metadataCache.getFileMetadata(fileKey);
        try {
            if (tailBuffers != null) {
                OrcTail orcTail = OrcEncodedDataReader.getOrcTailFromLlapBuffers(tailBuffers);
                return orcTail;
            }
            LlapHiveUtils.throwIfCacheOnlyRead((boolean)HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_CACHE_ONLY));
            EncodedOrcFile.EncodedReaderOptions opts = EncodedOrcFile.readerOptions((Configuration)jobConf).filesystem(fsSupplier);
            Reader reader = EncodedOrcFile.createReader((Path)path, (OrcFile.ReaderOptions)opts);
            ByteBuffer tailBufferBb = reader.getSerializedFileFooter();
            tailBuffers = metadataCache.putFileMetadata(fileKey, tailBufferBb, tag, new AtomicBoolean(false));
            OrcTail orcTail = OrcEncodedDataReader.getOrcTailFromLlapBuffers(tailBuffers);
            return orcTail;
        }
        finally {
            if (tailBuffers != null) {
                metadataCache.decRefBuffer(tailBuffers);
            }
        }
    }

    private static List<OrcProto.StripeStatistics> getStripeStatsFromOrcTail(OrcTail orcTail) throws IOException {
        CompressionKind compressionKind = orcTail.getCompressionKind();
        InStream.StreamOptions options = null;
        if (compressionKind != CompressionKind.NONE) {
            options = InStream.options().withCodec(OrcCodecPool.getCodec((CompressionKind)compressionKind)).withBufferSize(orcTail.getCompressionBufferSize());
        }
        InStream stream = InStream.create((Object)STRIPE_STATS_STREAM, (DiskRangeList)orcTail.getTailBuffer(), (long)orcTail.getMetadataOffset(), (long)orcTail.getMetadataSize(), (InStream.StreamOptions)options);
        return OrcProto.Metadata.parseFrom((CodedInputStream)InStream.createCodedInputStream((InStream)stream)).getStripeStatsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrcFileMetadata getFileFooterFromCacheOrDisk() throws IOException {
        boolean hasCache;
        MetadataCache.LlapBufferOrBuffers tailBuffers = null;
        List<OrcProto.StripeStatistics> stats = null;
        ArrayList<StripeInformation> stripes = null;
        boolean bl = hasCache = this.fileKey != null && this.metadataCache != null;
        if (hasCache) {
            tailBuffers = this.metadataCache.getFileMetadata(this.fileKey);
            if (tailBuffers != null) {
                try {
                    OrcTail orcTail = OrcEncodedDataReader.getOrcTailFromLlapBuffers(tailBuffers);
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                    OrcProto.FileTail tail = orcTail.getFileTail();
                    stats = OrcEncodedDataReader.getStripeStatsFromOrcTail(orcTail);
                    stripes = new ArrayList<StripeInformation>(tail.getFooter().getStripesCount());
                    int stripeIdx = 0;
                    for (OrcProto.StripeInformation stripeProto : tail.getFooter().getStripesList()) {
                        stripes.add((StripeInformation)new ReaderImpl.StripeInformationImpl(stripeProto, (long)stripeIdx++, -1L, (byte[][])null));
                    }
                    OrcFileMetadata orcFileMetadata = new OrcFileMetadata(this.fileKey, tail.getFooter(), tail.getPostscript(), stats, stripes, ReaderImpl.getFileVersion((List)tail.getPostscript().getVersionList()));
                    return orcFileMetadata;
                }
                finally {
                    this.metadataCache.decRefBuffer(tailBuffers);
                }
            }
            this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
            LlapHiveUtils.throwIfCacheOnlyRead((boolean)this.isReadCacheOnly);
        }
        this.ensureOrcReader();
        ByteBuffer tailBufferBb = this.orcReader.getSerializedFileFooter();
        if (hasCache) {
            tailBuffers = this.metadataCache.putFileMetadata(this.fileKey, tailBufferBb, this.cacheTag, this.isStopped);
            this.metadataCache.decRefBuffer(tailBuffers);
        }
        OrcProto.FileTail ft = this.orcReader.getFileTail();
        return new OrcFileMetadata(this.fileKey, ft.getFooter(), ft.getPostscript(), this.orcReader.getOrcProtoStripeStatistics(), this.orcReader.getStripes(), this.orcReader.getFileVersion());
    }

    private static OrcTail getOrcTailFromLlapBuffers(MetadataCache.LlapBufferOrBuffers tailBuffers) throws IOException {
        MemoryBuffer tailBuffer = tailBuffers.getSingleBuffer();
        ByteBuffer bb = null;
        if (tailBuffer != null) {
            bb = tailBuffer.getByteBufferDup();
            ByteBuffer dupBb = tailBuffer.getByteBufferDup();
            bb = ByteBuffer.allocate(dupBb.remaining());
            bb.put(dupBb);
            bb.flip();
        } else {
            MemoryBuffer[] tailBufferArray = tailBuffers.getMultipleBuffers();
            int totalSize = 0;
            for (MemoryBuffer buf : tailBufferArray) {
                totalSize += buf.getByteBufferRaw().remaining();
            }
            bb = ByteBuffer.allocate(totalSize);
            for (MemoryBuffer buf : tailBufferArray) {
                bb.put(buf.getByteBufferDup());
            }
            bb.flip();
        }
        return ReaderImpl.extractFileTail((ByteBuffer)bb);
    }

    private OrcProto.StripeFooter buildStripeFooter(BufferChunk bcs, int len, CompressionCodec codec, int bufferSize) throws IOException {
        InStream.StreamOptions options = null;
        if (codec != null) {
            options = InStream.options().withCodec(OrcCodecPool.getCodec((CompressionKind)codec.getKind())).withBufferSize(bufferSize);
        }
        return OrcProto.StripeFooter.parseFrom((CodedInputStream)InStream.createCodedInputStream((InStream)InStream.create((Object)"footer", (DiskRangeList)new BufferChunk(bcs.getData(), 0L), (long)0L, (long)len, (InStream.StreamOptions)options)));
    }

    private ArrayList<OrcStripeMetadata> readStripesMetadata(boolean[] includes, boolean[] sargColumns) throws IOException {
        ArrayList<OrcStripeMetadata> result = new ArrayList<OrcStripeMetadata>(this.stripeRgs.length);
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, 0, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.stripeRgs.length; ++stripeIxMod) {
            int stripeIx;
            stripeKey.stripeIx = stripeIx = stripeIxMod + this.stripeIxFrom;
            StripeInformation si = this.fileMetadata.getStripes().get(stripeIx);
            OrcProto.StripeFooter footer = this.getStripeFooterFromCacheOrDisk(si, stripeKey);
            OrcStripeMetadata osm = this.createOrcStripeMetadataObject(stripeIx, si, footer, includes, sargColumns);
            this.ensureDataReader();
            OrcIndex index = osm.getIndex();
            this.stripeReader.readIndexStreams(index, si, footer.getStreamsList(), includes, sargColumns);
            result.add(osm);
            this.consumer.setStripeMetadata(osm);
        }
        return result;
    }

    private OrcStripeMetadata createOrcStripeMetadataObject(int stripeIx, StripeInformation si, OrcProto.StripeFooter footer, boolean[] includes, boolean[] sargColumns) throws IOException {
        OrcProto.Stream.Kind[] bks = sargColumns == null ? null : new OrcProto.Stream.Kind[includes.length];
        OrcProto.BloomFilterIndex[] bis = sargColumns == null ? null : new OrcProto.BloomFilterIndex[includes.length];
        return new OrcStripeMetadata(new OrcBatchKey(this.fileKey, stripeIx, 0), footer, new OrcIndex(new OrcProto.RowIndex[includes.length], bks, bis), si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrcProto.StripeFooter getStripeFooterFromCacheOrDisk(StripeInformation si, OrcBatchKey stripeKey) throws IOException {
        boolean hasCache;
        boolean bl = hasCache = this.fileKey != null && this.metadataCache != null;
        if (hasCache) {
            MetadataCache.LlapBufferOrBuffers footerBuffers = this.metadataCache.getStripeTail(stripeKey);
            if (footerBuffers != null) {
                try {
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                    this.ensureCodecFromFileMetadata();
                    MemoryBuffer footerBuffer = footerBuffers.getSingleBuffer();
                    if (footerBuffer != null) {
                        ByteBuffer bb = footerBuffer.getByteBufferDup();
                        OrcProto.StripeFooter stripeFooter = this.buildStripeFooter(new BufferChunk(bb, 0L), bb.remaining(), this.codec, this.fileMetadata.getCompressionBufferSize());
                        return stripeFooter;
                    }
                    OrcProto.StripeFooter footerBufferArray = footerBuffers.getMultipleBuffers();
                    int pos = 0;
                    BufferChunkList bcs = new BufferChunkList();
                    for (MemoryBuffer buf : footerBufferArray) {
                        ByteBuffer bb = buf.getByteBufferDup();
                        bcs.add(new BufferChunk(bb, (long)pos));
                        pos += bb.remaining();
                    }
                    OrcProto.StripeFooter stripeFooter = this.buildStripeFooter(bcs.get(), pos, this.codec, this.fileMetadata.getCompressionBufferSize());
                    return stripeFooter;
                }
                finally {
                    this.metadataCache.decRefBuffer(footerBuffers);
                }
            }
            this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
            LlapHiveUtils.throwIfCacheOnlyRead((boolean)this.isReadCacheOnly);
        }
        long offset = si.getOffset() + si.getIndexLength() + si.getDataLength();
        long startTime = this.counters.startTimeCounter();
        this.ensureRawDataReader(true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reading [" + offset + ", " + (offset + si.getFooterLength()) + ") based on " + si);
        }
        DiskRangeList footerRange = this.rawDataReader.readFileData(new DiskRangeList(offset, offset + si.getFooterLength()), 0L, false);
        this.counters.incrWallClockCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
        assert (footerRange.next == null);
        if (hasCache) {
            MetadataCache.LlapBufferOrBuffers cacheBuf = this.metadataCache.putStripeTail(stripeKey, footerRange.getData().duplicate(), this.cacheTag, this.isStopped);
            this.metadataCache.decRefBuffer(cacheBuf);
        }
        ByteBuffer bb = footerRange.getData().duplicate();
        CompressionKind kind = this.orcReader.getCompressionKind();
        boolean isPool = this.useCodecPool;
        CompressionCodec codec = isPool ? OrcCodecPool.getCodec((CompressionKind)kind) : WriterImpl.createCodec((CompressionKind)kind);
        boolean isCodecError = true;
        try {
            OrcProto.StripeFooter result = this.buildStripeFooter(new BufferChunk(bb, 0L), bb.remaining(), codec, this.orcReader.getCompressionSize());
            isCodecError = false;
            OrcProto.StripeFooter stripeFooter = result;
            return stripeFooter;
        }
        finally {
            try {
                if (codec != null) {
                    if (isPool && !isCodecError) {
                        OrcCodecPool.returnCodec((CompressionKind)kind, (CompressionCodec)codec);
                    } else {
                        codec.close();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Ignoring codec cleanup error", (Throwable)ex);
            }
        }
    }

    private void ensureRawDataReader(boolean isOpen) throws IOException {
        this.ensureOrcReader();
        if (this.rawDataReader != null) {
            if (!this.isRawDataReaderOpen && isOpen) {
                long startTime = this.counters.startTimeCounter();
                this.rawDataReader.open();
                this.counters.incrWallClockCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
            }
            return;
        }
        long startTime = this.counters.startTimeCounter();
        boolean useZeroCopy = this.daemonConf != null && OrcConf.USE_ZEROCOPY.getBoolean(this.daemonConf);
        InStream.StreamOptions options = null;
        if (this.orcReader.getCompressionKind() != CompressionKind.NONE) {
            options = InStream.options().withCodec(OrcCodecPool.getCodec((CompressionKind)this.orcReader.getCompressionKind())).withBufferSize(this.orcReader.getCompressionSize());
        }
        this.rawDataReader = LlapRecordReaderUtils.createDefaultLlapDataReader(DataReaderProperties.builder().withFileSystemSupplier(this.fsSupplier).withPath(this.path).withCompression(options).withZeroCopy(useZeroCopy).build());
        if (isOpen) {
            this.rawDataReader.open();
            this.isRawDataReaderOpen = true;
        }
        this.counters.incrWallClockCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    @Override
    public void returnData(Reader.OrcEncodedColumnBatch ecb) {
        for (int colIx = 0; colIx < ecb.getTotalColCount(); ++colIx) {
            EncodedColumnBatch.ColumnStreamData[] datas;
            if (!ecb.hasData(colIx)) continue;
            for (EncodedColumnBatch.ColumnStreamData data : datas = ecb.getColumnData(colIx)) {
                if (data == null || data.decRef() != 0) continue;
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} at the end of processing", (Object)buf);
                    }
                }
                this.bufferManager.decRefBuffers(data.getCacheBuffers());
                if (!this.useObjectPools) continue;
                CSD_POOL.offer((Object)data);
            }
        }
        if (this.useObjectPools) {
            ECB_POOL.offer((Object)ecb);
        }
    }

    private boolean determineRgsToRead(int rowIndexStride, ArrayList<OrcStripeMetadata> metadata) throws IOException {
        RecordReaderImpl.SargApplier sargApp = null;
        if (this.sarg != null && rowIndexStride != 0) {
            sargApp = new RecordReaderImpl.SargApplier(this.sarg, (long)rowIndexStride, this.evolution, OrcFile.WriterVersion.from((OrcFile.WriterImplementation)OrcFile.WriterImplementation.ORC_JAVA, (int)this.fileMetadata.getWriterVersionNum()), true, this.fileMetadata.getCalendar() == OrcProto.CalendarKind.PROLEPTIC_GREGORIAN, true);
        }
        boolean hasAnyData = false;
        for (int stripeIxMod = 0; stripeIxMod < this.stripeRgs.length; ++stripeIxMod) {
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            StripeInformation stripe = this.fileMetadata.getStripes().get(stripeIx);
            int rgCount = this.getRgCount(stripe, rowIndexStride);
            boolean[] rgsToRead = null;
            if (sargApp != null) {
                OrcStripeMetadata stripeMetadata = metadata.get(stripeIxMod);
                rgsToRead = sargApp.pickRowGroups(stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getBloomFilterKinds(), stripeMetadata.getEncodings(), stripeMetadata.getBloomFilterIndexes(), true);
            }
            boolean isNone = rgsToRead == RecordReaderImpl.SargApplier.READ_NO_RGS;
            boolean isAll = rgsToRead == RecordReaderImpl.SargApplier.READ_ALL_RGS;
            boolean bl = hasAnyData = hasAnyData || !isNone;
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                if (isNone) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG eliminated all RGs for stripe {}", (Object)stripeIx);
                    this.trace.logSargResult(stripeIx, 0);
                } else if (!isAll) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG picked RGs for stripe {}: {}", (Object)stripeIx, (Object)DebugUtils.toString((boolean[])rgsToRead));
                    this.trace.logSargResult(stripeIx, rgsToRead);
                } else {
                    LlapIoImpl.ORC_LOGGER.trace("Will read all {} RGs for stripe {}", (Object)rgCount, (Object)stripeIx);
                    this.trace.logSargResult(stripeIx, rgCount);
                }
            }
            assert (isAll || isNone || rgsToRead.length == rgCount);
            this.stripeRgs[stripeIxMod] = isAll || isNone ? rgsToRead : Arrays.copyOf(rgsToRead, rgsToRead.length);
            this.adjustRgMetric(rgCount, rgsToRead, isNone, isAll);
        }
        return hasAnyData;
    }

    private void adjustRgMetric(int rgCount, boolean[] rgsToRead, boolean isNone, boolean isAll) {
        int count = 0;
        if (!isAll) {
            for (boolean b : rgsToRead) {
                if (!b) continue;
                ++count;
            }
        } else if (!isNone) {
            count = rgCount;
        }
        this.counters.incrCounter(LlapIOCounters.SELECTED_ROWGROUPS, count);
    }

    private int getRgCount(StripeInformation stripe, int rowIndexStride) {
        return (int)Math.ceil((double)stripe.getNumberOfRows() / (double)rowIndexStride);
    }

    public void determineStripesToRead() {
        List<StripeInformation> stripes = this.fileMetadata.getStripes();
        long offset = this.split.getStart();
        long maxOffset = offset + this.split.getLength();
        this.stripeIxFrom = -1;
        int stripeIxTo = -1;
        if (LlapIoImpl.ORC_LOGGER.isDebugEnabled()) {
            String tmp = "FileSplit {" + this.split.getStart() + ", " + this.split.getLength() + "}; stripes ";
            for (StripeInformation stripe : stripes) {
                tmp = tmp + "{" + stripe.getOffset() + ", " + stripe.getLength() + "}, ";
            }
            LlapIoImpl.ORC_LOGGER.debug(tmp);
        }
        int stripeIx = 0;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                ++stripeIx;
                continue;
            }
            if (this.stripeIxFrom == -1) {
                LlapIoImpl.ORC_LOGGER.trace("Including stripes from {} ({} >= {})", new Object[]{stripeIx, stripeStart, offset});
                this.stripeIxFrom = stripeIx;
            }
            if (stripeStart >= maxOffset) {
                stripeIxTo = stripeIx;
                LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} ({} >= {}); {} stripes", new Object[]{stripeIxTo, stripeStart, maxOffset, stripeIxTo - this.stripeIxFrom});
                break;
            }
            ++stripeIx;
        }
        if (this.stripeIxFrom == -1) {
            LlapIoImpl.LOG.info("Not including any stripes - empty split");
        }
        if (stripeIxTo == -1 && this.stripeIxFrom != -1) {
            stripeIxTo = stripeIx;
            LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} (end of file); {} stripes", (Object)stripeIx, (Object)(stripeIxTo - this.stripeIxFrom));
        }
        this.stripeRgs = new boolean[stripeIxTo - this.stripeIxFrom][];
    }

    @Override
    public TezCounters getTezCounters() {
        return this.counters.getTezCounters();
    }

    public IoTrace getTrace() {
        return this.trace;
    }

    private class DataWrapperForOrc
    implements LlapDataReader,
    DataCache,
    Allocator.BufferObjectFactory {
        private final LlapDataReader orcDataReaderRef;

        public DataWrapperForOrc() throws IOException {
            OrcEncodedDataReader.this.ensureRawDataReader(false);
            this.orcDataReaderRef = OrcEncodedDataReader.this.rawDataReader;
        }

        public CompressionCodec getCompressionCodec() {
            return this.orcDataReaderRef.getCompressionCodec();
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            DiskRangeList result = OrcEncodedDataReader.this.lowLevelCache.getFileData(fileKey, range, baseOffset, factory, OrcEncodedDataReader.this.counters, gotAllData);
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                LlapIoImpl.ORC_LOGGER.trace("Disk ranges after data cache (file " + fileKey + ", base offset " + baseOffset + "): " + RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result));
            }
            if (gotAllData.value) {
                return result;
            }
            return OrcEncodedDataReader.this.metadataCache == null ? result : OrcEncodedDataReader.this.metadataCache.getIncompleteCbs(fileKey, result, baseOffset, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            return this.putFileData(fileKey, ranges, data, baseOffset, null);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset, CacheTag tag) {
            if (data != null) {
                return OrcEncodedDataReader.this.lowLevelCache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, OrcEncodedDataReader.this.counters, tag);
            }
            if (OrcEncodedDataReader.this.metadataCache != null) {
                OrcEncodedDataReader.this.metadataCache.putIncompleteCbs(fileKey, ranges, baseOffset, OrcEncodedDataReader.this.isStopped);
            }
            return null;
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            OrcEncodedDataReader.this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = OrcEncodedDataReader.this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return OrcEncodedDataReader.this.bufferManager.getAllocator();
        }

        public void close() throws IOException {
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            DiskRangeList result = this.orcDataReaderRef.readFileData(range, baseOffset, doForceDirect);
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                LlapIoImpl.ORC_LOGGER.trace("Disk ranges after disk read (file {}, base offset {}): {}", new Object[]{OrcEncodedDataReader.this.fileKey, baseOffset, RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result)});
            }
            OrcEncodedDataReader.this.trace.logRanges(OrcEncodedDataReader.this.fileKey, baseOffset, result, IoTrace.RangesSrc.DISK);
            return result;
        }

        public boolean isTrackingDiskRanges() {
            return this.orcDataReaderRef.isTrackingDiskRanges();
        }

        public void releaseBuffer(ByteBuffer buffer) {
            this.orcDataReaderRef.releaseBuffer(buffer);
        }

        public DataWrapperForOrc clone() {
            throw new AssertionError((Object)"Clone not supported");
        }

        public void open() throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            this.orcDataReaderRef.open();
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
        }

        public OrcIndex readRowIndex(StripeInformation stripe, TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            return this.orcDataReaderRef.readRowIndex(stripe, fileSchema, footer, ignoreNonUtf8BloomFilter, included, indexes, sargColumns, version, bloomFilterKinds, bloomFilterIndices);
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            return this.orcDataReaderRef.readStripeFooter(stripe);
        }

        public Allocator.BufferObjectFactory getDataBufferFactory() {
            return this;
        }

        public MemoryBuffer create() {
            return new LlapDataBuffer();
        }
    }
}

