/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.OrcConf;

public class OrcColumnVectorProducer
implements ColumnVectorProducer {
    private final MetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final PathCache pathCache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private boolean _skipCorrupt;
    private LlapDaemonCacheMetrics cacheMetrics;
    private LlapDaemonIOMetrics ioMetrics;
    private final FixedSizedObjectPool<IoTrace> tracePool;

    public OrcColumnVectorProducer(MetadataCache metadataCache, LowLevelCache lowLevelCache, PathCache pathCache, BufferUsageManager bufferManager, Configuration conf, LlapDaemonCacheMetrics cacheMetrics, LlapDaemonIOMetrics ioMetrics, FixedSizedObjectPool<IoTrace> tracePool) {
        LlapIoImpl.LOG.info("Initializing ORC column vector producer");
        this.metadataCache = metadataCache;
        this.lowLevelCache = lowLevelCache;
        this.pathCache = pathCache;
        this.bufferManager = bufferManager;
        this.conf = conf;
        this._skipCorrupt = OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf);
        this.cacheMetrics = cacheMetrics;
        this.ioMetrics = ioMetrics;
        this.tracePool = tracePool;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public ReadPipeline createReadPipeline(Consumer<ColumnVectorBatch> consumer, FileSplit split, ColumnVectorProducer.Includes includes, SearchArgument sarg, QueryFragmentCounters counters, ColumnVectorProducer.SchemaEvolutionFactory sef, InputFormat<?, ?> unused0, Deserializer unused1, Reporter reporter, JobConf job, Map<Path, PartitionDesc> parts) throws IOException {
        this.cacheMetrics.incrCacheReadRequests();
        OrcEncodedDataConsumer edc = new OrcEncodedDataConsumer(consumer, includes, this._skipCorrupt, counters, this.ioMetrics, this.conf);
        OrcEncodedDataReader reader = new OrcEncodedDataReader(this.lowLevelCache, this.bufferManager, this.metadataCache, this.conf, (Configuration)job, split, includes, sarg, edc, counters, sef, (Pool<IoTrace>)this.tracePool, parts, this.pathCache);
        edc.init(reader, (Callable<Void>)((Object)reader), reader.getTrace());
        return edc;
    }
}

