/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public class ColumnVectorBatch {
    public VectorizedRowBatch filterContext;
    public ColumnVector[] cols;

    public ColumnVectorBatch(int columnCount) {
        this(columnCount, 1024);
    }

    public ColumnVectorBatch(int columnCount, int batchSize) {
        this.filterContext = new VectorizedRowBatch(columnCount, batchSize);
        this.cols = this.filterContext.cols;
    }

    public void swapColumnVector(int ix, ColumnVector[] other, int otherIx) {
        ColumnVector old = other[otherIx];
        other[otherIx] = this.cols[ix];
        this.cols[ix] = old;
    }

    public String toString() {
        if (this.filterContext.size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("FilterContext used: ");
        b.append(this.filterContext.isSelectedInUse());
        b.append(", size: ");
        b.append(this.filterContext.getSelectedSize());
        b.append('\n');
        b.append("Selected: ");
        b.append(this.filterContext.isSelectedInUse() ? Arrays.toString(this.filterContext.getSelected()) : "[]");
        b.append('\n');
        b.append("Column vector types: ");
        for (int k = 0; k < this.cols.length; ++k) {
            ColumnVector cv = this.cols[k];
            b.append(k);
            b.append(":");
            b.append(cv == null ? "null" : cv.getClass().getSimpleName().replace("ColumnVector", ""));
        }
        b.append('\n');
        for (int i = 0; i < this.filterContext.size; ++i) {
            b.append('[');
            for (int k = 0; k < this.cols.length; ++k) {
                ColumnVector cv = this.cols[k];
                if (k > 0) {
                    b.append(", ");
                }
                if (cv == null || cv == null) continue;
                try {
                    cv.stringifyValue(b, this.filterContext.isSelectedInUse() ? this.filterContext.getSelected()[i] : i);
                    continue;
                }
                catch (Exception ex) {
                    b.append("invalid");
                }
            }
            b.append(']');
            if (i >= this.filterContext.size - 1) continue;
            b.append('\n');
        }
        return b.toString();
    }
}

