/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.llap.LlapNodeId;
import org.apache.hadoop.hive.llap.daemon.FinishableStateUpdateHandler;
import org.apache.hadoop.hive.llap.daemon.impl.ContainerRunnerImpl;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;

public class QueryInfo {
    private final QueryIdentifier queryIdentifier;
    private final String appIdString;
    private final String dagIdString;
    private final String dagName;
    private final String hiveQueryIdString;
    private final int dagIdentifier;
    private final String user;
    private final String[] localDirsBase;
    private final FileSystem localFs;
    private String[] localDirs;
    private final LlapNodeId amNodeId;
    private final String appTokenIdentifier;
    private final Token<JobTokenIdentifier> appToken;
    private final boolean isExternalQuery;
    private final Set<QueryFragmentInfo> knownFragments = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto> sourceStateMap;
    private final FinishableStateTracker finishableStateTracker = new FinishableStateTracker();
    private final String tokenUserName;
    private final String appId;
    private final ContainerRunnerImpl.UgiPool ugiPool;

    public QueryInfo(QueryIdentifier queryIdentifier, String appIdString, String dagIdString, String dagName, String hiveQueryIdString, int dagIdentifier, String user, ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto> sourceStateMap, String[] localDirsBase, FileSystem localFs, String tokenUserName, String tokenAppId, LlapNodeId amNodeId, String tokenIdentifier, Token<JobTokenIdentifier> appToken, boolean isExternalQuery, ContainerRunnerImpl.UgiPool ugiPool) {
        this.queryIdentifier = queryIdentifier;
        this.appIdString = appIdString;
        this.dagIdString = dagIdString;
        this.dagName = dagName;
        this.hiveQueryIdString = hiveQueryIdString;
        this.dagIdentifier = dagIdentifier;
        this.sourceStateMap = sourceStateMap;
        this.user = user;
        this.localDirsBase = localDirsBase;
        this.localFs = localFs;
        this.tokenUserName = tokenUserName;
        this.appId = tokenAppId;
        this.amNodeId = amNodeId;
        this.appTokenIdentifier = tokenIdentifier;
        this.appToken = appToken;
        this.isExternalQuery = isExternalQuery;
        this.ugiPool = ugiPool;
        InetSocketAddress address = NetUtils.createSocketAddrForHost((String)amNodeId.getHostname(), (int)amNodeId.getPort());
        if (!address.isUnresolved()) {
            SecurityUtil.setTokenService(appToken, (InetSocketAddress)address);
        }
    }

    public QueryIdentifier getQueryIdentifier() {
        return this.queryIdentifier;
    }

    public String getAppIdString() {
        return this.appIdString;
    }

    public String getDagIdString() {
        return this.dagIdString;
    }

    public String getHiveQueryIdString() {
        return this.hiveQueryIdString;
    }

    public int getDagIdentifier() {
        return this.dagIdentifier;
    }

    public String getUser() {
        return this.user;
    }

    public ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto> getSourceStateMap() {
        return this.sourceStateMap;
    }

    public LlapNodeId getAmNodeId() {
        return this.amNodeId;
    }

    public QueryFragmentInfo registerFragment(String vertexName, int fragmentNumber, int attemptNumber, LlapDaemonProtocolProtos.SignableVertexSpec vertexSpec, String fragmentIdString) {
        QueryFragmentInfo fragmentInfo = new QueryFragmentInfo(this, vertexName, fragmentNumber, attemptNumber, vertexSpec, fragmentIdString);
        boolean wasUniqueFragment = this.knownFragments.add(fragmentInfo);
        if (!wasUniqueFragment) {
            String message = "Fragment " + fragmentIdString + "(isExternal=" + this.isExternalQuery() + ") has already been registered.";
            throw new IllegalArgumentException(message);
        }
        return fragmentInfo;
    }

    public void unregisterFragment(QueryFragmentInfo fragmentInfo) {
        this.knownFragments.remove(fragmentInfo);
    }

    public List<QueryFragmentInfo> getRegisteredFragments() {
        return Lists.newArrayList(this.knownFragments);
    }

    public boolean isExternalQuery() {
        return this.isExternalQuery;
    }

    private synchronized void createLocalDirs() throws IOException {
        if (this.localDirs == null) {
            this.localDirs = new String[this.localDirsBase.length];
            for (int i = 0; i < this.localDirsBase.length; ++i) {
                this.localDirs[i] = QueryInfo.createAppSpecificLocalDir(this.localDirsBase[i], this.appIdString, this.user, this.dagIdentifier);
                this.localFs.mkdirs(new Path(this.localDirs[i]));
            }
        }
    }

    public synchronized String[] getLocalDirs() throws IOException {
        if (this.localDirs == null) {
            this.createLocalDirs();
        }
        return this.localDirs;
    }

    public synchronized String[] getLocalDirsNoCreate() {
        return this.localDirs;
    }

    private static String createAppSpecificLocalDir(String baseDir, String applicationIdString, String user, int dagIdentifier) {
        return baseDir + File.separator + "usercache" + File.separator + user + File.separator + "appcache" + File.separator + applicationIdString + File.separator + dagIdentifier;
    }

    boolean registerForFinishableStateUpdates(FinishableStateUpdateHandler handler, List<String> sources, QueryFragmentInfo fragmentInfo, boolean lastFinishableState) {
        return this.finishableStateTracker.registerForUpdates(handler, sources, fragmentInfo, lastFinishableState);
    }

    void unregisterFinishableStateUpdate(FinishableStateUpdateHandler handler) {
        this.finishableStateTracker.unregisterForUpdates(handler);
    }

    void sourceStateUpdated(String sourceName) {
        this.finishableStateTracker.sourceStateUpdated(sourceName);
    }

    public String getTokenUserName() {
        return this.tokenUserName;
    }

    public String getTokenAppId() {
        return this.appId;
    }

    UserGroupInformation getUmbilicalUgi() throws ExecutionException {
        return this.ugiPool.getUmbilicalUgi(this.appTokenIdentifier, this.appToken);
    }

    void returnUmbilicalUgi(UserGroupInformation ugi) {
        this.ugiPool.returnUmbilicalUgi(this.appTokenIdentifier, ugi);
    }

    private static class EntityInfo {
        final FinishableStateUpdateHandler handler;
        final List<String> sources;
        final QueryFragmentInfo fragmentInfo;
        boolean lastFinishableState;

        public EntityInfo(FinishableStateUpdateHandler handler, List<String> sources, QueryFragmentInfo fragmentInfo, boolean lastFinishableState) {
            this.handler = handler;
            this.sources = sources;
            this.fragmentInfo = fragmentInfo;
            this.lastFinishableState = lastFinishableState;
        }

        public FinishableStateUpdateHandler getHandler() {
            return this.handler;
        }

        public QueryFragmentInfo getFragmentInfo() {
            return this.fragmentInfo;
        }

        public boolean getLastFinishableState() {
            return this.lastFinishableState;
        }

        public List<String> getSources() {
            return this.sources;
        }

        public void setLastFinishableState(boolean lastFinishableState) {
            this.lastFinishableState = lastFinishableState;
        }
    }

    private static class FinishableStateTracker {
        private final Map<FinishableStateUpdateHandler, EntityInfo> trackedEntities = new HashMap<FinishableStateUpdateHandler, EntityInfo>();
        private final Multimap<String, EntityInfo> sourceToEntity = HashMultimap.create();
        private final ReentrantLock lock = new ReentrantLock();

        private FinishableStateTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerForUpdates(FinishableStateUpdateHandler handler, List<String> sources, QueryFragmentInfo fragmentInfo, boolean lastFinishableState) {
            this.lock.lock();
            try {
                EntityInfo entityInfo = new EntityInfo(handler, sources, fragmentInfo, lastFinishableState);
                if (this.trackedEntities.put(handler, entityInfo) != null) {
                    throw new IllegalStateException("Only a single registration allowed per entity. Duplicate for " + handler.toString());
                }
                for (String source : sources) {
                    this.sourceToEntity.put((Object)source, (Object)entityInfo);
                }
                boolean canFinish = QueryFragmentInfo.canFinish(fragmentInfo);
                if (lastFinishableState == canFinish) {
                    boolean bl = true;
                    return bl;
                }
                entityInfo.setLastFinishableState(canFinish);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterForUpdates(FinishableStateUpdateHandler handler) {
            this.lock.lock();
            try {
                EntityInfo info = this.trackedEntities.remove(handler);
                Preconditions.checkState((info != null ? 1 : 0) != 0, (Object)"Cannot invoke unregister on an entity which has not been registered");
                for (String source : info.getSources()) {
                    this.sourceToEntity.remove((Object)source, (Object)info);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sourceStateUpdated(String sourceName) {
            LinkedList interestedEntityInfos = null;
            this.lock.lock();
            try {
                Collection entities = this.sourceToEntity.get((Object)sourceName);
                if (entities != null) {
                    interestedEntityInfos = new LinkedList(entities);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (interestedEntityInfos != null) {
                for (EntityInfo entityInfo : interestedEntityInfos) {
                    boolean newFinishState = QueryFragmentInfo.canFinish(entityInfo.getFragmentInfo());
                    if (newFinishState == entityInfo.getLastFinishableState()) continue;
                    entityInfo.setLastFinishableState(newFinishState);
                    entityInfo.getHandler().finishableStateUpdated(newFinishState);
                }
            }
        }
    }
}

