/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.metrics.ReadWriteLockMetrics;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestReadWriteLockMetrics {
    private void assertWithTolerance(String txt, long expected, long actual) {
        long lowExpected = expected - expected / 10L;
        long highExpected = expected + expected / 10L;
        StringBuffer msg = new StringBuffer(txt);
        msg.append(" (expected ");
        msg.append(lowExpected);
        msg.append(" <= x <= ");
        msg.append(highExpected);
        msg.append(" but actual = ");
        msg.append(actual);
        msg.append(")");
        Assert.assertTrue((String)msg.toString(), (actual >= lowExpected && actual <= highExpected ? 1 : 0) != 0);
    }

    private static long toNano(long ms) {
        return ms * 1000000L;
    }

    private ReadWriteLockMetrics create(ReadWriteLock lock, MetricsSource ms) {
        Configuration dummyConf = new Configuration();
        HiveConf.setBoolVar((Configuration)dummyConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_COLLECT_LOCK_METRICS, (boolean)true);
        return (ReadWriteLockMetrics)ReadWriteLockMetrics.wrap((Configuration)dummyConf, (ReadWriteLock)lock, (MetricsSource)ms);
    }

    @Ignore(value="Test requires available CPU resources for background threads")
    @Test
    public void testWithoutContention() throws Exception {
        long execTime = 100L;
        MetricsSource ms = ReadWriteLockMetrics.createLockMetricsSource((String)"test1");
        ReadWriteLockMetrics rwl = this.create(new ReentrantReadWriteLock(), ms);
        LockHolder lhR = new LockHolder(rwl.readLock(), 100L);
        lhR.join();
        MockMetricsCollector tmc = new MockMetricsCollector();
        ms.getMetrics((MetricsCollector)tmc, true);
        List<MockMetricsCollector.MockRecord> result = tmc.getRecords();
        Assert.assertEquals((String)"Unexpected amount of metrics", (long)1L, (long)result.size());
        MockMetricsCollector.MockRecord rec = result.get(0);
        Assert.assertEquals((String)"Invalid record label", (Object)"test1", (Object)rec.getLabel());
        Assert.assertEquals((String)"Invalid record context", (Object)"Locking", (Object)rec.getContext());
        this.assertWithTolerance("Unexpected count of lock executions (reader)", 20L, lhR.getLockCount());
        Assert.assertEquals((String)"Counting the locks failed", (Object)lhR.getLockCount(), (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockCount));
        Assert.assertNotEquals((String)"Local thread should have lock time", (long)lhR.getLockSum(), (long)0L);
        Assert.assertNotEquals((String)"Accounted lock time zero", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeTotal), (Object)0);
        Assert.assertTrue((String)"Local measurement larger (overhead)", (rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeTotal).longValue() < lhR.getLockSum() ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"Local thread should have max lock time", (long)lhR.getLockMax(), (long)0L);
        Assert.assertNotEquals((String)"Accounted lock max time zero", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeMax), (Object)0);
        Assert.assertTrue((String)"Local max larger (overhead)", (rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeMax).longValue() < lhR.getLockMax() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Max greater or equal to average lock time", (rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeTotal).longValue() / rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockCount).longValue() <= rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeMax).longValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Lock time less than 1% (no contention)", (rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeTotal).longValue() < TestReadWriteLockMetrics.toNano(1L) ? 1 : 0) != 0);
        Assert.assertEquals((String)"No writer lock activity expected (total)", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockWaitTimeTotal), (Object)0L);
        Assert.assertEquals((String)"No writer lock activity expected (max)", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockWaitTimeMax), (Object)0L);
        Assert.assertEquals((String)"No writer lock activity expected (count)", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockCount), (Object)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Test requires available CPU resources for background threads")
    @Test
    public void testWithContention() throws Exception {
        long execTime = 200L;
        MetricsSource ms = ReadWriteLockMetrics.createLockMetricsSource((String)"test1");
        ReadWriteLockMetrics rwl = this.create(new ReentrantReadWriteLock(), ms);
        LockHolder lhR = new LockHolder(rwl.readLock(), 200L);
        try {
            long endOfLock = System.nanoTime() + TestReadWriteLockMetrics.toNano(100L);
            rwl.writeLock().lock();
            while (System.nanoTime() < endOfLock) {
            }
        }
        finally {
            rwl.writeLock().unlock();
        }
        lhR.join();
        MockMetricsCollector tmc = new MockMetricsCollector();
        ms.getMetrics((MetricsCollector)tmc, true);
        List<MockMetricsCollector.MockRecord> result = tmc.getRecords();
        Assert.assertEquals((String)"Unexpected amount of metrics", (long)1L, (long)result.size());
        MockMetricsCollector.MockRecord rec = result.get(0);
        Assert.assertEquals((String)"Verifying the loop count (read lock)", (long)lhR.getLockCount(), (long)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockCount).longValue());
        this.assertWithTolerance("Only half of possible read locks expected", 20L, rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockCount).longValue());
        this.assertWithTolerance("Max read lock wait time close to write lock hold", TestReadWriteLockMetrics.toNano(100L), rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeMax).longValue());
        Assert.assertTrue((String)"Total read lock wait time larger than max", (rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeMax).longValue() < rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.ReadLockWaitTimeTotal).longValue() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Write lock count supposed to be one", (long)1L, (long)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockCount).longValue());
        Assert.assertTrue((String)"Write lock wait time non zero", (0L < rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockWaitTimeTotal).longValue() ? 1 : 0) != 0);
        Assert.assertEquals((String)"With one lock, total should me max", (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockWaitTimeTotal), (Object)rec.getMetrics().get(ReadWriteLockMetrics.LockMetricInfo.WriteLockWaitTimeMax));
    }

    @Test
    public void testWrap() throws Exception {
        Configuration testConf = new Configuration();
        MetricsSource ms = ReadWriteLockMetrics.createLockMetricsSource((String)"testConf");
        ReadWriteLock rwlDef = ReadWriteLockMetrics.wrap((Configuration)testConf, (ReadWriteLock)new ReentrantReadWriteLock(), (MetricsSource)ms);
        Assert.assertTrue((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlDef instanceof ReentrantReadWriteLock));
        Assert.assertFalse((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlDef instanceof ReadWriteLockMetrics));
        HiveConf.setBoolVar((Configuration)testConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_COLLECT_LOCK_METRICS, (boolean)false);
        ReadWriteLock rwlBasic = ReadWriteLockMetrics.wrap((Configuration)testConf, (ReadWriteLock)new ReentrantReadWriteLock(), (MetricsSource)ms);
        Assert.assertTrue((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlBasic instanceof ReentrantReadWriteLock));
        Assert.assertFalse((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlBasic instanceof ReadWriteLockMetrics));
        HiveConf.setBoolVar((Configuration)testConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_COLLECT_LOCK_METRICS, (boolean)true);
        ReadWriteLock rwlWrap = ReadWriteLockMetrics.wrap((Configuration)testConf, (ReadWriteLock)new ReentrantReadWriteLock(), (MetricsSource)ms);
        Assert.assertTrue((String)"Wrapped lock expected", (boolean)(rwlWrap instanceof ReadWriteLockMetrics));
        ReadWriteLock rwlNoConf = ReadWriteLockMetrics.wrap(null, (ReadWriteLock)new ReentrantReadWriteLock(), null);
        Assert.assertTrue((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlNoConf instanceof ReentrantReadWriteLock));
        Assert.assertFalse((String)"Basic ReentrantReadWriteLock expected", (boolean)(rwlNoConf instanceof ReadWriteLockMetrics));
    }

    private static class LockHolder
    extends Thread {
        public static final long LOCK_HOLD_TIME = 5L;
        private final Lock targetLock;
        private long lockCount;
        private long lockWaitSum;
        private long lockWaitMax;
        private long endTime;

        public LockHolder(Lock l, long ttl) {
            this.targetLock = l;
            this.lockCount = 0L;
            this.lockWaitSum = 0L;
            this.lockWaitMax = 0L;
            this.endTime = ttl;
            this.setName(this.getClass().getSimpleName());
            this.setDaemon(true);
            this.start();
        }

        public long getLockCount() {
            return this.lockCount;
        }

        public long getLockSum() {
            return this.lockWaitSum;
        }

        public long getLockMax() {
            return this.lockWaitMax;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.endTime = System.nanoTime() + TestReadWriteLockMetrics.toNano(this.endTime);
            while (System.nanoTime() <= this.endTime && !this.isInterrupted()) {
                try {
                    long start = System.nanoTime();
                    this.targetLock.lock();
                    ++this.lockCount;
                    long diff = System.nanoTime() - start;
                    this.lockWaitSum += diff;
                    this.lockWaitMax = Math.max(diff, this.lockWaitMax);
                    while (System.nanoTime() <= start + TestReadWriteLockMetrics.toNano(5L)) {
                    }
                }
                finally {
                    this.targetLock.unlock();
                }
            }
        }
    }

    private static class MockMetricsCollector
    implements MetricsCollector {
        private ArrayList<MockRecord> records = new ArrayList();

        private MockMetricsCollector() {
        }

        public MetricsRecordBuilder addRecord(String arg0) {
            MockRecord tr = new MockRecord(arg0);
            this.records.add(tr);
            return new MockMetricsRecordBuilder(tr);
        }

        public MetricsRecordBuilder addRecord(MetricsInfo arg0) {
            MockRecord tr = new MockRecord(arg0.name());
            this.records.add(tr);
            return new MockMetricsRecordBuilder(tr);
        }

        public List<MockRecord> getRecords() {
            return this.records;
        }

        public static class MockRecord {
            private final String recordLabel;
            private final HashMap<MetricsInfo, Number> metrics;
            private String context;

            public MockRecord(String label) {
                this.recordLabel = label;
                this.metrics = new HashMap();
            }

            public String getLabel() {
                return this.recordLabel;
            }

            public String getContext() {
                return this.context;
            }

            public Map<MetricsInfo, Number> getMetrics() {
                return this.metrics;
            }
        }

        private class MockMetricsRecordBuilder
        extends MetricsRecordBuilder {
            private MockRecord target = null;

            public MockMetricsRecordBuilder(MockRecord t) {
                this.target = t;
            }

            public MetricsRecordBuilder add(MetricsTag arg0) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsRecordBuilder add(AbstractMetric arg0) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsRecordBuilder addCounter(MetricsInfo arg0, int arg1) {
                this.target.getMetrics().put(arg0, arg1);
                return this;
            }

            public MetricsRecordBuilder addCounter(MetricsInfo arg0, long arg1) {
                this.target.getMetrics().put(arg0, arg1);
                return this;
            }

            public MetricsRecordBuilder addGauge(MetricsInfo arg0, int arg1) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsRecordBuilder addGauge(MetricsInfo arg0, long arg1) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsRecordBuilder addGauge(MetricsInfo arg0, float arg1) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsRecordBuilder addGauge(MetricsInfo arg0, double arg1) {
                throw new AssertionError((Object)"Not implemented for test");
            }

            public MetricsCollector parent() {
                return MockMetricsCollector.this;
            }

            public MetricsRecordBuilder setContext(String arg0) {
                this.target.context = arg0;
                return this;
            }

            public MetricsRecordBuilder tag(MetricsInfo arg0, String arg1) {
                throw new AssertionError((Object)"Not implemented for test");
            }
        }
    }
}

