/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.counters;

import java.util.ArrayList;
import java.util.List;

public enum LlapIOCounters {
    NUM_VECTOR_BATCHES(true),
    NUM_DECODED_BATCHES(true),
    SELECTED_ROWGROUPS(true),
    NUM_INPUT_ROWS(true),
    NUM_DECODED_ROWS(true),
    NUM_ERRORS(true),
    ROWS_EMITTED(true),
    METADATA_CACHE_HIT(true),
    METADATA_CACHE_MISS(true),
    CACHE_HIT_BYTES(true),
    CACHE_MISS_BYTES(true),
    ALLOCATED_BYTES(true),
    ALLOCATED_USED_BYTES(true),
    TOTAL_IO_TIME_NS(false),
    DECODE_TIME_NS(false),
    PROBE_DECODE_TIME_NS(false),
    HDFS_TIME_NS(false),
    CONSUMER_TIME_NS(false),
    IO_CPU_NS(false),
    IO_USER_NS(false);

    private boolean testSafe;

    private LlapIOCounters(boolean testSafe) {
        this.testSafe = testSafe;
    }

    public static List<String> testSafeCounterNames() {
        ArrayList<String> testSafeCounters = new ArrayList<String>();
        for (LlapIOCounters counter : LlapIOCounters.values()) {
            if (!counter.testSafe) continue;
            testSafeCounters.add(counter.name());
        }
        return testSafeCounters;
    }
}

