/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.registry.ServiceInstanceSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public interface LlapServiceInstanceSet
extends ServiceInstanceSet<LlapServiceInstance> {
    public Collection<LlapServiceInstance> getAllInstancesOrdered(boolean var1);

    public Collection<LlapServiceInstance> getAllForComputeGroup(Predicate<String> var1);

    public static Collection<LlapServiceInstance> getAllForComputeGroup(Collection<LlapServiceInstance> allInstances, Predicate<String> predicate) {
        LinkedList<LlapServiceInstance> result = new LinkedList<LlapServiceInstance>();
        for (LlapServiceInstance instance : allInstances) {
            String computeGroup;
            Map<String, String> properties = instance.getProperties();
            if (properties == null || (computeGroup = properties.get("computeName")) == null || !predicate.test(computeGroup)) continue;
            result.add(instance);
        }
        return result;
    }

    public ApplicationId getApplicationId();
}

