/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.KuduPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KuduPredicateHandler {
    static final Logger LOG = LoggerFactory.getLogger(KuduPredicateHandler.class);

    private KuduPredicateHandler() {
    }

    public static HiveStoragePredicateHandler.DecomposedPredicate decompose(ExprNodeDesc predicateExpr, Schema schema) {
        IndexPredicateAnalyzer analyzer = KuduPredicateHandler.newAnalyzer(schema);
        ArrayList sConditions = new ArrayList();
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(predicateExpr, sConditions);
        if (sConditions.size() == 0) {
            return null;
        }
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(sConditions);
        decomposedPredicate.residualPredicate = (ExprNodeGenericFuncDesc)residualPredicate;
        return decomposedPredicate;
    }

    private static IndexPredicateAnalyzer newAnalyzer(Schema schema) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp(GenericUDFOPEqual.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualNS.class.getName());
        analyzer.addComparisonOp(GenericUDFOPGreaterThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrGreaterThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPLessThan.class.getName());
        analyzer.addComparisonOp(GenericUDFOPEqualOrLessThan.class.getName());
        for (ColumnSchema col : schema.getColumns()) {
            if (col.getType() == Type.BINARY) continue;
            analyzer.allowColumnName(col.getName());
        }
        return analyzer;
    }

    public static List<KuduPredicate> getPredicates(Configuration conf, Schema schema) {
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((Configuration)conf);
        if (sarg == null) {
            return Collections.emptyList();
        }
        return KuduPredicateHandler.toKuduPredicates(sarg, schema);
    }

    private static List<KuduPredicate> toKuduPredicates(SearchArgument sarg, Schema schema) {
        ArrayList<KuduPredicate> results = new ArrayList<KuduPredicate>();
        try {
            KuduPredicateHandler.translate(sarg.getExpression(), sarg.getLeaves(), false, schema, results);
        }
        catch (Exception ex) {
            LOG.warn("Exception while generating Kudu predicates. Predicates will not be pushed", (Throwable)ex);
            return Collections.emptyList();
        }
        return results;
    }

    private static void translate(ExpressionTree root, List<PredicateLeaf> leaves, boolean isNot, Schema schema, List<KuduPredicate> results) {
        switch (root.getOperator()) {
            case OR: {
                if (isNot) {
                    for (ExpressionTree child : root.getChildren()) {
                        KuduPredicateHandler.translate(child, leaves, isNot, schema, results);
                    }
                } else {
                    return;
                }
            }
            case AND: {
                if (isNot) {
                    return;
                }
                for (ExpressionTree child : root.getChildren()) {
                    KuduPredicateHandler.translate(child, leaves, isNot, schema, results);
                }
                return;
            }
            case NOT: {
                KuduPredicateHandler.translate((ExpressionTree)root.getChildren().get(0), leaves, !isNot, schema, results);
                return;
            }
            case LEAF: {
                PredicateLeaf leaf = leaves.get(root.getLeaf());
                if (schema.hasColumn(leaf.getColumnName())) {
                    results.addAll(KuduPredicateHandler.leafToPredicates(leaf, isNot, schema));
                }
                return;
            }
            case CONSTANT: {
                return;
            }
        }
        throw new IllegalStateException("Unknown operator: " + root.getOperator());
    }

    private static List<KuduPredicate> leafToPredicates(PredicateLeaf leaf, boolean isNot, Schema schema) {
        ColumnSchema column = schema.getColumn(leaf.getColumnName());
        Object value = leaf.getLiteral();
        switch (leaf.getOperator()) {
            case EQUALS: {
                if (isNot) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.EQUAL, KuduPredicateHandler.toKuduValue(value, column)));
            }
            case LESS_THAN: {
                if (isNot) {
                    return Collections.singletonList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.GREATER_EQUAL, KuduPredicateHandler.toKuduValue(value, column)));
                }
                return Collections.singletonList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.LESS, KuduPredicateHandler.toKuduValue(value, column)));
            }
            case LESS_THAN_EQUALS: {
                if (isNot) {
                    return Collections.singletonList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.GREATER, KuduPredicateHandler.toKuduValue(value, column)));
                }
                return Collections.singletonList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.LESS_EQUAL, KuduPredicateHandler.toKuduValue(value, column)));
            }
            case IS_NULL: {
                if (isNot) {
                    return Collections.singletonList(KuduPredicate.newIsNotNullPredicate(column));
                }
                return Collections.singletonList(KuduPredicate.newIsNullPredicate(column));
            }
            case IN: {
                if (isNot) {
                    return Collections.emptyList();
                }
                List values = leaf.getLiteralList().stream().map(v -> KuduPredicateHandler.toKuduValue(v, column)).collect(Collectors.toList());
                return Collections.singletonList(KuduPredicate.newInListPredicate(column, values));
            }
            case BETWEEN: {
                List values = leaf.getLiteralList();
                Object leftValue = KuduPredicateHandler.toKuduValue(values.get(0), column);
                Object rightValue = KuduPredicateHandler.toKuduValue(values.get(1), column);
                if (isNot) {
                    return Arrays.asList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.LESS, leftValue), KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.GREATER, rightValue));
                }
                return Arrays.asList(KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.GREATER_EQUAL, leftValue), KuduPredicate.newComparisonPredicate(column, KuduPredicate.ComparisonOp.LESS_EQUAL, rightValue));
            }
            case NULL_SAFE_EQUALS: {
                return Collections.emptyList();
            }
        }
        throw new RuntimeException("Unhandled operator: " + leaf.getOperator());
    }

    private static Object toKuduValue(Object value, ColumnSchema column) {
        if (value instanceof HiveDecimalWritable) {
            return ((HiveDecimalWritable)value).getHiveDecimal().bigDecimalValue();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toSqlTimestamp();
        }
        if (value instanceof Double && column.getType() == Type.FLOAT) {
            return Float.valueOf(((Double)value).floatValue());
        }
        return value;
    }
}

