/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.proto;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.ToStringOutputArchive;
import org.apache.jute.Utils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ConnectRequest
implements Record {
    private int protocolVersion;
    private long lastZxidSeen;
    private int timeOut;
    private long sessionId;
    private byte[] passwd;
    private boolean readOnly;

    public ConnectRequest() {
    }

    public ConnectRequest(int protocolVersion, long lastZxidSeen, int timeOut, long sessionId, byte[] passwd, boolean readOnly) {
        this.protocolVersion = protocolVersion;
        this.lastZxidSeen = lastZxidSeen;
        this.timeOut = timeOut;
        this.sessionId = sessionId;
        this.passwd = passwd;
        this.readOnly = readOnly;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int m_) {
        this.protocolVersion = m_;
    }

    public long getLastZxidSeen() {
        return this.lastZxidSeen;
    }

    public void setLastZxidSeen(long m_) {
        this.lastZxidSeen = m_;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int m_) {
        this.timeOut = m_;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long m_) {
        this.sessionId = m_;
    }

    public byte[] getPasswd() {
        return this.passwd;
    }

    public void setPasswd(byte[] m_) {
        this.passwd = m_;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean m_) {
        this.readOnly = m_;
    }

    @Override
    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeInt(this.protocolVersion, "protocolVersion");
        a_.writeLong(this.lastZxidSeen, "lastZxidSeen");
        a_.writeInt(this.timeOut, "timeOut");
        a_.writeLong(this.sessionId, "sessionId");
        a_.writeBuffer(this.passwd, "passwd");
        a_.writeBool(this.readOnly, "readOnly");
        a_.endRecord(this, tag);
    }

    @Override
    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.protocolVersion = a_.readInt("protocolVersion");
        this.lastZxidSeen = a_.readLong("lastZxidSeen");
        this.timeOut = a_.readInt("timeOut");
        this.sessionId = a_.readLong("sessionId");
        this.passwd = a_.readBuffer("passwd");
        this.readOnly = a_.readBool("readOnly");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s2 = new ByteArrayOutputStream();
            ToStringOutputArchive a_ = new ToStringOutputArchive(s2);
            a_.startRecord(this, "");
            a_.writeInt(this.protocolVersion, "protocolVersion");
            a_.writeLong(this.lastZxidSeen, "lastZxidSeen");
            a_.writeInt(this.timeOut, "timeOut");
            a_.writeLong(this.sessionId, "sessionId");
            a_.writeBuffer(this.passwd, "passwd");
            a_.writeBool(this.readOnly, "readOnly");
            a_.endRecord(this, "");
            return new String(s2.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public void write(DataOutput out) throws IOException {
        BinaryOutputArchive archive = new BinaryOutputArchive(out);
        this.serialize(archive, "");
    }

    public void readFields(DataInput in) throws IOException {
        BinaryInputArchive archive = new BinaryInputArchive(in);
        this.deserialize(archive, "");
    }

    public int compareTo(Object peer_) throws ClassCastException {
        if (!(peer_ instanceof ConnectRequest)) {
            throw new ClassCastException("Comparing different types of records.");
        }
        ConnectRequest peer = (ConnectRequest)peer_;
        int ret = 0;
        int n = this.protocolVersion == peer.protocolVersion ? 0 : (ret = this.protocolVersion < peer.protocolVersion ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        int n2 = this.lastZxidSeen == peer.lastZxidSeen ? 0 : (ret = this.lastZxidSeen < peer.lastZxidSeen ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        int n3 = this.timeOut == peer.timeOut ? 0 : (ret = this.timeOut < peer.timeOut ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        int n4 = this.sessionId == peer.sessionId ? 0 : (ret = this.sessionId < peer.sessionId ? -1 : 1);
        if (ret != 0) {
            return ret;
        }
        byte[] my = this.passwd;
        byte[] ur = peer.passwd;
        ret = Utils.compareBytes(my, 0, my.length, ur, 0, ur.length);
        if (ret != 0) {
            return ret;
        }
        int n5 = this.readOnly == peer.readOnly ? 0 : (ret = this.readOnly ? 1 : -1);
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof ConnectRequest)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ConnectRequest peer = (ConnectRequest)peer_;
        boolean ret = false;
        boolean bl = ret = this.protocolVersion == peer.protocolVersion;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.lastZxidSeen == peer.lastZxidSeen;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.timeOut == peer.timeOut;
        if (!ret) {
            return ret;
        }
        boolean bl4 = ret = this.sessionId == peer.sessionId;
        if (!ret) {
            return ret;
        }
        ret = Arrays.equals(this.passwd, peer.passwd);
        if (!ret) {
            return ret;
        }
        boolean bl5 = ret = this.readOnly == peer.readOnly;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = this.protocolVersion;
        result = 37 * result + ret;
        ret = Long.hashCode(this.lastZxidSeen);
        result = 37 * result + ret;
        ret = this.timeOut;
        result = 37 * result + ret;
        ret = Long.hashCode(this.sessionId);
        result = 37 * result + ret;
        ret = Arrays.hashCode(this.passwd);
        result = 37 * result + ret;
        ret = Boolean.hashCode(this.readOnly);
        result = 37 * result + ret;
        return result;
    }

    public static String signature() {
        return "LConnectRequest(ililBz)";
    }
}

