/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.common;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hive.org.apache.zookeeper.common.FileChangeWatcher;
import org.apache.hive.org.apache.zookeeper.common.FileKeyStoreLoaderBuilderProvider;
import org.apache.hive.org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.hive.org.apache.zookeeper.common.SSLContextAndOptions;
import org.apache.hive.org.apache.zookeeper.common.SecretUtils;
import org.apache.hive.org.apache.zookeeper.common.X509Exception;
import org.apache.hive.org.apache.zookeeper.common.ZKConfig;
import org.apache.hive.org.apache.zookeeper.common.ZKTrustManager;
import org.apache.hive.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class X509Util
implements Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);
    private static final String REJECT_CLIENT_RENEGOTIATION_PROPERTY = "jdk.tls.rejectClientInitiatedRenegotiation";
    private static final String FIPS_MODE_PROPERTY = "zookeeper.fips-mode";
    public static final String TLS_1_1 = "TLSv1.1";
    public static final String TLS_1_2 = "TLSv1.2";
    public static final String TLS_1_3 = "TLSv1.3";
    public static final String DEFAULT_PROTOCOL;
    private static final String[] DEFAULT_CIPHERS_JAVA8;
    private static final String[] DEFAULT_CIPHERS_JAVA9;
    public static final int DEFAULT_HANDSHAKE_DETECTION_TIMEOUT_MILLIS = 5000;
    private final String sslProtocolProperty = this.getConfigPrefix() + "protocol";
    private final String sslEnabledProtocolsProperty = this.getConfigPrefix() + "enabledProtocols";
    private final String cipherSuitesProperty = this.getConfigPrefix() + "ciphersuites";
    private final String sslKeystoreLocationProperty = this.getConfigPrefix() + "keyStore.location";
    private final String sslKeystorePasswdProperty = this.getConfigPrefix() + "keyStore.password";
    private final String sslKeystorePasswdPathProperty = this.getConfigPrefix() + "keyStore.passwordPath";
    private final String sslKeystoreTypeProperty = this.getConfigPrefix() + "keyStore.type";
    private final String sslTruststoreLocationProperty = this.getConfigPrefix() + "trustStore.location";
    private final String sslTruststorePasswdProperty = this.getConfigPrefix() + "trustStore.password";
    private final String sslTruststorePasswdPathProperty = this.getConfigPrefix() + "trustStore.passwordPath";
    private final String sslTruststoreTypeProperty = this.getConfigPrefix() + "trustStore.type";
    private final String sslContextSupplierClassProperty = this.getConfigPrefix() + "context.supplier.class";
    private final String sslHostnameVerificationEnabledProperty = this.getConfigPrefix() + "hostnameVerification";
    private final String sslCrlEnabledProperty = this.getConfigPrefix() + "crl";
    private final String sslOcspEnabledProperty = this.getConfigPrefix() + "ocsp";
    private final String sslClientAuthProperty = this.getConfigPrefix() + "clientAuth";
    private final String sslHandshakeDetectionTimeoutMillisProperty = this.getConfigPrefix() + "handshakeDetectionTimeoutMillis";
    private final AtomicReference<SSLContextAndOptions> defaultSSLContextAndOptions = new AtomicReference<Object>(null);
    private FileChangeWatcher keyStoreFileWatcher = null;
    private FileChangeWatcher trustStoreFileWatcher = null;

    private static String defaultTlsProtocol() {
        String defaultProtocol = TLS_1_2;
        List<Object> supported = new ArrayList();
        try {
            supported = Arrays.asList(SSLContext.getDefault().getSupportedSSLParameters().getProtocols());
            if (supported.contains(TLS_1_3)) {
                defaultProtocol = TLS_1_3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        LOG.info("Default TLS protocol is {}, supported TLS protocols are {}", (Object)defaultProtocol, (Object)supported);
        return defaultProtocol;
    }

    private static String[] getTLSv13Ciphers() {
        return new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256"};
    }

    private static String[] getGCMCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    }

    private static String[] getCBCCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"};
    }

    private static String[] getSupportedCiphers(String[] ... cipherLists) {
        List<String> supported = Arrays.asList(((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites());
        return Arrays.stream(cipherLists).flatMap(Arrays::stream).filter(supported::contains).collect(Collectors.toList()).toArray(new String[0]);
    }

    protected abstract String getConfigPrefix();

    protected abstract boolean shouldVerifyClientHostname();

    public String getSslProtocolProperty() {
        return this.sslProtocolProperty;
    }

    public String getSslEnabledProtocolsProperty() {
        return this.sslEnabledProtocolsProperty;
    }

    public String getCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystoreLocationProperty() {
        return this.sslKeystoreLocationProperty;
    }

    public String getSslCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystorePasswdProperty() {
        return this.sslKeystorePasswdProperty;
    }

    public String getSslKeystorePasswdPathProperty() {
        return this.sslKeystorePasswdPathProperty;
    }

    public String getSslKeystoreTypeProperty() {
        return this.sslKeystoreTypeProperty;
    }

    public String getSslTruststoreLocationProperty() {
        return this.sslTruststoreLocationProperty;
    }

    public String getSslTruststorePasswdProperty() {
        return this.sslTruststorePasswdProperty;
    }

    public String getSslTruststorePasswdPathProperty() {
        return this.sslTruststorePasswdPathProperty;
    }

    public String getSslTruststoreTypeProperty() {
        return this.sslTruststoreTypeProperty;
    }

    public String getSslContextSupplierClassProperty() {
        return this.sslContextSupplierClassProperty;
    }

    public String getSslHostnameVerificationEnabledProperty() {
        return this.sslHostnameVerificationEnabledProperty;
    }

    public String getSslCrlEnabledProperty() {
        return this.sslCrlEnabledProperty;
    }

    public String getSslOcspEnabledProperty() {
        return this.sslOcspEnabledProperty;
    }

    public String getSslClientAuthProperty() {
        return this.sslClientAuthProperty;
    }

    public String getSslHandshakeDetectionTimeoutMillisProperty() {
        return this.sslHandshakeDetectionTimeoutMillisProperty;
    }

    public String getFipsModeProperty() {
        return FIPS_MODE_PROPERTY;
    }

    public boolean getFipsMode(ZKConfig config) {
        return config.getBoolean(FIPS_MODE_PROPERTY, true);
    }

    public boolean isServerHostnameVerificationEnabled(ZKConfig config) {
        return config.getBoolean(this.getSslHostnameVerificationEnabledProperty(), true);
    }

    public boolean isClientHostnameVerificationEnabled(ZKConfig config) {
        return this.isServerHostnameVerificationEnabled(config) && this.shouldVerifyClientHostname();
    }

    public SSLContext getDefaultSSLContext() throws X509Exception.SSLContextException {
        return this.getDefaultSSLContextAndOptions().getSSLContext();
    }

    public SSLContext createSSLContext(ZKConfig config) throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(config).getSSLContext();
    }

    public SSLContextAndOptions getDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions result = this.defaultSSLContextAndOptions.get();
        if (result == null && !this.defaultSSLContextAndOptions.compareAndSet(null, result = this.createSSLContextAndOptions())) {
            result = this.defaultSSLContextAndOptions.get();
        }
        return result;
    }

    private void resetDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions newContext = this.createSSLContextAndOptions();
        this.defaultSSLContextAndOptions.set(newContext);
        if (Boolean.getBoolean("zookeeper.client.certReload")) {
            ProviderRegistry.addOrUpdateProvider("zookeeper.authProvider.x509");
        }
    }

    private SSLContextAndOptions createSSLContextAndOptions() throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(new ZKConfig());
    }

    public int getSslHandshakeTimeoutMillis() {
        try {
            SSLContextAndOptions ctx = this.getDefaultSSLContextAndOptions();
            return ctx.getHandshakeDetectionTimeoutMillis();
        }
        catch (X509Exception.SSLContextException e) {
            LOG.error("Error creating SSL context and options", e);
            return 5000;
        }
        catch (Exception e) {
            LOG.error("Error parsing config property {}", (Object)this.getSslHandshakeDetectionTimeoutMillisProperty(), (Object)e);
            return 5000;
        }
    }

    public SSLContextAndOptions createSSLContextAndOptions(ZKConfig config) throws X509Exception.SSLContextException {
        String supplierContextClassName = config.getProperty(this.sslContextSupplierClassProperty);
        if (supplierContextClassName != null) {
            LOG.debug("Loading SSLContext supplier from property '{}'", (Object)this.sslContextSupplierClassProperty);
            try {
                Class<?> sslContextClass = Class.forName(supplierContextClassName);
                Supplier sslContextSupplier = (Supplier)sslContextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return new SSLContextAndOptions(this, config, (SSLContext)sslContextSupplier.get());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new X509Exception.SSLContextException("Could not retrieve the SSLContext from supplier source '" + supplierContextClassName + "' provided in the property '" + this.sslContextSupplierClassProperty + "'", e);
            }
        }
        return this.createSSLContextAndOptionsFromConfig(config);
    }

    public SSLContextAndOptions createSSLContextAndOptionsFromConfig(ZKConfig config) throws X509Exception.SSLContextException {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        String keyStoreLocationProp = config.getProperty(this.sslKeystoreLocationProperty, "");
        String keyStorePasswordProp = this.getPasswordFromConfigPropertyOrFile(config, this.sslKeystorePasswdProperty, this.sslKeystorePasswdPathProperty);
        String keyStoreTypeProp = config.getProperty(this.sslKeystoreTypeProperty);
        if (keyStoreLocationProp.isEmpty()) {
            LOG.warn("{} not specified", (Object)this.getSslKeystoreLocationProperty());
        } else {
            try {
                keyManagers = new KeyManager[]{X509Util.createKeyManager(keyStoreLocationProp, keyStorePasswordProp, keyStoreTypeProp)};
            }
            catch (X509Exception.KeyManagerException keyManagerException) {
                throw new X509Exception.SSLContextException("Failed to create KeyManager", keyManagerException);
            }
            catch (IllegalArgumentException e) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslKeystoreTypeProperty + ": " + keyStoreTypeProp, e);
            }
        }
        String trustStoreLocationProp = config.getProperty(this.sslTruststoreLocationProperty, "");
        String trustStorePasswordProp = this.getPasswordFromConfigPropertyOrFile(config, this.sslTruststorePasswdProperty, this.sslTruststorePasswdPathProperty);
        String trustStoreTypeProp = config.getProperty(this.sslTruststoreTypeProperty);
        boolean sslCrlEnabled = config.getBoolean(this.sslCrlEnabledProperty);
        boolean sslOcspEnabled = config.getBoolean(this.sslOcspEnabledProperty);
        boolean sslServerHostnameVerificationEnabled = this.isServerHostnameVerificationEnabled(config);
        boolean sslClientHostnameVerificationEnabled = this.isClientHostnameVerificationEnabled(config);
        boolean fipsMode = this.getFipsMode(config);
        if (trustStoreLocationProp.isEmpty()) {
            LOG.warn("{} not specified", (Object)this.getSslTruststoreLocationProperty());
        } else {
            try {
                trustManagers = new TrustManager[]{X509Util.createTrustManager(trustStoreLocationProp, trustStorePasswordProp, trustStoreTypeProp, sslCrlEnabled, sslOcspEnabled, sslServerHostnameVerificationEnabled, sslClientHostnameVerificationEnabled, fipsMode)};
            }
            catch (X509Exception.TrustManagerException trustManagerException) {
                throw new X509Exception.SSLContextException("Failed to create TrustManager", trustManagerException);
            }
            catch (IllegalArgumentException e) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslTruststoreTypeProperty + ": " + trustStoreTypeProp, e);
            }
        }
        String protocol = config.getProperty(this.sslProtocolProperty, DEFAULT_PROTOCOL);
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, trustManagers, null);
            return new SSLContextAndOptions(this, config, sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException sslContextInitException) {
            throw new X509Exception.SSLContextException(sslContextInitException);
        }
    }

    public static KeyStore loadKeyStore(String keyStoreLocation, String keyStorePassword, String keyStoreTypeProp) throws IOException, GeneralSecurityException {
        KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(keyStoreTypeProp, keyStoreLocation);
        return FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setKeyStorePath(keyStoreLocation).setKeyStorePassword(keyStorePassword).build().loadKeyStore();
    }

    public static KeyStore loadTrustStore(String trustStoreLocation, String trustStorePassword, String trustStoreTypeProp) throws IOException, GeneralSecurityException {
        KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(trustStoreTypeProp, trustStoreLocation);
        return FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setTrustStorePath(trustStoreLocation).setTrustStorePassword(trustStorePassword).build().loadTrustStore();
    }

    public String getPasswordFromConfigPropertyOrFile(ZKConfig config, String propertyName, String pathPropertyName) {
        String value = config.getProperty(propertyName, "");
        String pathProperty = config.getProperty(pathPropertyName, "");
        if (!pathProperty.isEmpty()) {
            value = String.valueOf(SecretUtils.readSecret(pathProperty));
        }
        return value;
    }

    public static X509KeyManager createKeyManager(String keyStoreLocation, String keyStorePassword, String keyStoreTypeProp) throws X509Exception.KeyManagerException {
        if (keyStorePassword == null) {
            keyStorePassword = "";
        }
        try {
            KeyStore ks = X509Util.loadKeyStore(keyStoreLocation, keyStorePassword, keyStoreTypeProp);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, keyStorePassword.toCharArray());
            for (KeyManager km4 : kmf.getKeyManagers()) {
                if (!(km4 instanceof X509KeyManager)) continue;
                return (X509KeyManager)km4;
            }
            throw new X509Exception.KeyManagerException("Couldn't find X509KeyManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new X509Exception.KeyManagerException(e);
        }
    }

    public static X509TrustManager createTrustManager(String trustStoreLocation, String trustStorePassword, String trustStoreTypeProp, boolean crlEnabled, boolean ocspEnabled, boolean serverHostnameVerificationEnabled, boolean clientHostnameVerificationEnabled, boolean fipsMode) throws X509Exception.TrustManagerException {
        if (trustStorePassword == null) {
            trustStorePassword = "";
        }
        try {
            KeyStore ts = X509Util.loadTrustStore(trustStoreLocation, trustStorePassword, trustStoreTypeProp);
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(ts, (CertSelector)new X509CertSelector());
            if (crlEnabled || ocspEnabled) {
                pbParams.setRevocationEnabled(true);
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                System.setProperty("com.sun.security.enableCRLDP", "true");
                if (ocspEnabled) {
                    Security.setProperty("ocsp.enable", "true");
                }
            } else {
                pbParams.setRevocationEnabled(false);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(new CertPathTrustManagerParameters(pbParams));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                if (fipsMode) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("FIPS mode is ON: selecting standard x509 trust manager {}", (Object)tm);
                    }
                    return (X509TrustManager)tm;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("FIPS mode is OFF: creating ZKTrustManager");
                }
                return new ZKTrustManager((X509ExtendedTrustManager)tm, serverHostnameVerificationEnabled, clientHostnameVerificationEnabled);
            }
            throw new X509Exception.TrustManagerException("Couldn't find X509TrustManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new X509Exception.TrustManagerException(e);
        }
    }

    public SSLSocket createSSLSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket();
    }

    public SSLSocket createSSLSocket(Socket socket, byte[] pushbackBytes) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket(socket, pushbackBytes);
    }

    public SSLServerSocket createSSLServerSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket();
    }

    public SSLServerSocket createSSLServerSocket(int port) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket(port);
    }

    static String[] getDefaultCipherSuites() {
        return X509Util.getDefaultCipherSuitesForJavaVersion(System.getProperty("java.specification.version"));
    }

    static String[] getDefaultCipherSuitesForJavaVersion(String javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.matches("\\d+")) {
            LOG.debug("Using Java9+ optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA9;
        }
        if (javaVersion.startsWith("1.")) {
            LOG.debug("Using Java8 optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA8;
        }
        LOG.debug("Could not parse java version {}, using Java8 optimized cipher suites", (Object)javaVersion);
        return DEFAULT_CIPHERS_JAVA8;
    }

    private FileChangeWatcher newFileChangeWatcher(String fileLocation) throws IOException {
        if (fileLocation == null || fileLocation.isEmpty()) {
            return null;
        }
        Path filePath = Paths.get(fileLocation, new String[0]).toAbsolutePath();
        Path parentPath = filePath.getParent();
        if (parentPath == null) {
            throw new IOException("Key/trust store path does not have a parent: " + filePath);
        }
        return new FileChangeWatcher(parentPath, watchEvent -> this.handleWatchEvent(filePath, (WatchEvent<?>)watchEvent));
    }

    public void enableCertFileReloading() throws IOException {
        FileChangeWatcher newTrustStoreFileWatcher;
        LOG.info("enabling cert file reloading");
        ZKConfig config = new ZKConfig();
        FileChangeWatcher newKeyStoreFileWatcher = this.newFileChangeWatcher(config.getProperty(this.sslKeystoreLocationProperty));
        if (newKeyStoreFileWatcher != null) {
            if (this.keyStoreFileWatcher != null) {
                this.keyStoreFileWatcher.stop();
            }
            this.keyStoreFileWatcher = newKeyStoreFileWatcher;
            this.keyStoreFileWatcher.start();
        }
        if ((newTrustStoreFileWatcher = this.newFileChangeWatcher(config.getProperty(this.sslTruststoreLocationProperty))) != null) {
            if (this.trustStoreFileWatcher != null) {
                this.trustStoreFileWatcher.stop();
            }
            this.trustStoreFileWatcher = newTrustStoreFileWatcher;
            this.trustStoreFileWatcher.start();
        }
    }

    @Override
    public void close() {
        this.defaultSSLContextAndOptions.set(null);
        if (this.keyStoreFileWatcher != null) {
            this.keyStoreFileWatcher.stop();
            this.keyStoreFileWatcher = null;
        }
        if (this.trustStoreFileWatcher != null) {
            this.trustStoreFileWatcher.stop();
            this.trustStoreFileWatcher = null;
        }
    }

    private void handleWatchEvent(Path filePath, WatchEvent<?> event) {
        Path eventFilePath;
        boolean shouldResetContext = false;
        Path dirPath = filePath.getParent();
        if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
            shouldResetContext = true;
        } else if ((event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) || event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE)) && filePath.equals(eventFilePath = dirPath.resolve((Path)event.context()))) {
            shouldResetContext = true;
        }
        if (shouldResetContext) {
            LOG.debug("Attempting to reset default SSL context after receiving watch event: {} with context: {}", (Object)event.kind(), event.context());
            try {
                this.resetDefaultSSLContextAndOptions();
            }
            catch (X509Exception.SSLContextException e) {
                throw new RuntimeException(e);
            }
        } else {
            LOG.debug("Ignoring watch event and keeping previous default SSL context. Event kind: {} with context: {}", (Object)event.kind(), event.context());
        }
    }

    static {
        if (System.getProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY) == null) {
            LOG.info("Setting -D {}=true to disable client-initiated TLS renegotiation", (Object)REJECT_CLIENT_RENEGOTIATION_PROPERTY);
            System.setProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY, Boolean.TRUE.toString());
        }
        DEFAULT_PROTOCOL = X509Util.defaultTlsProtocol();
        DEFAULT_CIPHERS_JAVA8 = X509Util.getSupportedCiphers(X509Util.getCBCCiphers(), X509Util.getGCMCiphers(), X509Util.getTLSv13Ciphers());
        DEFAULT_CIPHERS_JAVA9 = X509Util.getSupportedCiphers(X509Util.getGCMCiphers(), X509Util.getCBCCiphers(), X509Util.getTLSv13Ciphers());
    }

    public static enum ClientAuth {
        NONE(org.apache.hive.io.netty.handler.ssl.ClientAuth.NONE),
        WANT(org.apache.hive.io.netty.handler.ssl.ClientAuth.OPTIONAL),
        NEED(org.apache.hive.io.netty.handler.ssl.ClientAuth.REQUIRE);

        private final org.apache.hive.io.netty.handler.ssl.ClientAuth nettyAuth;

        private ClientAuth(org.apache.hive.io.netty.handler.ssl.ClientAuth nettyAuth) {
            this.nettyAuth = nettyAuth;
        }

        public static ClientAuth fromPropertyValue(String prop) {
            if (prop == null || prop.length() == 0) {
                return NEED;
            }
            return ClientAuth.valueOf(prop.toUpperCase());
        }

        public org.apache.hive.io.netty.handler.ssl.ClientAuth toNettyClientAuth() {
            return this.nettyAuth;
        }
    }
}

