/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hive.org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class JniBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JniBasedUnixGroupsMapping.class);

    static native void anchorNative();

    static native String[] getGroupsForUser(String var0);

    private static void logError(int groupId, String error) {
        LOG.error("error looking up the name of group " + groupId + ": " + error);
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        return Arrays.asList(this.getGroupsInternal(user));
    }

    @Override
    public Set<String> getGroupsSet(String user) throws IOException {
        String[] groups = this.getGroupsInternal(user);
        LinkedHashSet<String> result = new LinkedHashSet<String>(groups.length);
        CollectionUtils.addAll(result, groups);
        return result;
    }

    private String[] getGroupsInternal(String user) throws IOException {
        String[] groups = new String[]{};
        try {
            groups = JniBasedUnixGroupsMapping.getGroupsForUser(user);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error getting groups for " + user, e);
            }
            LOG.info("Error getting groups for " + user + ": " + e.getMessage());
        }
        return groups;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            throw new RuntimeException("Bailing out since native library couldn't be loaded");
        }
        JniBasedUnixGroupsMapping.anchorNative();
        LOG.debug("Using JniBasedUnixGroupsMapping for Group resolution");
    }
}

